unit Modelo.Conexao;

interface

uses
  SysUtils, Classes, WideStrings, DB, SqlExpr, FMTBcd;

type
  TdtmdlConexao = class(TDataModule)
    sqlcnctnConcessionaria: TSQLConnection;
    sqldtstGeraCodigo: TSQLDataSet;
    procedure DataModuleCreate(Sender: TObject);
  private
    { Private declarations }
    function GerarCodigo(strngGerador: string): Integer;
  public
    { Public declarations }
    function GerarCodigoCliente: Integer;
    function GerarCodigoAutomovel: Integer;
    function GerarCodigoVenda: Integer;
    function GerarCodigoAgenda: Integer;
  end;

var
  dtmdlConexao: TdtmdlConexao;

implementation

uses
  Forms;

{$R *.dfm}

procedure TdtmdlConexao.DataModuleCreate(Sender: TObject);
begin
  sqlcnctnConcessionaria.Params.Values['DATABASE'] :=
    ExtractFilePath(Application.ExeName) + 'bd\CONCESSIONARIA.FDB';
end;

function TdtmdlConexao.GerarCodigo(strngGerador: string): Integer;
const
  STRNG_SQL_RECUPERA_GERADOR = 'SELECT GEN_ID(%s, 1) FROM RDB$DATABASE';
begin

  sqldtstGeraCodigo.CommandText := Format(STRNG_SQL_RECUPERA_GERADOR, [strngGerador]);
  sqldtstGeraCodigo.Open;
  try

    Result := sqldtstGeraCodigo.Fields[0].AsInteger;

  finally
    sqldtstGeraCodigo.Close;
  end;

end;

function TdtmdlConexao.GerarCodigoAutomovel: Integer;
begin
  Result := GerarCodigo('GERADOR_AUTOMOVEL');
end;

function TdtmdlConexao.GerarCodigoCliente: Integer;
begin
  Result := GerarCodigo('GERADOR_CLIENTE');
end;

function TdtmdlConexao.GerarCodigoVenda: Integer;
begin
  Result := GerarCodigo('GERADOR_VENDA');
end;

function TdtmdlConexao.GerarCodigoAgenda: Integer;
begin
  Result := GerarCodigo('GERADOR_AGENDA');
end;

end.
