unit Modelo.Venda;

interface

uses
  SysUtils, Classes, FMTBcd, DBClient, Provider, DB, SqlExpr;

type
  TdtmdlVenda = class(TDataModule)
    sqldtstListaVenda: TSQLDataSet;
    dtstprvdrListaVenda: TDataSetProvider;
    clntdtstListaVenda: TClientDataSet;
    clntdtstListaVendaCOD_AUTOMOVEL: TIntegerField;
    clntdtstListaVendaCOD_CLIENTE: TIntegerField;
    clntdtstListaVendaCOD_FORMA_PAGAMENTO: TIntegerField;
    clntdtstListaVendaCOD_VENDA: TIntegerField;
    clntdtstListaVendaDTH_VENDA: TDateField;
    clntdtstListaVendaDES_AUTOMOVEL: TStringField;
    clntdtstListaVendaDES_CLIENTE: TStringField;
    sqldtstFormaPagto: TSQLDataSet;
    dtstprvdrFormaPagto: TDataSetProvider;
    clntdtstFormaPagto: TClientDataSet;
    clntdtstFormaPagtoCOD_FORMA_PAGAMENTO: TIntegerField;
    clntdtstFormaPagtoDES_FORMA_PAGAMENTO: TStringField;
    clntdtstListaVendaDES_FORMA_PAGTO: TStringField;
    clntdtstListaVendaVAL_AUTOMOVEL: TFloatField;
    procedure DataModuleCreate(Sender: TObject);
    procedure clntdtstListaVendaReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
    procedure clntdtstListaVendaNewRecord(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  dtmdlVenda: TdtmdlVenda;

implementation

uses Modelo.Conexao, Modelo.Automovel, Modelo.Cliente, Dialogs;

{$R *.dfm}

procedure TdtmdlVenda.clntdtstListaVendaNewRecord(DataSet: TDataSet);
begin
  clntdtstListaVendaCOD_VENDA.Value := dtmdlConexao.GerarCodigoVenda;
end;

procedure TdtmdlVenda.clntdtstListaVendaReconcileError(
  DataSet: TCustomClientDataSet; E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  MessageDlg(E.Message, mtWarning, [mbOK], 0);
end;

procedure TdtmdlVenda.DataModuleCreate(Sender: TObject);
begin
  clntdtstFormaPagto.Open;
  dtmdlAutomovel.clntdtstListaAutomovel.Open;
  clntdtstListaVenda.Open;
end;

end.
