unit Visao.Ancestral.Lista;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Visao.Ancestral.Janela, cxStyles, dxSkinsCore,
  dxSkinsDefaultPainters, dxSkinscxPCPainter, cxCustomData, cxGraphics,
  cxFilter, cxData, cxDataStorage, cxEdit, DB, cxDBData, cxGridLevel, cxClasses,
  cxControls, cxGridCustomView, cxGridCustomTableView, cxGridTableView,
  cxGridDBTableView, cxGrid, DBClient, cxGridChartView, cxGridDBChartView,
  cxGridCardView, cxGridDBCardView, cxGridBandedTableView,
  cxGridDBBandedTableView, cxGridCustomPopupMenu, cxGridPopupMenu,
  cxGridExportLink, dxPSGlbl, dxPSUtl, dxPSEngn, dxPrnPg, dxBkgnd, dxWrap,
  dxPrnDev, dxPSCompsProvider, dxPSFillPatterns, dxPSEdgePatterns, dxPSCore,
  dxPScxCommon, dxPScxGrid6Lnk;

type
  TfrmAncestralLista = class(TfrmAncestralJanela)
    dtsrcLista: TDataSource;
    cxgrdLista: TcxGrid;
    VisaoTabela: TcxGridDBTableView;
    VisaoTabelaEmBanda: TcxGridDBBandedTableView;
    VisaoCartao: TcxGridDBCardView;
    VisaoGrafico: TcxGridDBChartView;
    cxgrdlvlTable: TcxGridLevel;
    cxgrdlvlBandedTable: TcxGridLevel;
    cxgrdlvlCard: TcxGridLevel;
    cxgrdlvlChart: TcxGridLevel;
    cxgrdpmnAcao: TcxGridPopupMenu;
    dxcmpntprntrImpressao: TdxComponentPrinter;
    dxcmpntprntrImpressaoLink: TdxGridReportLink;
  strict private
    function GetTabelaAtual: TClientDataSet;
    property TabelaAtual: TClientDataSet read GetTabelaAtual;
  public
    { Public declarations }
    procedure CriarNovoRegistro; virtual;
    procedure ExcluirRegistroSelecionado; virtual;
    procedure Salvar; virtual;
    procedure CancelarAlteracao; virtual;
    procedure ExportarGridTexto(const NomeArquivo: string); virtual;
    procedure ExportarGridXML(const NomeArquivo: string); virtual;
    procedure ExportarGridExcel(const NomeArquivo: string); virtual;
    procedure ImprimirGrid; virtual;
    procedure LocalizarTexto(strngTexto: string); virtual;
  end;

var
  frmAncestralLista: TfrmAncestralLista;

implementation

uses Modelo.Repositorio;

{$R *.dfm}

{ TfrmAncestralLista }

procedure TfrmAncestralLista.CancelarAlteracao;
begin
  TabelaAtual.CancelUpdates;
end;

procedure TfrmAncestralLista.CriarNovoRegistro;
begin
  TabelaAtual.Append;
end;

procedure TfrmAncestralLista.ExcluirRegistroSelecionado;
begin

  if MessageDlg('Confirma excluso do registro selecionado?', mtConfirmation,
      [mbYes, mbNo], 0, mbNo) = mrYes then begin

    TabelaAtual.Delete;
    Salvar;

  end;

end;

procedure TfrmAncestralLista.ExportarGridExcel(const NomeArquivo: string);
begin
  ExportGridToExcel(NomeArquivo, cxgrdLista);
end;

procedure TfrmAncestralLista.ExportarGridTexto(const NomeArquivo: string);
begin
  ExportGridToText(NomeArquivo, cxgrdLista);
end;

procedure TfrmAncestralLista.ExportarGridXML(const NomeArquivo: string);
begin
  ExportGridToXML(NomeArquivo, cxgrdLista);
end;

function TfrmAncestralLista.GetTabelaAtual: TClientDataSet;
begin
  Result := (dtsrcLista.DataSet as TClientDataSet);
  Assert(Assigned(Result));
end;

procedure TfrmAncestralLista.ImprimirGrid;
begin
  dxcmpntprntrImpressaoLink.ReportTitle.Text := Self.Caption;
  dxcmpntprntrImpressao.Preview;
end;

procedure TfrmAncestralLista.LocalizarTexto(strngTexto: string);
var
  intgrColuna: Integer;
begin

  for intgrColuna := 0 to VisaoTabela.ColumnCount - 1 do begin

    if VisaoTabela.DataController.Search.Locate(intgrColuna, strngTexto) then
      Break;

  end;

end;

procedure TfrmAncestralLista.Salvar;
begin
  TabelaAtual.ApplyUpdates(0);
end;

end.
