unit Visao.Principal;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, dxSkinsCore, dxSkinsDefaultPainters, dxSkinsdxNavBarPainter,
  ExtCtrls, dxNavBar, cxClasses, dxNavBarBase, dxNavBarCollns, dxRibbon,
  cxControls, dxBar, dxSkinsdxBarPainter, ActnList, dxBarExtItems, ImgList,
  cxGraphics,dxRibbonForm, dxStatusBar, dxRibbonStatusBar, dxSkinscxPCPainter,
  cxPC, dxNavBarStyles, cxProgressBar, cxBarEditItem, cxTextEdit, cxButtonEdit,
  dxRibbonGallery, dxBarExtDBItems, Visao.Ancestral.Lista, Visao.Ancestral.Janela,
  dxSkinscxSchedulerPainter, ExtActns;

const
  INTGR_SEM_ABA   = -1;

type

  TTelaDeListagem = class of TfrmAncestralJanela;

  TfrmPrincipal = class(TdxRibbonForm)
    dxNavBar1: TdxNavBar;
    dxnvbrgrpCadastro: TdxNavBarGroup;
    dxnvbrgrpCalendario: TdxNavBarGroup;
    dxnvbrgrpAnalise: TdxNavBarGroup;
    dxnvbrtmCliente: TdxNavBarItem;
    dxnvbrtmAutomovel: TdxNavBarItem;
    dxnvbrtmVenda: TdxNavBarItem;
    dxnvbrtmMarcarContato: TdxNavBarItem;
    dxnvbrtmCalendario: TdxNavBarItem;
    dxnvbrtmAnalisarVenda: TdxNavBarItem;
    dxrbnMenu: TdxRibbon;
    dxrbntbEdicao: TdxRibbonTab;
    dxrbntbAjuda: TdxRibbonTab;
    dxBarManager1: TdxBarManager;
    dxbrCadastro: TdxBar;
    actnlstPrincipal: TActionList;
    actnCadastroCliente: TAction;
    actnCadastroAutomovel: TAction;
    actnRegistraVenda: TAction;
    actnMarcarContato: TAction;
    actnCalendario: TAction;
    actnAnaliseCliente: TAction;
    actnAnaliseVenda: TAction;
    dxBarApplicationMenu1: TdxBarApplicationMenu;
    actnSair: TAction;
    dxBarScreenTipRepository1: TdxBarScreenTipRepository;
    dxBarScreenTipRepository1ScreenTip1: TdxBarScreenTip;
    dxbrAcessoRapido: TdxBar;
    dxbrbtnAnaliseVenda: TdxBarButton;
    dxBarButton2: TdxBarButton;
    dxbrscrntpDicaVenda: TdxBarScreenTip;
    cximglstMenor: TcxImageList;
    cximglstMaior: TcxImageList;
    dxRibbonPopupMenu1: TdxRibbonPopupMenu;
    dxRibbonStatusBar1: TdxRibbonStatusBar;
    dxnvbrgrpCadastroControl: TdxNavBarGroupControl;
    dxnvbrstyltmFundo: TdxNavBarStyleItem;
    ScrollBox1: TScrollBox;
    Splitter1: TSplitter;
    dxbrProgresso: TdxBar;
    cxBarEditItem3: TcxBarEditItem;
    cxpgcntrlTelas: TcxPageControl;
    actnNovoRegistro: TAction;
    actnExcluiRegistro: TAction;
    actnSalvaRegistro: TAction;
    actnCancela: TAction;
    actnImprimeGrid: TAction;
    actnExportaGrid: TAction;
    dxBarLargeButton1: TdxBarLargeButton;
    dxBarLargeButton2: TdxBarLargeButton;
    dxBarLargeButton4: TdxBarLargeButton;
    dxBarLargeButton5: TdxBarLargeButton;
    dxBarLargeButton8: TdxBarLargeButton;
    dxBarLargeButton9: TdxBarLargeButton;
    dxbrSaida: TdxBar;
    dxbrbtnTXT: TdxBarButton;
    dxbrbtnXML: TdxBarButton;
    dxbrbtnXLS: TdxBarButton;
    dxBarSubItem1: TdxBarSubItem;
    dxBarSeparator5: TdxBarSeparator;
    dxBarLargeButton10: TdxBarLargeButton;
    dxBarButton7: TdxBarButton;
    dxBarButton8: TdxBarButton;
    dxrbntbPesquisa: TdxRibbonTab;
    dxbrPesquisa: TdxBar;
    cxbrdtmLocalizaTexto: TcxBarEditItem;
    dxbrbtnBackup: TdxBarButton;
    dxbrbtnRestauraBackup: TdxBarButton;
    dxbrbtnFechar: TdxBarButton;
    dxbrbtnSair: TdxBarButton;
    actnFechaAba: TAction;
    actnBackup: TAction;
    actnRestaura: TAction;
    dxbrbtnImprimeGrid: TdxBarButton;
    svdlgExportaGrid: TSaveDialog;
    dxBarEdit1: TdxBarEdit;
    dxBarEdit2: TdxBarEdit;
    dxBarLargeButton3: TdxBarLargeButton;
    dxBarLargeButton6: TdxBarLargeButton;
    actnDevExpressVCL: TFileRun;
    actnForumDevExpress: TFileRun;
    actnComunidade: TFileRun;
    actnBlogDevExpress: TFileRun;
    dxBarLargeButton7: TdxBarLargeButton;
    dxBarLargeButton11: TdxBarLargeButton;
    procedure actnSairExecute(Sender: TObject);
    procedure actnAnaliseClienteExecute(Sender: TObject);
    procedure actnAnaliseVendaExecute(Sender: TObject);
    procedure actnCadastroClienteExecute(Sender: TObject);
    procedure actnCadastroAutomovelExecute(Sender: TObject);
    procedure actnRegistraVendaExecute(Sender: TObject);
    procedure actnMarcarContatoExecute(Sender: TObject);
    procedure actnCalendarioExecute(Sender: TObject);
    procedure actnNovoRegistroExecute(Sender: TObject);
    procedure actnExcluiRegistroExecute(Sender: TObject);
    procedure actnSalvaRegistroExecute(Sender: TObject);
    procedure actnCancelaExecute(Sender: TObject);
    procedure actnImprimeGridExecute(Sender: TObject);
    procedure actnExportaGridExecute(Sender: TObject);
    procedure actnBackupExecute(Sender: TObject);
    procedure actnFechaAbaExecute(Sender: TObject);
    procedure actnRestauraExecute(Sender: TObject);
    procedure actnlstPrincipalUpdate(Action: TBasicAction;
      var Handled: Boolean);
    procedure cxpgcntrlTelasChange(Sender: TObject);
    procedure dxbrbtnXLSClick(Sender: TObject);
    procedure dxbrbtnTXTClick(Sender: TObject);
    procedure dxbrbtnXMLClick(Sender: TObject);
    procedure cxbrdtmLocalizaTextoChange(Sender: TObject);
  private
    FTelaAtual: TfrmAncestralLista;
    { Private declarations }

    function VerificarIndiceAba(Tela: TForm): Integer;
    procedure CriarOuExibirAba(ClasseDaTela: TTelaDeListagem; var Tela);

    property TelaAtual: TfrmAncestralLista read FTelaAtual write FTelaAtual;
    procedure ExportarGrid(const NomeArquivo: string);
  public
    { Public declarations }
  end;

var
  frmPrincipal: TfrmPrincipal;

implementation

uses Modelo.Cliente, Visao.Lista.Cliente, DBClient, DB, Visao.Lista.Automovel,
  Visao.Lista.Venda, Modelo.Venda, Visao.Analise.Venda, Visao.Calendario;

{$R *.dfm}

procedure TfrmPrincipal.actnAnaliseClienteExecute(Sender: TObject);
begin
  //
end;

procedure TfrmPrincipal.actnAnaliseVendaExecute(Sender: TObject);
begin
  CriarOuExibirAba(TfrmAnaliseVenda, frmAnaliseVenda);
end;

procedure TfrmPrincipal.actnBackupExecute(Sender: TObject);
begin
  MessageDlg('Fazer backup...', mtInformation, [mbOK], 0);
end;

procedure TfrmPrincipal.actnCadastroAutomovelExecute(Sender: TObject);
begin
  CriarOuExibirAba(TfrmListaAutomovel, frmListaAutomovel);
end;

procedure TfrmPrincipal.actnCadastroClienteExecute(Sender: TObject);
begin
  CriarOuExibirAba(TfrmListaCliente, frmListaCliente);
end;

procedure TfrmPrincipal.actnCalendarioExecute(Sender: TObject);
begin
  CriarOuExibirAba(TfrmCalendario, frmCalendario);
end;

procedure TfrmPrincipal.actnCancelaExecute(Sender: TObject);
begin
  TelaAtual.CancelarAlteracao;
end;

procedure TfrmPrincipal.actnExcluiRegistroExecute(Sender: TObject);
begin
  TelaAtual.ExcluirRegistroSelecionado;
end;

procedure TfrmPrincipal.actnExportaGridExecute(Sender: TObject);
begin
  //
end;

procedure TfrmPrincipal.actnFechaAbaExecute(Sender: TObject);
begin

  TelaAtual := nil;
  if cxpgcntrlTelas.ActivePage <> nil then
    cxpgcntrlTelas.ActivePage.Free;

end;

procedure TfrmPrincipal.actnImprimeGridExecute(Sender: TObject);
begin
  TelaAtual.ImprimirGrid;
end;

procedure TfrmPrincipal.actnlstPrincipalUpdate(Action: TBasicAction;
  var Handled: Boolean);
begin

  try

    if (not Assigned(TelaAtual)) then
      Abort;

    actnNovoRegistro.Enabled := Assigned(TelaAtual);
    actnExcluiRegistro.Enabled := (actnNovoRegistro.Enabled) and (TelaAtual.dtsrcLista.DataSet.RecordCount > 0);
    actnExportaGrid.Enabled := actnExcluiRegistro.Enabled;
    actnImprimeGrid.Enabled := actnExportaGrid.Enabled;
    cxbrdtmLocalizaTexto.Enabled := actnImprimeGrid.Enabled;
    actnSalvaRegistro.Enabled := (actnNovoRegistro.Enabled) and
      ((TelaAtual.dtsrcLista.DataSet.State in dsEditModes) or
       (TClientDataSet(TelaAtual.dtsrcLista.DataSet).ChangeCount > 0));
    actnCancela.Enabled := actnSalvaRegistro.Enabled;

  except
    //log..
   actnNovoRegistro.Enabled := false;
    actnExcluiRegistro.Enabled := false;
    actnExportaGrid.Enabled := false;
    actnImprimeGrid.Enabled := false;
    cxbrdtmLocalizaTexto.Enabled := false;
    actnSalvaRegistro.Enabled := false;
    actnCancela.Enabled := false;
  end;

end;

procedure TfrmPrincipal.actnMarcarContatoExecute(Sender: TObject);
begin
  actnCalendario.Execute;
  frmCalendario.CriarNovoContato;
end;

procedure TfrmPrincipal.actnNovoRegistroExecute(Sender: TObject);
begin
  TelaAtual.CriarNovoRegistro;
end;

procedure TfrmPrincipal.actnRegistraVendaExecute(Sender: TObject);
begin

  if (not Assigned(dtmdlVenda)) then
    dtmdlVenda := TdtmdlVenda.Create(Self);

  CriarOuExibirAba(TfrmListaVenda, frmListaVenda);

end;

procedure TfrmPrincipal.actnRestauraExecute(Sender: TObject);
begin
  MessageDlg('Restaurar BD...', mtInformation, [mbOK], 0);
end;

procedure TfrmPrincipal.actnSairExecute(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TfrmPrincipal.actnSalvaRegistroExecute(Sender: TObject);
begin
  TelaAtual.Salvar;
end;

procedure TfrmPrincipal.CriarOuExibirAba(ClasseDaTela: TTelaDeListagem; var Tela);
var
  intgrIndiceAba: Integer;
  cxtbshtNovaAba: TcxTabSheet;
begin

  intgrIndiceAba := VerificarIndiceAba(TfrmAncestralJanela(Tela));

  if (intgrIndiceAba = INTGR_SEM_ABA) then begin

    TfrmAncestralJanela(Tela) := ClasseDaTela.Create(Self);

    cxtbshtNovaAba := TcxTabSheet.Create(Self);
    cxtbshtNovaAba.PageControl := cxpgcntrlTelas;
    cxtbshtNovaAba.Caption := TfrmAncestralJanela(Tela).Caption;
    TfrmAncestralJanela(Tela).Parent := cxtbshtNovaAba;

    cxpgcntrlTelas.ActivePage := cxtbshtNovaAba;

  end
  else
    cxpgcntrlTelas.ActivePageIndex := intgrIndiceAba;

  if TObject(Tela) is TfrmAncestralLista then
    TelaAtual := TfrmAncestralLista(Tela)
  else
    TelaAtual := nil;

  TfrmAncestralJanela(Tela).Show;
  TfrmAncestralJanela(Tela).BringToFront;

end;

procedure TfrmPrincipal.ExportarGrid(const NomeArquivo: string);
var
  strngExtensao: string;
begin

  strngExtensao := AnsiUpperCase(ExtractFileExt(NomeArquivo));
  if strngExtensao = '.XLS' then
    TelaAtual.ExportarGridExcel(NomeArquivo)
  else if strngExtensao = '.TXT' then
    TelaAtual.ExportarGridTexto(NomeArquivo)
  else if strngExtensao = '.XML' then
    TelaAtual.ExportarGridXML(NomeArquivo)
  else
    raise Exception.CreateFmt('Extenso no suportada: %s', [strngExtensao]);

end;

procedure TfrmPrincipal.cxbrdtmLocalizaTextoChange(Sender: TObject);
begin

  if cxbrdtmLocalizaTexto.EditValue <> Null then
    TelaAtual.LocalizarTexto(cxbrdtmLocalizaTexto.EditValue);

end;

procedure TfrmPrincipal.cxpgcntrlTelasChange(Sender: TObject);
begin

  if cxpgcntrlTelas.ActivePage <> nil then begin

    if cxpgcntrlTelas.ActivePage.ControlCount > 0 then begin

      if (cxpgcntrlTelas.ActivePage.Controls[0] is TfrmAncestralLista) then
        TelaAtual := TfrmAncestralLista(cxpgcntrlTelas.ActivePage.Controls[0])
      else
        TelaAtual := nil;

    end;

  end;

end;

procedure TfrmPrincipal.dxbrbtnTXTClick(Sender: TObject);
begin

  svdlgExportaGrid.FilterIndex := 3;
  if svdlgExportaGrid.Execute then
    ExportarGrid(svdlgExportaGrid.FileName);

end;

procedure TfrmPrincipal.dxbrbtnXMLClick(Sender: TObject);
begin

  svdlgExportaGrid.FilterIndex := 2;
  if svdlgExportaGrid.Execute then
    ExportarGrid(svdlgExportaGrid.FileName);

end;

procedure TfrmPrincipal.dxbrbtnXLSClick(Sender: TObject);
begin

  svdlgExportaGrid.FilterIndex := 1;
  if svdlgExportaGrid.Execute then
    ExportarGrid(svdlgExportaGrid.FileName);

end;

function TfrmPrincipal.VerificarIndiceAba(Tela: TForm): Integer;
var
  intgrAba: Integer;
begin

  Result := INTGR_SEM_ABA;
  for intgrAba := 0 to cxpgcntrlTelas.PageCount - 1 do begin

    if cxpgcntrlTelas.Pages[intgrAba].Controls[0] = Tela then begin
      Result := intgrAba;
      break;
    end;

  end;

end;

end.
