unit ApplicationCounter;

interface

uses Counter, System.Collections;

type
  TApplicationCounter = class(TCounter)
  private
    FCount,
    FCountUserOn : Int32;
    FLastVisit: DateTime;
    FPages: Hashtable;
    { Private Declarations }
  public
    constructor Create;
    property Count : Int32 read FCount;
    property CountUserOn : Int32 read FCountUserOn;
    property LastVisit : DateTime read FLastVisit;
    procedure Inc;
    property Pages : Hashtable read FPages;
    procedure IncPages( Key : String );
    procedure LoginUser;
    procedure LogoffUser;
  end;

implementation

{$AUTOBOX ON}

constructor TApplicationCounter.Create;
begin
  inherited Create;
  // TODO: Add any constructor code here
  FPages := Hashtable.Create;
end;

procedure TApplicationCounter.Inc;
begin
  FCount := FCount + 1;
  FLastVisit := DateTime.Now;
end;

procedure TApplicationCounter.IncPages(Key: String);
begin

  if not FPages.ContainsKey(Key) then
     FPages.Add(Key, Int32(1))
  else
     FPages.Item[Key] := Int32(FPages.Item[Key]) + 1;

end;

procedure TApplicationCounter.LoginUser;
begin
  FCountUserOn := FCountUserOn + 1;
end;

procedure TApplicationCounter.LogoffUser;
begin
  FCountUserOn := FCountUserOn - 1;
  if FCountUserOn < 0 then
     FCountUserOn := 0;
end;

end.
