unit BaseMasterPage;

interface

uses
  System.Web.UI, Borland.Data.AdoDbxClientProvider;

type
  TBaseMasterPage = class(System.Web.UI.MasterPage)
  strict private
    procedure InitializeComponent;
    procedure TBaseMasterPage_Unload(sender: TObject; e: System.EventArgs);
  protected
    { Private Declarations }
    FMyAdoDbxConnection : TAdoDbxConnection;
    procedure OnInit(e: EventArgs); override;
  public
    constructor Create;
    procedure UpdateHeader;virtual;
    function get_MyAdoDbxConnection: TAdoDbxConnection;
    property MyAdoDbxConnection : TAdoDbxConnection read get_MyAdoDbxConnection;
  end;

implementation

uses User;

constructor TBaseMasterPage.Create;
begin
  inherited Create;
  // TODO: Add any constructor code here
end;


function TBaseMasterPage.get_MyAdoDbxConnection: TAdoDbxConnection;
begin
  if not Assigned(FMyAdoDbxConnection) then
  begin

    FMyAdoDbxConnection := TAdoDbxProviderFactory.Instance.CreateConnection as TAdoDbxConnection;
    FMyAdoDbxConnection.ConnectionString := 'ConnectionName=' + TUser.ConnectioName;
    FMyAdoDbxConnection.Open;
  end;

  Result := FMyAdoDbxConnection;

end;

procedure TBaseMasterPage.InitializeComponent;
begin
  Include(Self.Unload, Self.TBaseMasterPage_Unload);
end;

procedure TBaseMasterPage.OnInit(e: EventArgs);
begin
  InitializeComponent;
  inherited OnInit(e);
  FMyAdoDbxConnection := nil;

end;

procedure TBaseMasterPage.TBaseMasterPage_Unload(sender: TObject;
  e: System.EventArgs);
begin
  if Assigned(FMyAdoDbxConnection) then
  begin
    FMyAdoDbxConnection.Close;
  end;
end;

procedure TBaseMasterPage.UpdateHeader;
begin

end;

end.
