
unit Default;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  System.Web.Security, System.Configuration, BasePage;

type
  TIndex = class(TBasePage)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    Content1: System.Web.UI.WebControls.Content;
    LBWarning: System.Web.UI.WebControls.&Label;
    Button2: System.Web.UI.WebControls.Button;
    RequiredFieldValidator3: System.Web.UI.WebControls.RequiredFieldValidator;
    tbPassword: System.Web.UI.WebControls.TextBox;
    Label4: System.Web.UI.WebControls.&Label;
    RequiredFieldValidator2: System.Web.UI.WebControls.RequiredFieldValidator;
    tbUser: System.Web.UI.WebControls.TextBox;
    Label2: System.Web.UI.WebControls.&Label;
    UpdatePanel1: System.Web.UI.UpdatePanel;
    Label1: System.Web.UI.WebControls.&Label;
    lbTheme: System.Web.UI.WebControls.ListBox;
    Label3: System.Web.UI.WebControls.&Label;
  protected
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
    function ValidateLogin: Boolean;
    procedure doValidate;
  public
    { Public Declarations }
  end;

implementation

uses User, ApplicationCounter, PCConsts, JavaScript;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TIndex.InitializeComponent;
begin
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

function TIndex.ValidateLogin: Boolean;
var
  user : TUser;
begin

  user := TUser.Create( tbUser.Text, tbPassword.Text, lbTheme.SelectedValue);
  Result := user.isValid;
  if Result then
  begin
    user.GenerateTicket;
    Session.Add(UserKey, user);
  end;

end;

procedure TIndex.doValidate;
var
  user : string;
begin
  user := tbUser.Text;

  if Page.IsValid and ValidateLogin then
  begin
    TApplicationCounter(Application.Item[AppCounterKey]).LoginUser;
    LBWarning.Visible := false;
    if HttpContext.Current.Request.QueryString['ReturnUrl'] = '' then
    begin
      FormsAuthentication.SetAuthCookie(user, False);
      HttpContext.Current.Response.Redirect('Pictures.aspx');
    end
    else
      FormsAuthentication.RedirectFromLoginPage(user, False);
  end
  else
  begin
    LBWarning.Visible := true;
  end;

end;

procedure TIndex.Page_Load(sender: System.Object; e: System.EventArgs);
begin
   // TODO: Put user code to initialize the page here
  TJavaScript.SetFocus(Page, tbUser, true);
  if IsPostBack then
  begin
    Page.Validate;
    doValidate;
  end;
end;

procedure TIndex.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

end.

