
unit Detail;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  System.Web.Security, System.Configuration, BasePage,
  Borland.Data.DBXCommon, Borland.Data.AdoDbxClientProvider,
  System.Data.Common;
  

type
  TDetail = class(TBasePage)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    Content1: System.Web.UI.WebControls.Content;
    lbPicName: System.Web.UI.WebControls.&Label;
    lbState: System.Web.UI.WebControls.&Label;
    lbCountry: System.Web.UI.WebControls.&Label;
    lbImage: System.Web.UI.WebControls.Image;
    lbCity: System.Web.UI.WebControls.&Label;
  protected
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

uses MasterPageSite, BaseMasterPage;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TDetail.InitializeComponent;
begin
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TDetail.Page_Load(sender: System.Object; e: System.EventArgs);
var
  cmd : DbCommand;
  Connection : TAdoDbxConnection;
  dr : TAdoDbxDataReader;
  param : String;
begin

  param := Request.QueryString.Item['id'];
  // TODO: Put user code to initialize the page here
  if param = '' then
     Response.Redirect('~/Pictures.aspx')
  else
  begin
    param := Request.QueryString.Item['id'];

    Connection := (Self.Master as TBaseMasterPage).MyAdoDbxConnection;

    cmd := Connection.CreateCommand() as TAdoDbxCommand;
    cmd.CommandText := 'SELECT C.ID_CITY, C.CITY, C.STATE, C.COUNTRY , P.PICTURE_NAME, P.ID_PICTURE ' +
                       ',P.PATH FROM PICTURES P, CITY C ' +
                       'Where C.ID_CITY = P.ID_CITY AND P.ID_PICTURE = ' + param;

    try
      dr := cmd.ExecuteReader as TAdoDbxDataReader;

      if dr.Read then
      begin

        lbPicName.Text := dr.GetString(dr.GetOrdinal('PICTURE_NAME'));
        lbState.Text := dr.GetString(dr.GetOrdinal('STATE'));
        lbCountry.Text := dr.GetString(dr.GetOrdinal('COUNTRY'));
        lbCity.Text := dr.GetString(dr.GetOrdinal('CITY'));
        lbImage.ImageUrl := dr.GetString(dr.GetOrdinal('PATH'));

      end;
      dr.Free;
      DataBind;
    finally
      cmd.Free;
      Connection.Close;
    end;
  end;

end;

procedure TDetail.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

end.

