unit Global;

interface

uses
  System.Collections, System.ComponentModel,
  System.Web, System.Web.SessionState,
  System.Security,
  System.Security.Principal,
  System.Configuration,
  System.Web.Security,
  System.Diagnostics,
  System.Net.Mail,
  ApplicationCounter;

type
  TGlobal = class(System.Web.HttpApplication)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict protected
    procedure Application_Start(sender: System.Object; e: EventArgs);
    procedure Session_Start(sender: System.Object; e: EventArgs);
    procedure Application_BeginRequest(sender: System.Object; e: EventArgs);
    procedure Application_EndRequest(sender: System.Object; e: EventArgs);
    procedure Application_AuthenticateRequest(sender: System.Object; e: EventArgs);
    procedure Application_Error(sender: System.Object; e: EventArgs);
    procedure Session_End(sender: System.Object; e: EventArgs);
    procedure Application_End(sender: System.Object; e: EventArgs);
  private
    { Private Declarations }
  public
    beginrequesttime : DateTime;
    constructor Create;
  end;

implementation

uses SessionCounter, PCConsts, Counter, User;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TGlobal.InitializeComponent;
begin

end;
{$ENDREGION}

constructor TGlobal.Create;
begin
  inherited;
  //
  // Required for Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TGlobal.Application_Start(sender: System.Object; e: EventArgs);
var
  appCounter : TApplicationCounter;
begin

  // Create TApplicationCounter object and put in Application scope
  appCounter := TApplicationCounter.Create;
  Application.Add(AppCounterKey, appCounter);
end;

procedure TGlobal.Session_Start(sender: System.Object; e: EventArgs);
var
  sessionCounter : TSessionCounter;
begin

  // Create TSessionCounter object and put in Session scope
  sessionCounter := TSessionCounter.Create;
  Session.Add(SessionCounterKey, sessionCounter);

  Session[MyMasterPageKey] := 'MasterPageSite.master';

end;

procedure TGlobal.Application_BeginRequest(sender: System.Object; e: EventArgs);
begin

  beginrequesttime := DateTime.Now;

  try
    // blocks other clients from modifying the variables stored
    // in the Application object, ensuring that only one client at a time
    // can alter or access the Application variables
    Application.Lock;

    // exclude statistics.aspx from statistics
    if Pos('statistics.aspx', Request.Url.AbsolutePath ) = 0 then
    begin
      TApplicationCounter(Application.Item[AppCounterKey]).Inc;
      TApplicationCounter(Application.Item[AppCounterKey]).IncPages(Request.Url.AbsolutePath);
    end;

  finally
    Application.UnLock
  end;


end;

procedure TGlobal.Application_EndRequest(sender: System.Object; e: EventArgs);
const
  msg : string = '<span style="color:wHITE;font-family:Verdana;font-size:12px;font-weight:bold;">Elapsed request time (ms) = {0}</span><br/>';
var
  difftime : TimeSpan;
begin

  // calculate request time
  difftime := DateTime.Now - beginrequesttime;

  if ConfigurationManager.AppSettings.Get('TraceTimeRequest') = 'on' then
  begin
     Response.Write(System.String.Format(msg, [difftime.Milliseconds]));
  end;
end;

procedure TGlobal.Application_AuthenticateRequest(sender: System.Object; e: EventArgs);
var
  authCookie: HttpCookie;
  authTicket: System.Web.Security.FormsAuthenticationTicket;
  identity: FormsIdentity;
  principal: GenericPrincipal;
begin

  authCookie := Context.Request.Cookies[FormsAuthentication.FormsCookieName];

  // Default.aspx generate authentication cookie
  if Assigned(authCookie) then
  begin
    authTicket := FormsAuthentication.Decrypt(authCookie.Value);

    // TUser object generate ticket information
    if Assigned(authTicket) then
    begin
      identity := FormsIdentity.Create(authTicket);

      // Define new IPrincipal and user roles
      // You can use Roles to define access in web site
      principal := GenericPrincipal.Create(identity, TUser.Create(authTicket.Name).GetRoles);
      Context.User := principal;
    end;

  end;
end;

procedure TGlobal.Application_Error(sender: System.Object; e: EventArgs);
var
  objError: Exception;
  msgerror : String;
  mail : MailMessage;
  smtp : SmtpClient;
begin

  if ( ConfigurationManager.AppSettings.Get('SMTPServer').Trim <> '' ) and
     ( ConfigurationManager.AppSettings.Get('MailNofication').Trim <> '' ) then
  begin
    objError := Server.GetLastError.GetBaseException;

    msgerror := objError.Message +  ' - ' + objError.StackTrace;

    // Prepare email
    mail :=  MailMessage.Create;
    mail.&To.Add(ConfigurationManager.AppSettings.Get('MailNofication'));
    mail.Subject := 'Error in the Site';
    mail.Priority := MailPriority.High;
//    mail.BodyFormat := MailFormat.Text;
    mail.Body := msgerror;

    // Send email
    smtp := SmtpClient.Create;
    smtp.Host := ConfigurationManager.AppSettings.Get('SMTPServer');
    smtp.Send(mail);
  end;

end;

procedure TGlobal.Session_End(sender: System.Object; e: EventArgs);
begin
  // Decrease number of user connected in web site
  TApplicationCounter(Application.Item[AppCounterKey]).LogoffUser;
end;

procedure TGlobal.Application_End(sender: System.Object; e: EventArgs);
begin

end;

end.

