unit Header;

interface

uses System.Data, System.Drawing, System.Web, System.Web.UI,
     System.Web.UI.WebControls, System.Web.UI.HtmlControls;
     
type
    /// <summary>
    /// Summary description for WebUserControl1.
    /// </summary>
  TWebUserControl1 = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
  lbHeader: System.Web.UI.WebControls.Label;
  lbAppCounter: System.Web.UI.WebControls.Label;
  hlHome: System.Web.UI.WebControls.HyperLink;
  hlStatistics: System.Web.UI.WebControls.HyperLink;
  hlLogoff: System.Web.UI.WebControls.HyperLink;
  lbPageCounter: System.Web.UI.WebControls.Label;
  lbUserOn: System.Web.UI.WebControls.Label;
    IMG1: System.Web.UI.HtmlControls.HtmlImage;
  protected
    procedure OnInit(e: System.EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

uses ApplicationCounter, PCConsts;

procedure TWebUserControl1.Page_Load(sender: System.Object; e: System.EventArgs);
Const
  msgapp = 'Web Site access count: {0} - Date/Time last visit: {1}';
  msgsession = 'Page access count: {0}';
  msguseron = 'Total logged-in users: {0}';
var
  appc : TApplicationCounter;
begin
  // TODO: Put user code to initialize the page here

  appc :=  TApplicationCounter(Application.Item[AppCounterKey]);

  lbAppCounter.Text := System.&String.Format(msgapp, appc.Count.ToString,
  appc.LastVisit.ToString );

  lbPageCounter.Text := System.&String.Format(msgsession,
                        appc.Pages.Item[Request.Url.AbsolutePath].toString );

  lbUserOn.Text := System.&String.Format(msguseron,
                        appc.CountUserOn.toString );

  hlStatistics.Visible := HttpContext.Current.User.Identity.IsAuthenticated;
  hlHome.Visible := HttpContext.Current.User.Identity.IsAuthenticated;
  hlLogoff.Visible := HttpContext.Current.User.Identity.IsAuthenticated;
end;

procedure TWebUserControl1.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebUserControl1.InitializeComponent;
begin
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


end.
