unit JavaScript;

interface

uses
  System.Web,
  System.Web.UI,
  System.Web.UI.HtmlControls,
  System.Web.UI.WebControls,
  System.Text;


type
  TJavaScript = class
  private
    { Private Declarations }
  public
    class procedure WriteStartScript(Code: StringBuilder);static;
    class procedure WriteEndScript(Code: StringBuilder);static;
    class procedure SetFocus( AOwner : System.Web.UI.Page; const AWebControls : WebControl; const ARegister : Boolean);static;
    class procedure RegisterStartupScript(AOwner : System.Web.UI.Page; Key: String; Code: StringBuilder);static;
  end;

implementation

class procedure TJavaScript.WriteStartScript(Code: StringBuilder);
begin
  Code.Append('<script language="javascript">' + Environment.NewLine);
end;

class procedure TJavaScript.WriteEndScript(Code: StringBuilder);
begin
  Code.Append('</script>' + Environment.NewLine);
end;

class procedure TJavaScript.SetFocus(AOwner : System.Web.UI.Page;
  const AWebControls: WebControl; const ARegister: Boolean);
var
 sb : StringBuilder;
begin
  sb := StringBuilder.Create;
  WriteStartScript(sb);
  sb.Append('document.getElementById("' + AWebControls.ClientID + '").focus()' + Environment.NewLine);
  WriteEndScript(sb);

  if ARegister then
    RegisterStartupScript(AOwner, AWebControls.ClientID + 'Select', sb);
end;

class procedure TJavaScript.RegisterStartupScript(AOwner : System.Web.UI.Page;
  Key: String; Code: StringBuilder);
begin

  if not AOwner.ClientScript.IsStartupScriptRegistered(AOwner.GetType, Key) then
    AOwner.ClientScript.RegisterStartupScript( AOwner.GetType, Key, Code.ToString);
end;

end.
