
unit Pictures;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, 
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  Borland.Data.AdoDbxClientProvider, BasePage,
  System.Data.Common, MasterPageSite, BaseMasterPage, MasterPageMenu;

type
  TPictures = class(TBasePage)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure GridView1_PageIndexChanging(sender: TObject; e: System.Web.UI.WebControls.GridViewPageEventArgs);
    procedure Button1_Click(sender: TObject; e: System.EventArgs);
    procedure GridView1_RowCommand(sender: TObject; e: System.Web.UI.WebControls.GridViewCommandEventArgs);
    procedure GridView1_RowCreated(sender: TObject; e: System.Web.UI.WebControls.GridViewRowEventArgs);
    procedure GridView1_DataBinding(sender: TObject; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    FileUpload1: System.Web.UI.WebControls.FileUpload;
    DbxDataSource1: Borland.Data.AdoDbxClientProvider.DbxDataSource;
    Content1: System.Web.UI.WebControls.Content;
    Button1: System.Web.UI.WebControls.Button;
    RequiredFieldValidator2: System.Web.UI.WebControls.RequiredFieldValidator;
    fuUpload: System.Web.UI.WebControls.FileUpload;
    RequiredFieldValidator1: System.Web.UI.WebControls.RequiredFieldValidator;
    tbDescription: System.Web.UI.WebControls.TextBox;
    lbCity: System.Web.UI.WebControls.ListBox;
    Label1: System.Web.UI.WebControls.&Label;
    UpdatePanel1: System.Web.UI.UpdatePanel;
    GridView1: System.Web.UI.WebControls.GridView;
  protected
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

uses User;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TPictures.InitializeComponent;
begin
  Include(Self.Button1.Click, Self.Button1_Click);
  Include(Self.GridView1.PageIndexChanging, Self.GridView1_PageIndexChanging);
  Include(Self.GridView1.RowCommand, Self.GridView1_RowCommand);
  Include(Self.GridView1.RowCreated, Self.GridView1_RowCreated);
  Include(Self.GridView1.DataBinding, Self.GridView1_DataBinding);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TPictures.Page_Load(sender: System.Object; e: System.EventArgs);
Const
  Sql : String = 'SELECT C.ID_CITY, C.CITY, C.STATE, C.COUNTRY , ' +
                 'P.PICTURE_NAME, P.ID_PICTURE ' +
                 'FROM PICTURES P, CITY C ' +
                 'Where C.ID_CITY = P.ID_CITY ' +
                 ' Order By C.COUNTRY, C.STATE, C.CITY';
  SqlCity : String = 'SELECT ID_CITY, CITY, STATE, COUNTRY, '+
                 ' (CITY || ''-'' || STATE || ''-'' || CITY) as DESCLIST ' +
                 'FROM CITY ' +
                 ' Order By COUNTRY, STATE, CITY';

var
  Connection : TAdoDbxConnection;
  cmd : TAdoDbxCommand;
begin


  // TODO: Put user code to initialize the page here
  // Using AdoDbxClient
  if not IsPostBack then
  begin
    Connection := TBaseMasterPage(Self.Master).MyAdoDbxConnection;
    cmd := Connection.CreateCommand as TAdoDbxCommand;
    cmd.CommandText := SqlCity;
    lbCity.DataSource := cmd.ExecuteReader;
  end;

  DataBind;

end;

procedure TPictures.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TPictures.GridView1_DataBinding(sender: TObject; e: System.EventArgs);
Const
  Sql : String = 'SELECT C.ID_CITY, C.CITY, C.STATE, C.COUNTRY , ' +
                 'P.PICTURE_NAME, P.ID_PICTURE ' +
                 'FROM PICTURES P, CITY C ' +
                 'Where C.ID_CITY = P.ID_CITY ' +
                 ' Order By C.COUNTRY, C.STATE, C.CITY';

  Key : Array[0..0] of String = ('ID_PICTURE');
var
  Connection : TAdoDbxConnection;
  sqladat : TAdoDbxDataAdapter;
  dt : DataTable;
begin
//  Connection := (Self.Master as TMasterPageSite).MyAdoDbxConnection;
// Bug in ASP.NET cannot execute typecast here
  Connection := TAdoDbxProviderFactory.Instance.CreateConnection as TAdoDbxConnection;
  Connection.ConnectionString := 'ConnectionName=' + TUser.ConnectioName;
  Connection.Open;

  sqladat := TAdoDbxDataAdapter.Create(Sql, Connection);
  dt := DataTable.Create;
  sqladat.Fill(dt);
  sqladat.Free;
  GridView1.DataSource := dt;

  Connection.Close;
  (Self.Master as TBaseMasterPage).UpdateHeader;


end;


procedure TPictures.GridView1_RowCreated(sender: TObject; e: System.Web.UI.WebControls.GridViewRowEventArgs);
var
   drv : DataRowView;
begin

  if (e.Row.RowType = DataControlRowType.DataRow) then
  begin
    drv := e.Row.DataItem as DataRowView;

    if Assigned(drv) then
    begin
      (e.Row.FindControl('lbDelete') as LinkButton ).CommandArgument := drv.Item['ID_PICTURE'].ToString;
      e.Row.Attributes.Add('onmouseover', 'this.className=''hightlighrow''');

      if (e.row.RowState = DataControlRowState.Normal ) then
         e.Row.Attributes.Add('onmouseout', 'this.className=''item''')
      else
         e.Row.Attributes.Add('onmouseout', 'this.className=''altitem''');
    end;
  end;

end;

procedure TPictures.GridView1_RowCommand(sender: TObject; e: System.Web.UI.WebControls.GridViewCommandEventArgs);
Const
  sql : String = 'Delete From Pictures Where ID_PICTURE = {0}';
var
  Connection : TAdoDbxConnection;
  cmddelete : TAdoDbxCommand;
  id : String;
begin
  id := e.CommandArgument.ToString;
  if ( e.CommandName = 'DeleteRow' ) and ( id <> '' )then
  begin

  // Using AdoDbxClient
    Connection := (Self.Master as TBaseMasterPage).MyAdoDbxConnection;

    cmddelete := Connection.CreateCommand as TAdoDbxCommand;
    cmddelete.CommandText := System.String.Format(sql, [id]);
    cmddelete.ExecuteNonQuery;
    cmddelete.Free;
    DataBind;

  end;

end;


procedure TPictures.Button1_Click(sender: TObject; e: System.EventArgs);
Const
  sql : String = 'Insert Into Pictures ( ID_PICTURE, ID_CITY, PICTURE_NAME, PATH) ' +
                           'Values ( {0}, {1}, ''{2}'', ''{3}'' )';
var
  Connection : TAdoDbxConnection;
  cmdinsert : TAdoDbxCommand;
  cmd : TAdoDbxCommand;
  nextid : Integer;
begin

  // TODO: Put user code to initialize the page here
  // Using AdoDbxClient

  if fuUpload.HasFile then
  begin
    fuUpload.SaveAs(Server.MapPath('images/' + fuUpload.FileName));

    Connection := (Self.Master as TBaseMasterPage).MyAdoDbxConnection;

    cmd := Connection.CreateCommand as TAdoDbxCommand;
    cmd.CommandText := 'Select Max(ID_PICTURE) From Pictures';
    nextid := (System.Convert.ToInt32(cmd.ExecuteScalar) + 1);

    cmdinsert := Connection.CreateCommand as TAdoDbxCommand;
    cmdinsert.CommandText := System.String.Format(sql, [nextid.ToString, lbCity.SelectedValue,
                                                        tbDescription.Text,
                                                        '~/images/' + fuUpload.FileName  ]);
    cmdinsert.ExecuteNonQuery;
    cmdinsert.Free;

    DataBind;
  end;

end;

procedure TPictures.GridView1_PageIndexChanging(sender: TObject; e: System.Web.UI.WebControls.GridViewPageEventArgs);
begin
  gridView1.PageIndex := e.NewPageIndex;
  DataBind;
end;

end.

