unit SessionCounter;

interface

uses Counter;

type
  TSessionCounter = class(TCounter)
  private
    FCount: Int32;
    FAppStartTime: DateTime;
    { Private Declarations }
  public
    constructor Create;
    property Count : Int32 read FCount;
    property AppStartTime : DateTime read FAppStartTime;
    procedure Inc;
  end;

implementation

constructor TSessionCounter.Create;
begin
  inherited Create;
  FAppStartTime := DateTime.Now;
end;

procedure TSessionCounter.Inc;
begin
  FCount := FCount + 1;
end;

end.
