unit User;

interface

uses System.Data,System.Collections, System.Configuration, Borland.Data.DBXCommon;

type
  TArrayStringList = Array of String;
  TUser = class
  private
    FName: String;
    FLogin: String;
    FisValid : Boolean;
    FConnection : TDBXConnection;
    FTheme: String;
    { Private Declarations }
    procedure Validate(sPassword : String );
    function GetConnection : TDBXConnection;
  public
    constructor Create( sLogin : String );reintroduce;overload;
    constructor Create( sLogin, sPassword, sTheme : String );reintroduce;overload;
    destructor Destroy;override;
    class function ConnectioName : String;
    function BuildConnectionFromConnectionName( ConnectionName: WideString): TDBXConnection;
    procedure GenerateTicket;
    procedure set_Theme(const Value: String);
    property Login : String read FLogin;
    property Name : String read FName;
    property isValid : boolean read FisValid;
    property Theme : String read FTheme write set_Theme;
    function GetRoles : TArrayStringList;
  end;

implementation

uses
  System.Web,
  System.Web.Security;

// Using DBXFramework
function TUser.BuildConnectionFromConnectionName(
  ConnectionName: WideString): TDBXConnection;
var
 ConnectionFactory: TDBXConnectionFactory;
 ConnectionProps: TDBXProperties;
begin
 ConnectionFactory := TDBXConnectionFactory.GetConnectionFactory;
 ConnectionProps := ConnectionFactory.GetConnectionProperties(ConnectionName);
 FConnection := ConnectionFactory.GetConnection(ConnectionProps );
 Result := FConnection;
end;

class function TUser.ConnectioName: String;
begin
  Result := ConfigurationManager.AppSettings['DatabaseAlias'];;
end;

constructor TUser.Create(sLogin, sPassword, sTheme : String);
begin
  inherited Create;
  // TODO: Add any constructor code here
  FLogin := sLogin;
  FisValid := False;
  FConnection := nil;
  FTheme := sTheme;

  Validate(sPassword);

  if isValid then
     GetRoles;

end;

destructor TUser.Destroy;
begin
  if Assigned(FConnection) then
     FConnection.Free;
  inherited Destroy;
end;

constructor TUser.Create(sLogin: String);
begin
  inherited Create;
  FLogin := sLogin;
  FConnection := nil;
end;

procedure TUser.GenerateTicket;
var
  authTicket: FormsAuthenticationTicket;
  authCookie: HttpCookie;
  encryptedTicket: string;
begin
    authTicket := FormsAuthenticationTicket.Create(
      1,                            // version
      FLogin,      // name
      DateTime.Now,                 // creation
      DateTime.Now.AddMinutes(HttpContext.Current.Session.Timeout),  // expiration
      False,                        // persistent,
      FLogin,                 // user data
      FormsAuthentication.FormsCookiePath);


    encryptedTicket := FormsAuthentication.Encrypt(authTicket);
    authCookie := HttpCookie.Create(FormsAuthentication.FormsCookieName, encryptedTicket);
    HttpContext.Current.Response.Cookies.Add(authCookie);

end;

function TUser.GetConnection: TDBXConnection;
begin
  if not Assigned(FConnection) then
     BuildConnectionFromConnectionName(ConnectioName);

  Result := FConnection;
end;

function TUser.GetRoles : TArrayStringList;
Const
  sql : String = 'SELECT ROLES.ROLE_NAME ' +
                 'FROM ROLES ' +
                 'INNER JOIN USER_ROLE ON (ROLES.ID_ROLE = USER_ROLE.ID_ROLE) ' +
                 'INNER JOIN USERS ON (USER_ROLE.ID_USER = USERS.ID_USER) ' +
                 'WHERE USERS.USER_LOGIN = ''{0}''';
var
  roles: ArrayList;
  i:integer;
  dr: TDBXReader;
  conn : TDBXConnection;
  cmdRole : TDBXCommand;
begin

  roles := ArrayList.Create;
  conn := GetConnection;
  cmdRole := conn.CreateCommand;
  try

    cmdRole.Text := System.&String.Format(sql, [FLogin]);
    dr := cmdRole.ExecuteQuery;

    { Tratamento especfico para ArrayList }
    while dr.Next do
      roles.Add(dr.Value[0]);

    dr.Free;
  finally
    cmdRole.Free;
    conn.Free;
    FConnection := nil;

  end;

  SetLength(result, roles.Count);
  for i := 0 to roles.Count-1 do
  begin
    result[i] := roles[i].ToString;
  end;

end;

procedure TUser.set_Theme(const Value: String);
begin
  FTheme := Value;
end;

procedure TUser.Validate(sPassword : String );
Const
 sql : String = 'SELECT ID_USER, NAME, USER_LOGIN, USER_PASSWORD ' +
            'FROM USERS WHERE USER_LOGIN = ''{0}'' and USER_PASSWORD = ''{1}''';
var
  dr: TDBXReader;
  conn : TDBXConnection;
  cmdUser : TDBXCommand;
begin


  FisValid := False;
  conn := GetConnection;
  cmdUser := conn.CreateCommand;
  cmdUser.Text := System.&String.Format(sql, [FLogin, sPassword]);
  cmdUser.Prepare;

  dr := CmdUser.ExecuteQuery;

  if Assigned( dr ) then
  begin
    if dr.Next then
    begin
      GenerateTicket;
      FisValid := True;
    end;
  end;
  dr.Free;
  cmdUser.Free;

end;

end.
