unit Statistics;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls;

type
  TWebForm1 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  procedure dgCounter_ItemDataBound(sender: System.Object; e: System.Web.UI.WebControls.DataGridItemEventArgs);
  procedure dgCounter_PageIndexChanged(source: System.Object; e: System.Web.UI.WebControls.DataGridPageChangedEventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
  dgCounter: System.Web.UI.WebControls.DataGrid;
  protected
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

uses ApplicationCounter;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm1.InitializeComponent;
begin
  Include(Self.dgCounter.PageIndexChanged, Self.dgCounter_PageIndexChanged);
  Include(Self.dgCounter.ItemDataBound, Self.dgCounter_ItemDataBound);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TWebForm1.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  // TODO: Put user code to initialize the page here
  dgCounter.DataSource := TApplicationCounter(Application.Item['ApplicationCounter']).Pages;
  dgCounter.DataBind;
end;

procedure TWebForm1.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TWebForm1.dgCounter_PageIndexChanged(source: System.Object; e: System.Web.UI.WebControls.DataGridPageChangedEventArgs);
begin
  dgCounter.CurrentPageIndex := e.NewPageIndex;
end;

procedure TWebForm1.dgCounter_ItemDataBound(sender: System.Object; e: System.Web.UI.WebControls.DataGridItemEventArgs);
var
  o : DictionaryEntry;
  appc : TApplicationCounter;
begin

  if e.Item.ItemType in [ListItemType.Item, ListItemType.AlternatingItem] then
  begin
    o := e.Item.DataItem as DictionaryEntry;

    &Label(e.Item.FindControl('lbPage')).Text := o.Key.ToString;
    &Label(e.Item.FindControl('lbTotal')).Text := o.Value.ToString;

  end
  else
    if e.Item.ItemType in [ ListItemType.Footer ] then
    begin
      appc :=  TApplicationCounter(Application.Item['ApplicationCounter']);
      &Label(e.Item.FindControl('lbVisit')).Text :=
      System.&String.Format('Last Visit: {0} ', appc.LastVisit.ToString );
    end;
end;

end.

