unit ucStatistics;

interface

uses System.Data, System.Drawing, System.Web, System.Web.UI,
     System.Web.UI.WebControls, System.Web.UI.HtmlControls,
     System.Web.Security, System.Web.UI.WebControls.WebParts, System.Configuration;
     
type
    /// <summary>
    /// Summary description for ucStatistics.
    /// </summary>
  TucStatistics = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure TucStatistics_DataBinding(sender: TObject; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    lbUserOn: System.Web.UI.WebControls.&Label;
    lbPageCounter: System.Web.UI.WebControls.&Label;
    lbAppCounter: System.Web.UI.WebControls.&Label;
    UpdatePanel1: System.Web.UI.UpdatePanel;
  protected
    procedure OnInit(e: System.EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
    procedure UpdateHeader;
  end;

implementation

uses ApplicationCounter, PCConsts;
 
procedure TucStatistics.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  // TODO: Put user code to initialize the page here
end;

procedure TucStatistics.UpdateHeader;
Const
  msgsession = 'Page access count: {0}';
  msguseron = 'Total logged-in users: {0}';
  msgapp = 'Web Site access count: {0} - Date/Time last visit: {1}';
var
  appc: TApplicationCounter;
begin
  // TODO: Put user code to initialize the page here
  appc := TApplicationCounter(Application.Item[AppCounterKey]);

  if not Request.Url.AbsolutePath.toString.Contains('Default.aspx') then
    if (not HttpContext.Current.User.Identity.IsAuthenticated) then
      Response.Redirect('Default.aspx');

  lbAppCounter.Text := System.String.Format(msgapp, appc.Count.ToString, appc.LastVisit.ToString);
  lbPageCounter.Text := System.String.Format(msgsession, appc.Pages.Item[Request.Url.AbsolutePath].toString);
  lbUserOn.Text := System.String.Format(msguseron, appc.CountUserOn.toString);
end;

procedure TucStatistics.TucStatistics_DataBinding(sender: TObject; e: System.EventArgs);
begin
  UpdateHeader;
end;

procedure TucStatistics.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TucStatistics.InitializeComponent;
begin
  Include(Self.Load, Self.Page_Load);
  Include(Self.DataBinding, Self.TucStatistics_DataBinding);
end;
{$ENDREGION}


end.
