unit ucThemeMasterPage;

interface

uses System.Data, System.Drawing, System.Web, System.Web.UI,
     System.Web.UI.WebControls, System.Web.UI.HtmlControls,
     System.Web.Security, System.Web.UI.WebControls.WebParts, System.Configuration;
     
type
    /// <summary>
    /// Summary description for ucThemeMasterPage.
    /// </summary>
  TucThemeMasterPage = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure lbMaster_SelectedIndexChanged(sender: TObject; e: System.EventArgs);
    procedure lbTheme_SelectedIndexChanged(sender: TObject; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    lbTheme: System.Web.UI.WebControls.ListBox;
    lbMasterPage: System.Web.UI.WebControls.ListBox;
  protected
    procedure OnInit(e: System.EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

uses User, PCConsts;

procedure TucThemeMasterPage.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  // TODO: Put user code to initialize the page here

  lbTheme.Visible := HttpContext.Current.User.Identity.IsAuthenticated;
  lbMasterPage.Visible := HttpContext.Current.User.Identity.IsAuthenticated;

  if lbTheme.Visible then
  begin
     if (not isPostBack ) and Assigned(Session[UserKey]) then
     begin
        lbTheme.SelectedValue := (Session[UserKey] as TUser).Theme;
        lbMasterPage.SelectedValue := Session[MyMasterPageKey].ToString;
     end;
  end;
end;

procedure TucThemeMasterPage.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TucThemeMasterPage.lbTheme_SelectedIndexChanged(sender: TObject; e: System.EventArgs);
begin
  if Assigned(Session[UserKey]) then
  begin
     (Session[UserKey] as TUser).Theme := lbTheme.SelectedValue;
     Response.Redirect(Request.Url.AbsolutePath);
  end;

end;

procedure TucThemeMasterPage.lbMaster_SelectedIndexChanged(sender: TObject; e: System.EventArgs);
begin
  Session[MyMasterPageKey] := lbMasterPage.SelectedValue;
  Response.Redirect('Pictures.aspx');
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TucThemeMasterPage.InitializeComponent;
begin
  Include(Self.lbTheme.SelectedIndexChanged, Self.lbTheme_SelectedIndexChanged);
  Include(Self.lbMasterPage.SelectedIndexChanged, Self.lbMaster_SelectedIndexChanged);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


end.
