unit uDMMain;

interface

uses
  Classes, DB, DBClient, MConnect, SConnect;

type
  TDMMain = class(TDataModule)
    cdsCliente: TClientDataSet;
    cdsNotaFiscal: TClientDataSet;
    cdsItem: TClientDataSet;
    cdsLote: TClientDataSet;
    cdsNotaFiscalCD_NOTA_FISCAL: TIntegerField;
    cdsNotaFiscalDT_NOTA_FISCAL: TDateField;
    cdsNotaFiscalNR_DOCUMENTO: TStringField;
    cdsNotaFiscalTP_NOTA_FISCAL: TSmallintField;
    cdsNotaFiscalVL_TOTAL: TFMTBCDField;
    cdsNotaFiscalQ_ITEM: TDataSetField;
    cdsItemCD_ITEM_NF: TIntegerField;
    cdsItemCD_NOTA_FISCAL: TIntegerField;
    cdsItemCD_PRODUTO: TIntegerField;
    cdsItemQT_ITEM_NF: TIntegerField;
    cdsItemVL_TOTAL: TFMTBCDField;
    cdsItemDS_PRODUTO: TStringField;
    cdsItemQ_ITEM_LOTE: TDataSetField;
    cdsLoteCD_ITEM_LOTE: TIntegerField;
    cdsLoteCD_ITEM_NF: TIntegerField;
    cdsLoteNR_ITEM_LOTE: TStringField;
    cdsLoteDT_VENCIMENTO: TDateField;
    cdsUsuario: TClientDataSet;
    cdsUsuarioCD_USUARIO: TIntegerField;
    cdsUsuarioNM_USUARIO: TStringField;
    cdsUsuarioDS_SENHA: TStringField;
    cdsUsuarioQ_USUARIO_SETOR: TDataSetField;
    cdsUsuarioQ_USUARIO_PERMISSAO: TDataSetField;
    cdsSetor: TClientDataSet;
    cdsPermissao: TClientDataSet;
    cdsSetorCD_USUARIO_SETOR: TIntegerField;
    cdsSetorCD_USUARIO: TIntegerField;
    cdsSetorNM_SETOR: TStringField;
    cdsPermissaoCD_USUARIO_PERMISSAO: TIntegerField;
    cdsPermissaoCD_USUARIO: TIntegerField;
    cdsPermissaoDS_PERMISSAO: TStringField;
    cdsPermissaoLG_ESCRITA: TSmallintField;
    cdsPermissaoLG_LEITURA: TSmallintField;
    cdsPermissaoLG_IMPRESSAO: TSmallintField;
    SocketConnection1: TSocketConnection;
    cdsNotasPorTipo: TClientDataSet;
    cdsNotasPorTipoCD_NOTA_FISCAL: TIntegerField;
    cdsNotasPorTipoDT_NOTA_FISCAL: TDateField;
    cdsNotasPorTipoNR_DOCUMENTO: TStringField;
    cdsNotasPorTipoTP_NOTA_FISCAL: TSmallintField;
    cdsNotasPorTipoVL_TOTAL: TFMTBCDField;
    ClientDataSet1: TClientDataSet;
    procedure DataModuleCreate(Sender: TObject);
    procedure cdsDatasetNewRecord(DataSet: TDataSet);
    procedure DataModuleDestroy(Sender: TObject);
    procedure cdsClienteReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
  private
    { Private declarations }
    FSequence: integer;
  public
    procedure CancelCliente;
    procedure OpenClientes;
    procedure SaveCliente;
    procedure OpenNotaFiscal(pCodigo: Integer);
    procedure CancelNotaFiscal;
    procedure SaveNotaFiscal;
    procedure CancelUsuario;
    procedure OpenUsuario(pCodigo: Integer);
    procedure SaveUsuario;
    function GetNotasPorTipo: string;
    function GetMessageOnServer: string;
    { Public declarations }
  end;

var
  DMMain: TDMMain;

implementation

uses Dialogs, uReconcilie, Variants, uRPCConsts, uAppServer;

{$R *.dfm}

procedure TDMMain.DataModuleCreate(Sender: TObject);
begin
  FSequence := -1;
  ConfigureAppServer(SocketConnection1);
end;

procedure TDMMain.DataModuleDestroy(Sender: TObject);
begin
  SocketConnection1.Connected := False;
end;

procedure TDMMain.SaveCliente;
begin
  if cdsCliente.ApplyUpdates(0) <> 0 then
    Showmessage('No foi possvel gravar as informaes');
end;

procedure TDMMain.CancelCliente;
begin
  cdsCliente.CancelUpdates;
end;

procedure TDMMain.OpenClientes;
begin
  with cdsCliente do
  begin
    Close;
    Open;
  end;
end;

procedure TDMMain.OpenNotaFiscal(pCodigo: Integer);
begin
  with cdsNotaFiscal do
  begin
    Close;
    Params[0].AsInteger := pCodigo;
    Open;
  end;
end;

procedure TDMMain.SaveNotaFiscal;
begin
  if cdsNotaFiscal.ApplyUpdates(0) <> 0 then
    Showmessage('No foi possvel gravar as informaes');
end;

procedure TDMMain.CancelNotaFiscal;
begin
  cdsNotaFiscal.CancelUpdates;
end;

procedure TDMMain.cdsClienteReconcileError(DataSet: TCustomClientDataSet;
  E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  Action := HandleReconcileError(Dataset, UpdateKind, E);
end;

procedure TDMMain.CancelUsuario;
begin
  cdsUsuario.CancelUpdates;
end;

procedure TDMMain.cdsDatasetNewRecord(DataSet: TDataSet);
const
  aCampos: Array[0..6] of string =
    ('CD_CLIENTE',
     'CD_NOTA_FISCAL', 'CD_ITEM_NF', 'CD_ITEM_LOTE',
     'CD_USUARIO', 'CD_USUARIO_SETOR', 'CD_USUARIO_PERMISSAO');
begin
  Dataset.FieldByName(aCampos[Dataset.Tag]).AsInteger := FSequence;
  Dec(FSequence);
end;

procedure TDMMain.OpenUsuario(pCodigo: Integer);
begin
  with cdsUsuario do
  begin
    Close;
    Params[0].AsInteger := pCodigo;
    Open;
  end;
end;

procedure TDMMain.SaveUsuario;
begin
  if cdsUsuario.ApplyUpdates(0) <> 0 then
    Showmessage('No foi possvel gravar as informaes');
end;

function TDMMain.GetNotasPorTipo: string;
begin
  if InputQuery('Dilogo de filtro', 'Informe o tipo de Nota:', Result) then
  begin
    with cdsNotasPorTipo do
    begin
      Close;
      DataRequest(VarArrayOf([rpcNotaFiscalByTypeParams, Result]));
      Open;
    end;
  end;
end;

function TDMMain.GetMessageOnServer: string;
begin
  Result := AppServer.AS_DataRequest('PrvNotaFiscalByTipo',
    VarArrayOf([rpcGetAlgumValor]));
end;

end.
