unit uPRVNotaFiscal;

interface

uses
  Classes, DynamicDBXModule;

type
  TPrvNotaFiscal = class(TDynamicModuleAutoInc)
  public
    constructor Create(AOwner: TComponent); override;
  end;

  TPrvNotaFiscalByTipo = class(TDynamicModule)
  private
    function GetAlgumValor: string;
    procedure SetNotaFiscalByTypeParams(Tipo: integer);
  public
    function CallMethod(Input: OleVariant): OleVariant; override;
  end;

implementation

uses SqlExpr, SysUtils, uRPCConsts, DynamicDBXSequence;

{ TPrvNotaFiscal }

constructor TPrvNotaFiscal.Create(AOwner: TComponent);
begin
  inherited Create(Aowner);
  AddPrimaryKey(ikMasterTable, 'Q_NOTA_FISCAL', 'NOTA_FISCAL',
    'CD_NOTA_FISCAL');
  AddPrimaryKey(ikDetailTable, 'Q_ITEM', 'ITEM_NF',
    'CD_ITEM_NF', 'CD_NOTA_FISCAL');
  AddPrimaryKey(ikDetailTable, 'Q_ITEM_LOTE', 'ITEM_LOTE',
    'CD_ITEM_LOTE', 'CD_ITEM_NF');
end;

{ TPrvNotaFiscalByTipo }

function TPrvNotaFiscalByTipo.CallMethod(Input: OleVariant): OleVariant;
begin
  case Input[0] of
    rpcNotaFiscalByTypeParams: SetNotaFiscalByTypeParams(Input[1]);
    rpcGetAlgumValor: Result := GetAlgumValor;
  end;
end;

procedure TPrvNotaFiscalByTipo.SetNotaFiscalByTypeParams(Tipo: integer);
const
  cSQL = 'SELECT * FROM NOTA_FISCAL WHERE TP_NOTA_FISCAL = %d';
begin
  with GetQueryByName('Q_NOTAS_BYTIPO') do
    SQL.Text := Format(cSQL, [Tipo]);
end;

function TPrvNotaFiscalByTipo.GetAlgumValor: string;
begin
  Result := 'Isto  resultado de uma funo do mdulo'#13+
    'NotaFiscalByTipo no servidor';
end;

initialization
  RegisterModules([TPrvNotaFiscal, TPrvNotaFiscalByTipo]);

end.
 
