unit uRDMServer;

{$WARN SYMBOL_PLATFORM OFF}

interface

uses
  Windows, DDServer_TLB, DynamicAppServer, StdVcl;

type
  TDynServer = class(TDynamicAppServer, IDynServer)
    procedure RemoteDataModuleCreate(Sender: TObject);
  private
    { Private declarations }
  protected
    class procedure UpdateRegistry(Register: Boolean;
      const ClassID, ProgID: string); override;
  public
    { Public declarations }
  end;

implementation

uses
  DataBkr, ComServ, VCLCom, ComObj, DynamicDBXPool;

{$R *.DFM}

procedure TDynServer.RemoteDataModuleCreate(Sender: TObject);
begin
  inherited;
  ConfigPoolToFirebird(DynamicPool);
  DynamicPool.Params.Values['Database'] :=
    'C:\Projetos\DynApp\Exe\BASE_EXEMPLO.FDB';
end;

class procedure TDynServer.UpdateRegistry(Register: Boolean;
  const ClassID, ProgID: string);
begin
  if Register then
  begin
    inherited UpdateRegistry(Register, ClassID, ProgID);
    EnableSocketTransport(ClassID);
    EnableWebTransport(ClassID);
  end else
  begin
    DisableSocketTransport(ClassID);
    DisableWebTransport(ClassID);
    inherited UpdateRegistry(Register, ClassID, ProgID);
  end;
end;

initialization
  TComponentFactory.Create(ComServer, TDynServer,
    Class_DynServer, ciMultiInstance, tmApartment);

end.
