unit DynamicProviderList;

interface

uses
  Windows, IniFiles;

type
  TProviderList = class(THashedStringList)
  private
    FIsLoaded: Boolean;
    FLock: TRTLCriticalSection;
    procedure Lock;
    procedure UnLock;
  public
    constructor Create;
    destructor Destroy; override;
    function Add(const s: string): Integer; override;
    procedure Clear; override;
    procedure Delete(Index: Integer); override;
    property IsLoaded: Boolean read FIsLoaded write FIsLoaded;
  end;

function GetDynProviderNames: TProviderList;

implementation

uses SysUtils, Classes;

var
  _ProviderNames: TProviderList;

function GetDynProviderNames: TProviderList;
begin
  if not Assigned(_ProviderNames) then
    _ProviderNames := TProviderList.Create;
  Result := _ProviderNames;
end;

{ TProviderList }

constructor TProviderList.Create;
begin
  inherited Create;
  InitializeCriticalSection(FLock);
  FIsLoaded := False;
end;

destructor TProviderList.Destroy;
begin
  DeleteCriticalSection(FLock);
  inherited;
end;

procedure TProviderList.Lock;
begin
  EnterCriticalSection(FLock);
end;

procedure TProviderList.UnLock;
begin
  LeaveCriticalSection(FLock);
end;

function TProviderList.Add(const s: string): Integer;
begin
  Lock;
  try
    Result := inherited Add(s);
    Sort;
  finally
    Unlock;
  end;
end;

procedure TProviderList.Clear;
begin
  Lock;
  try
    inherited Clear;
  finally
    Unlock;
  end;
end;

procedure TProviderList.Delete(Index: Integer);
begin
  Lock;
  try
    inherited Delete(Index);
  finally
    Unlock;
  end;
end;

initialization

finalization
  if Assigned(_ProviderNames) then
    FreeAndNil(_ProviderNames);

end.
