/******************************************************************************/
/****         Generated by IBExpert 2007.05.03 26/10/2007 00:26:07         ****/
/******************************************************************************/

SET SQL DIALECT 3;

SET NAMES NONE;

CREATE DATABASE 'C:\Projetos\DynApp\Exe\BASE_EXEMPLO.FDB'
USER 'SYSDBA' PASSWORD 'masterkey'
PAGE_SIZE 4096
DEFAULT CHARACTER SET NONE;



/******************************************************************************/
/****                               Domains                                ****/
/******************************************************************************/

CREATE DOMAIN BOOLEAN_NN AS
SMALLINT
NOT NULL
CHECK (VALUE IN (0,1));

CREATE DOMAIN DATA AS
DATE;

CREATE DOMAIN DATAHORA AS
TIMESTAMP;

CREATE DOMAIN DATA_NN AS
DATE
NOT NULL;

CREATE DOMAIN ID_NN AS
INTEGER
NOT NULL;

CREATE DOMAIN INTEIRO_NN AS
INTEGER
NOT NULL;

CREATE DOMAIN MOEDA AS
NUMERIC(15,2);

CREATE DOMAIN MOEDA_NN AS
NUMERIC(15,2)
NOT NULL;

CREATE DOMAIN STR10 AS
VARCHAR(10) CHARACTER SET WIN1252;

CREATE DOMAIN STR100 AS
VARCHAR(100) CHARACTER SET WIN1252;

CREATE DOMAIN STR11 AS
VARCHAR(11) CHARACTER SET WIN1252;

CREATE DOMAIN STR30 AS
VARCHAR(30) CHARACTER SET WIN1252;

CREATE DOMAIN STR30_NN AS
VARCHAR(30) CHARACTER SET WIN1252
NOT NULL;

CREATE DOMAIN STR50 AS
VARCHAR(50) CHARACTER SET WIN1252;

CREATE DOMAIN STR50_NN AS
VARCHAR(50) CHARACTER SET WIN1252;

CREATE DOMAIN STR60 AS
VARCHAR(60) CHARACTER SET WIN1252;

CREATE DOMAIN TIPO_NN AS
SMALLINT
NOT NULL;



/******************************************************************************/
/****                                Tables                                ****/
/******************************************************************************/



CREATE TABLE CLIENTE (
    CD_CLIENTE   ID_NN,
    NM_CLIENTE   STR30_NN,
    DS_ENDERECO  STR30,
    DT_NASC      DATA
);

CREATE TABLE ITEM_LOTE (
    CD_ITEM_LOTE   ID_NN,
    CD_ITEM_NF     ID_NN,
    NR_ITEM_LOTE   STR30_NN,
    DT_VENCIMENTO  DATA_NN
);

CREATE TABLE ITEM_NF (
    CD_ITEM_NF      ID_NN,
    CD_NOTA_FISCAL  ID_NN,
    CD_PRODUTO      ID_NN,
    QT_ITEM_NF      INTEIRO_NN,
    VL_TOTAL        MOEDA_NN
);

CREATE TABLE NOTA_FISCAL (
    CD_NOTA_FISCAL  ID_NN,
    DT_NOTA_FISCAL  DATA,
    NR_DOCUMENTO    STR11,
    TP_NOTA_FISCAL  TIPO_NN,
    VL_TOTAL        MOEDA
);

CREATE TABLE PRODUTO (
    CD_PRODUTO   ID_NN,
    DS_PRODUTO   STR50_NN,
    VL_UNITARIO  MOEDA
);

CREATE TABLE USUARIO (
    CD_USUARIO  ID_NN,
    NM_USUARIO  STR50,
    DS_SENHA    STR10
);

CREATE TABLE USUARIO_PERMISSAO (
    CD_USUARIO_PERMISSAO  ID_NN,
    CD_USUARIO            ID_NN,
    DS_PERMISSAO          STR100,
    LG_ESCRITA            BOOLEAN_NN,
    LG_LEITURA            BOOLEAN_NN,
    LG_IMPRESSAO          BOOLEAN_NN
);

CREATE TABLE USUARIO_SETOR (
    CD_USUARIO_SETOR  ID_NN,
    CD_USUARIO        ID_NN,
    NM_SETOR          STR60
);

INSERT INTO CLIENTE (CD_CLIENTE, NM_CLIENTE, DS_ENDERECO, DT_NASC) VALUES (1, 'Marcos Barreto bbbbbbb', 'Rua X casa Y', NULL);
INSERT INTO CLIENTE (CD_CLIENTE, NM_CLIENTE, DS_ENDERECO, DT_NASC) VALUES (-4, 'asdfadsf', NULL, NULL);
INSERT INTO CLIENTE (CD_CLIENTE, NM_CLIENTE, DS_ENDERECO, DT_NASC) VALUES (-6, 'asdf', NULL, NULL);
INSERT INTO CLIENTE (CD_CLIENTE, NM_CLIENTE, DS_ENDERECO, DT_NASC) VALUES (-7, 'dsfdsfdsfdsf', NULL, NULL);
INSERT INTO CLIENTE (CD_CLIENTE, NM_CLIENTE, DS_ENDERECO, DT_NASC) VALUES (-8, 'xxxxxxxxxxxxxxxxxxxxxx', NULL, NULL);

COMMIT WORK;

INSERT INTO NOTA_FISCAL (CD_NOTA_FISCAL, DT_NOTA_FISCAL, NR_DOCUMENTO, TP_NOTA_FISCAL, VL_TOTAL) VALUES (1, '2007-05-18', '215', 54, 500);
INSERT INTO NOTA_FISCAL (CD_NOTA_FISCAL, DT_NOTA_FISCAL, NR_DOCUMENTO, TP_NOTA_FISCAL, VL_TOTAL) VALUES (2, '2007-05-20', '3AB5', 1, 400);

COMMIT WORK;

INSERT INTO ITEM_NF (CD_ITEM_NF, CD_NOTA_FISCAL, CD_PRODUTO, QT_ITEM_NF, VL_TOTAL) VALUES (1, 1, 1, 1, 100);
INSERT INTO ITEM_NF (CD_ITEM_NF, CD_NOTA_FISCAL, CD_PRODUTO, QT_ITEM_NF, VL_TOTAL) VALUES (6, 1, 3, 3, 3);
INSERT INTO ITEM_NF (CD_ITEM_NF, CD_NOTA_FISCAL, CD_PRODUTO, QT_ITEM_NF, VL_TOTAL) VALUES (3, 1, 3, 3, 300);
INSERT INTO ITEM_NF (CD_ITEM_NF, CD_NOTA_FISCAL, CD_PRODUTO, QT_ITEM_NF, VL_TOTAL) VALUES (4, 2, 1, 5, 120);
INSERT INTO ITEM_NF (CD_ITEM_NF, CD_NOTA_FISCAL, CD_PRODUTO, QT_ITEM_NF, VL_TOTAL) VALUES (5, 1, 2, 6, 500);
INSERT INTO ITEM_NF (CD_ITEM_NF, CD_NOTA_FISCAL, CD_PRODUTO, QT_ITEM_NF, VL_TOTAL) VALUES (7, 1, 4, 4, 4);

COMMIT WORK;

INSERT INTO ITEM_LOTE (CD_ITEM_LOTE, CD_ITEM_NF, NR_ITEM_LOTE, DT_VENCIMENTO) VALUES (2, 5, 'XXX', '2025-10-10');
INSERT INTO ITEM_LOTE (CD_ITEM_LOTE, CD_ITEM_NF, NR_ITEM_LOTE, DT_VENCIMENTO) VALUES (3, 5, 'AAAAAAAAAAAAAA', '2009-01-01');
INSERT INTO ITEM_LOTE (CD_ITEM_LOTE, CD_ITEM_NF, NR_ITEM_LOTE, DT_VENCIMENTO) VALUES (4, 5, 'BBBBBBBBB', '2001-07-09');
INSERT INTO ITEM_LOTE (CD_ITEM_LOTE, CD_ITEM_NF, NR_ITEM_LOTE, DT_VENCIMENTO) VALUES (5, 5, 'BBBBBBBBBBBBBBB', '2010-07-09');

COMMIT WORK;

INSERT INTO PRODUTO (CD_PRODUTO, DS_PRODUTO, VL_UNITARIO) VALUES (1, 'BOLA', 20);
INSERT INTO PRODUTO (CD_PRODUTO, DS_PRODUTO, VL_UNITARIO) VALUES (2, 'MONITOR', 280);
INSERT INTO PRODUTO (CD_PRODUTO, DS_PRODUTO, VL_UNITARIO) VALUES (3, 'CELULAR', 560);
INSERT INTO PRODUTO (CD_PRODUTO, DS_PRODUTO, VL_UNITARIO) VALUES (4, 'TESOURA', 7.53);

COMMIT WORK;

INSERT INTO USUARIO (CD_USUARIO, NM_USUARIO, DS_SENHA) VALUES (1, 'Marcos xxx', '123');
INSERT INTO USUARIO (CD_USUARIO, NM_USUARIO, DS_SENHA) VALUES (2, 'Lea', '654');

COMMIT WORK;

INSERT INTO USUARIO_PERMISSAO (CD_USUARIO_PERMISSAO, CD_USUARIO, DS_PERMISSAO, LG_ESCRITA, LG_LEITURA, LG_IMPRESSAO) VALUES (1, 1, 'DESENVOLVIMENTO DO DYNAPP', 1, 1, 1);
INSERT INTO USUARIO_PERMISSAO (CD_USUARIO_PERMISSAO, CD_USUARIO, DS_PERMISSAO, LG_ESCRITA, LG_LEITURA, LG_IMPRESSAO) VALUES (2, 1, 'cccccccccccccccccc', 1, 0, 0);

COMMIT WORK;

INSERT INTO USUARIO_SETOR (CD_USUARIO_SETOR, CD_USUARIO, NM_SETOR) VALUES (1, 1, 'DESENVOLVIMENTO xxxxx');
INSERT INTO USUARIO_SETOR (CD_USUARIO_SETOR, CD_USUARIO, NM_SETOR) VALUES (5, 1, 'adsfasfdsfasdf');
INSERT INTO USUARIO_SETOR (CD_USUARIO_SETOR, CD_USUARIO, NM_SETOR) VALUES (6, 1, 'hhhhhhhhhhhhhhhhhh');
INSERT INTO USUARIO_SETOR (CD_USUARIO_SETOR, CD_USUARIO, NM_SETOR) VALUES (7, 1, 'dgsdfgdfsgsdfg');
INSERT INTO USUARIO_SETOR (CD_USUARIO_SETOR, CD_USUARIO, NM_SETOR) VALUES (8, 1, 'ccccccccccccccccccc');
INSERT INTO USUARIO_SETOR (CD_USUARIO_SETOR, CD_USUARIO, NM_SETOR) VALUES (9, 1, 'bbbbbbbbbbbbbbb');

COMMIT WORK;



/******************************************************************************/
/****                             Primary Keys                             ****/
/******************************************************************************/

ALTER TABLE CLIENTE ADD CONSTRAINT PK_CLIENTE PRIMARY KEY (CD_CLIENTE);
ALTER TABLE ITEM_LOTE ADD CONSTRAINT PK_ITEM_LOTE PRIMARY KEY (CD_ITEM_LOTE);
ALTER TABLE ITEM_NF ADD CONSTRAINT PK_ITEM_NF PRIMARY KEY (CD_ITEM_NF);
ALTER TABLE NOTA_FISCAL ADD CONSTRAINT PK_NOTA_FISCAL PRIMARY KEY (CD_NOTA_FISCAL);
ALTER TABLE PRODUTO ADD CONSTRAINT PK_PRODUTO PRIMARY KEY (CD_PRODUTO);
ALTER TABLE USUARIO ADD CONSTRAINT PK_USUARIO PRIMARY KEY (CD_USUARIO);
ALTER TABLE USUARIO_PERMISSAO ADD CONSTRAINT PK_USUARIO_PERMISSAO PRIMARY KEY (CD_USUARIO_PERMISSAO);
ALTER TABLE USUARIO_SETOR ADD CONSTRAINT PK_USUARIO_SETOR PRIMARY KEY (CD_USUARIO_SETOR);


/******************************************************************************/
/****                             Foreign Keys                             ****/
/******************************************************************************/

ALTER TABLE ITEM_LOTE ADD CONSTRAINT FK_ITEM_LOTE_1 FOREIGN KEY (CD_ITEM_NF) REFERENCES ITEM_NF (CD_ITEM_NF);
ALTER TABLE ITEM_NF ADD CONSTRAINT FK_ITEM_NF_1 FOREIGN KEY (CD_NOTA_FISCAL) REFERENCES NOTA_FISCAL (CD_NOTA_FISCAL);
ALTER TABLE USUARIO_PERMISSAO ADD CONSTRAINT FK_USUARIO_PERMISSAO_1 FOREIGN KEY (CD_USUARIO) REFERENCES USUARIO (CD_USUARIO);
ALTER TABLE USUARIO_SETOR ADD CONSTRAINT FK_USUARIO_SETOR_1 FOREIGN KEY (CD_USUARIO) REFERENCES USUARIO (CD_USUARIO);
