/******************************************************************************/
/****         Generated by IBExpert 2007.05.03 26/10/2007 00:25:19         ****/
/******************************************************************************/

SET SQL DIALECT 3;

SET NAMES NONE;

CREATE DATABASE 'C:\Projetos\DynApp\Exe\REPOSITORIO.FDB'
USER 'SYSDBA' PASSWORD 'masterkey'
PAGE_SIZE 1024
DEFAULT CHARACTER SET NONE;



/******************************************************************************/
/****                               Domains                                ****/
/******************************************************************************/

CREATE DOMAIN ID AS
INTEGER;

CREATE DOMAIN ID_NN AS
INTEGER
NOT NULL;

CREATE DOMAIN MEMO AS
BLOB SUB_TYPE 1 SEGMENT SIZE 100 CHARACTER SET WIN1252;

CREATE DOMAIN STRING30 AS
VARCHAR(30) CHARACTER SET WIN1252;

CREATE DOMAIN STRING50 AS
VARCHAR(50);

CREATE DOMAIN TIPO_DATATYPE AS
SMALLINT
NOT NULL
CHECK (VALUE IN (0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38));

CREATE DOMAIN TIPO_PARAMTYPE AS
SMALLINT
NOT NULL
CHECK (VALUE IN (0,1,2,3,4));



/******************************************************************************/
/****                              Generators                              ****/
/******************************************************************************/

CREATE GENERATOR GEN_FIELD;
SET GENERATOR GEN_FIELD TO 169;

CREATE GENERATOR GEN_MODULE;
SET GENERATOR GEN_MODULE TO 5;

CREATE GENERATOR GEN_PARAMETER;
SET GENERATOR GEN_PARAMETER TO 25;

CREATE GENERATOR GEN_QUERY;
SET GENERATOR GEN_QUERY TO 8;



/******************************************************************************/
/****                                Tables                                ****/
/******************************************************************************/



CREATE TABLE FIELD (
    CD_FIELD   ID_NN,
    NM_FIELD   STRING30,
    DS_CONFIG  MEMO,
    DS_FIELD   MEMO,
    CD_QUERY   ID_NN
);

CREATE TABLE MODULE (
    CD_MODULE      ID_NN,
    NM_MODULE      STRING30,
    DS_MODULE      MEMO,
    DS_CONFIG      MEMO,
    CD_MODULE_PAI  ID,
    CD_QUERY       ID
);

CREATE TABLE QUERY (
    CD_QUERY      ID_NN,
    NM_QUERY      STRING30,
    CD_QUERY_PAI  ID,
    DS_QUERY      MEMO,
    DS_SQL        MEMO,
    DS_CONFIG     MEMO,
    CD_MODULE     ID
);

CREATE TABLE QUERY_PARAMETER (
    CD_PARAMETER  ID_NN,
    NM_PARAMETER  STRING30,
    TP_DATATYPE   TIPO_DATATYPE,
    DS_CONFIG     MEMO,
    CD_QUERY      ID_NN
);


SET BLOBFILE 'C:\Projetos\DynApp\Exe\Scripts\REPOSITORIO.lob';

INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (123, 'CD_NOTA_FISCAL', :h00000000_0000001F, NULL, 2);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (124, 'DT_NOTA_FISCAL', :h0000001F_0000000D, NULL, 2);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (125, 'NR_DOCUMENTO', :h0000002C_0000000D, NULL, 2);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (126, 'TP_NOTA_FISCAL', :h00000039_00000017, NULL, 2);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (127, 'VL_TOTAL', :h00000050_0000000D, NULL, 2);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (101, 'CD_CLIENTE', :h0000005D_0000001C, NULL, 1);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (128, 'CD_ITEM_NF', :h00000079_0000001F, NULL, 3);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (129, 'CD_NOTA_FISCAL', :h00000098_00000017, NULL, 3);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (130, 'CD_PRODUTO', :h000000AF_00000017, NULL, 3);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (131, 'QT_ITEM_NF', :h000000C6_00000017, NULL, 3);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (165, 'CD_NOTA_FISCAL', :h000000DD_0000001F, NULL, 8);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (166, 'DT_NOTA_FISCAL', :h000000FC_0000000D, NULL, 8);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (167, 'NR_DOCUMENTO', :h00000109_0000000D, NULL, 8);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (153, 'CD_USUARIO_SETOR', :h00000116_0000001F, NULL, 7);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (154, 'CD_USUARIO', :h00000135_00000017, NULL, 7);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (168, 'TP_NOTA_FISCAL', :h0000014C_00000017, NULL, 8);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (155, 'NM_SETOR', :h00000163_00000015, NULL, 7);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (169, 'VL_TOTAL', :h00000178_0000000D, NULL, 8);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (132, 'VL_TOTAL', :h00000185_00000017, NULL, 3);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (156, 'CD_USUARIO_PERMISSAO', :h0000019C_0000001F, NULL, 6);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (157, 'CD_USUARIO', :h000001BB_00000017, NULL, 6);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (158, 'DS_PERMISSAO', :h000001D2_0000000D, NULL, 6);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (159, 'LG_ESCRITA', :h000001DF_00000017, NULL, 6);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (160, 'LG_LEITURA', :h000001F6_00000017, NULL, 6);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (161, 'LG_IMPRESSAO', :h0000020D_00000017, NULL, 6);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (162, 'CD_USUARIO', :h00000224_0000001F, NULL, 5);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (163, 'NM_USUARIO', :h00000243_0000000D, NULL, 5);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (164, 'DS_SENHA', :h00000250_0000000F, NULL, 5);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (133, 'DS_PRODUTO', NULL, NULL, 3);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (105, 'NM_CLIENTE', :h0000025F_00000017, NULL, 1);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (134, 'CD_ITEM_LOTE', :h00000276_0000001F, NULL, 4);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (135, 'CD_ITEM_NF', :h00000295_00000017, NULL, 4);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (108, 'DS_ENDERECO', :h000002AC_0000000D, NULL, 1);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (136, 'NR_ITEM_LOTE', :h000002B9_00000017, NULL, 4);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (109, 'DT_NASC', :h000002D0_0000000D, NULL, 1);
INSERT INTO FIELD (CD_FIELD, NM_FIELD, DS_CONFIG, DS_FIELD, CD_QUERY) VALUES (137, 'DT_VENCIMENTO', :h000002DD_00000017, NULL, 4);

COMMIT WORK;

INSERT INTO MODULE (CD_MODULE, NM_MODULE, DS_MODULE, DS_CONFIG, CD_MODULE_PAI, CD_QUERY) VALUES (1, 'PRVCLIENTE', NULL, NULL, NULL, 1);
INSERT INTO MODULE (CD_MODULE, NM_MODULE, DS_MODULE, DS_CONFIG, CD_MODULE_PAI, CD_QUERY) VALUES (3, 'PRVUSUARIO', NULL, NULL, NULL, 5);
INSERT INTO MODULE (CD_MODULE, NM_MODULE, DS_MODULE, DS_CONFIG, CD_MODULE_PAI, CD_QUERY) VALUES (4, 'PRVNOTAFISCALBYTIPO', NULL, NULL, NULL, 8);
INSERT INTO MODULE (CD_MODULE, NM_MODULE, DS_MODULE, DS_CONFIG, CD_MODULE_PAI, CD_QUERY) VALUES (2, 'PRVNOTAFISCAL', NULL, NULL, NULL, 2);

COMMIT WORK;

INSERT INTO QUERY (CD_QUERY, NM_QUERY, CD_QUERY_PAI, DS_QUERY, DS_SQL, DS_CONFIG, CD_MODULE) VALUES (3, 'Q_ITEM', 2, NULL, :h000002F4_00000089, NULL, 2);
INSERT INTO QUERY (CD_QUERY, NM_QUERY, CD_QUERY_PAI, DS_QUERY, DS_SQL, DS_CONFIG, CD_MODULE) VALUES (1, 'Q_CLIENTE', NULL, NULL, :h0000037D_00000016, NULL, 1);
INSERT INTO QUERY (CD_QUERY, NM_QUERY, CD_QUERY_PAI, DS_QUERY, DS_SQL, DS_CONFIG, CD_MODULE) VALUES (4, 'Q_ITEM_LOTE', 3, NULL, :h00000393_0000003E, NULL, 2);
INSERT INTO QUERY (CD_QUERY, NM_QUERY, CD_QUERY_PAI, DS_QUERY, DS_SQL, DS_CONFIG, CD_MODULE) VALUES (8, 'Q_NOTAS_BYTIPO', NULL, :h000003D1_00000025, :h000003F6_0000001F, NULL, 4);
INSERT INTO QUERY (CD_QUERY, NM_QUERY, CD_QUERY_PAI, DS_QUERY, DS_SQL, DS_CONFIG, CD_MODULE) VALUES (5, 'Q_USUARIO', NULL, :h00000415_00000005, :h0000041A_0000003E, NULL, 3);
INSERT INTO QUERY (CD_QUERY, NM_QUERY, CD_QUERY_PAI, DS_QUERY, DS_SQL, DS_CONFIG, CD_MODULE) VALUES (6, 'Q_USUARIO_PERMISSAO', 5, NULL, :h00000458_00000048, NULL, 3);
INSERT INTO QUERY (CD_QUERY, NM_QUERY, CD_QUERY_PAI, DS_QUERY, DS_SQL, DS_CONFIG, CD_MODULE) VALUES (2, 'Q_NOTA_FISCAL', NULL, :h000004A0_00000006, :h000004A6_00000048, NULL, 2);
INSERT INTO QUERY (CD_QUERY, NM_QUERY, CD_QUERY_PAI, DS_QUERY, DS_SQL, DS_CONFIG, CD_MODULE) VALUES (7, 'Q_USUARIO_SETOR', 5, :h000004EE_0000000B, :h000004F9_00000045, NULL, 3);

COMMIT WORK;

INSERT INTO QUERY_PARAMETER (CD_PARAMETER, NM_PARAMETER, TP_DATATYPE, DS_CONFIG, CD_QUERY) VALUES (1, 'CD_USUARIO', 3, NULL, 7);
INSERT INTO QUERY_PARAMETER (CD_PARAMETER, NM_PARAMETER, TP_DATATYPE, DS_CONFIG, CD_QUERY) VALUES (25, NULL, 3, NULL, -1);
INSERT INTO QUERY_PARAMETER (CD_PARAMETER, NM_PARAMETER, TP_DATATYPE, DS_CONFIG, CD_QUERY) VALUES (3, 'CD_NOTA_FISCAL', 3, NULL, 2);
INSERT INTO QUERY_PARAMETER (CD_PARAMETER, NM_PARAMETER, TP_DATATYPE, DS_CONFIG, CD_QUERY) VALUES (21, 'CD_NOTA_FISCAL', 3, NULL, 3);
INSERT INTO QUERY_PARAMETER (CD_PARAMETER, NM_PARAMETER, TP_DATATYPE, DS_CONFIG, CD_QUERY) VALUES (22, 'CD_USUARIO', 3, NULL, 5);
INSERT INTO QUERY_PARAMETER (CD_PARAMETER, NM_PARAMETER, TP_DATATYPE, DS_CONFIG, CD_QUERY) VALUES (24, 'CD_USUARIO', 3, NULL, 6);
INSERT INTO QUERY_PARAMETER (CD_PARAMETER, NM_PARAMETER, TP_DATATYPE, DS_CONFIG, CD_QUERY) VALUES (18, 'CD_ITEM_NF', 3, NULL, 4);

COMMIT WORK;



/******************************************************************************/
/****                             Primary Keys                             ****/
/******************************************************************************/

ALTER TABLE FIELD ADD CONSTRAINT PK_FIELD PRIMARY KEY (CD_FIELD);
ALTER TABLE MODULE ADD CONSTRAINT PK_MODULE PRIMARY KEY (CD_MODULE);
ALTER TABLE QUERY ADD CONSTRAINT PK_QUERY PRIMARY KEY (CD_QUERY);
ALTER TABLE QUERY_PARAMETER ADD CONSTRAINT PK_QUERY_PARAMETER PRIMARY KEY (CD_PARAMETER);


/******************************************************************************/
/****                               Indices                                ****/
/******************************************************************************/

CREATE INDEX FIELD_IDX1 ON FIELD (CD_QUERY);
CREATE INDEX MODULE_IDX1 ON MODULE (CD_MODULE_PAI);
CREATE INDEX MODULE_IDX2 ON MODULE (CD_QUERY);
CREATE INDEX QUERY_IDX1 ON QUERY (CD_MODULE);
CREATE INDEX QUERY_PARAMETER_IDX1 ON QUERY_PARAMETER (CD_QUERY);


/******************************************************************************/
/****                               Triggers                               ****/
/******************************************************************************/


SET TERM ^ ;


/******************************************************************************/
/****                         Triggers for tables                          ****/
/******************************************************************************/



/* Trigger: FIELD_BI0 */
CREATE TRIGGER FIELD_BI0 FOR FIELD
ACTIVE BEFORE INSERT POSITION 0
AS
begin
  new.cd_field = gen_id(gen_field,1);
end
^

/* Trigger: MODULE_BI0 */
CREATE TRIGGER MODULE_BI0 FOR MODULE
ACTIVE BEFORE INSERT POSITION 0
AS
begin
  new.cd_MODULE = gen_id(gen_MODULE,1);
end
^

/* Trigger: QUERY_BI0 */
CREATE TRIGGER QUERY_BI0 FOR QUERY
ACTIVE BEFORE INSERT POSITION 0
AS
begin
  new.cd_query = gen_id(gen_query,1);
end
^

/* Trigger: QUERY_PARAMETER_BI0 */
CREATE TRIGGER QUERY_PARAMETER_BI0 FOR QUERY_PARAMETER
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  NEW.CD_PARAMETER = GEN_ID(GEN_PARAMETER,1);
END
^

SET TERM ; ^

