unit uDmGerenciador;

interface

uses
  Controls, FMTBcd, DB, DBClient, Provider, SqlExpr, Classes,
  ComCtrls, uUtils, uQuery, WideStrings;

type
  TTipoNode = (tnQuery=1, tnNestedQuery=2, tnField=3);
  TEvent = (seQueryPaiChangedEvent);
  TAddQueryMethod = procedure (const sQuery, sQueryPai: string) of object;
  TAddFieldMethod = procedure (const sField: string) of object;
  TSendEventMethod = procedure (Event: TEvent; Params: array of string) of object;

  TDMGerenciador = class(TDataModule)
    qryQuery: TSQLQuery;
    qryField: TSQLQuery;
    dsModule: TDataSource;
    dsQuery: TDataSource;
    cdsQuery: TClientDataSet;
    cdsField: TClientDataSet;
    qryParam: TSQLQuery;
    cdsParam: TClientDataSet;
    cdsQueryCombo: TClientDataSet;
    cdsModule: TClientDataSet;
    prvModule: TDataSetProvider;
    qryModule: TSQLQuery;
    cdsModules: TClientDataSet;
    prvModules: TDataSetProvider;
    qryModules: TSQLQuery;
    qryModuleCD_MODULE: TIntegerField;
    qryModuleNM_MODULE: TStringField;
    qryModuleDS_MODULE: TMemoField;
    qryModuleDS_CONFIG: TMemoField;
    qryModuleCD_MODULE_PAI: TIntegerField;
    qryModuleCD_QUERY: TIntegerField;
    qryModuleNM_QUERY: TStringField;
    qrySubModules: TSQLQuery;
    cdsSubModules: TClientDataSet;
    qryModuleNM_MODULE_PAI: TStringField;
    cdsModuleCD_MODULE: TIntegerField;
    cdsModuleNM_MODULE: TStringField;
    cdsModuleDS_MODULE: TMemoField;
    cdsModuleDS_CONFIG: TMemoField;
    cdsModuleCD_MODULE_PAI: TIntegerField;
    cdsModuleCD_QUERY: TIntegerField;
    cdsModuleNM_QUERY: TStringField;
    cdsModuleNM_MODULE_PAI: TStringField;
    cdsModuleqrySubModules: TDataSetField;
    cdsModuleqryQuery: TDataSetField;
    qryQueryCD_QUERY: TIntegerField;
    qryQueryNM_QUERY: TStringField;
    qryQueryCD_QUERY_PAI: TIntegerField;
    qryQueryDS_QUERY: TMemoField;
    qryQueryDS_SQL: TMemoField;
    qryQueryDS_CONFIG: TMemoField;
    qryQueryCD_MODULE: TIntegerField;
    qryQueryNM_QUERY_PAI: TStringField;
    qryParamCD_PARAMETER: TIntegerField;
    qryParamNM_PARAMETER: TStringField;
    qryParamTP_DATATYPE: TSmallintField;
    qryParamDS_CONFIG: TMemoField;
    qryParamCD_QUERY: TIntegerField;
    cdsParamCD_PARAMETER: TIntegerField;
    cdsParamNM_PARAMETER: TStringField;
    cdsParamTP_DATATYPE: TSmallintField;
    cdsParamDS_CONFIG: TMemoField;
    cdsParamCD_QUERY: TIntegerField;
    qryFieldCD_FIELD: TIntegerField;
    qryFieldNM_FIELD: TStringField;
    qryFieldDS_CONFIG: TMemoField;
    qryFieldDS_FIELD: TMemoField;
    qryFieldCD_QUERY: TIntegerField;
    cdsFieldCD_FIELD: TIntegerField;
    cdsFieldNM_FIELD: TStringField;
    cdsFieldDS_CONFIG: TMemoField;
    cdsFieldDS_FIELD: TMemoField;
    cdsFieldCD_QUERY: TIntegerField;
    qrySubModulesCD_MODULE: TIntegerField;
    qrySubModulesNM_MODULE: TStringField;
    cdsSubModulesCD_MODULE: TIntegerField;
    cdsSubModulesNM_MODULE: TStringField;
    qryModulesCD_MODULE: TIntegerField;
    qryModulesNM_MODULE: TStringField;
    cdsModulesCD_MODULE: TIntegerField;
    cdsModulesNM_MODULE: TStringField;
    cdsQueryCD_QUERY: TIntegerField;
    cdsQueryNM_QUERY: TStringField;
    cdsQueryCD_QUERY_PAI: TIntegerField;
    cdsQueryDS_QUERY: TMemoField;
    cdsQueryDS_SQL: TMemoField;
    cdsQueryDS_CONFIG: TMemoField;
    cdsQueryCD_MODULE: TIntegerField;
    cdsQueryNM_QUERY_PAI: TStringField;
    cdsQueryqryParam: TDataSetField;
    cdsQueryqryField: TDataSetField;
    RepConn: TSQLConnection;
    procedure DataModuleCreate(Sender: TObject);
    procedure cdsNewRecord(DataSet: TDataSet);
    procedure cdsFieldChange(Sender: TField);
    procedure cdsParamTP_DATATYPEGetText(Sender: TField; var Text: String;
      DisplayText: Boolean);
    procedure cdsParamTP_DATATYPESetText(Sender: TField;
      const Text: String);
    procedure ReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
  private
    { Private declarations }
    fID: Integer;
    FFullDatasetDados: IFullDataset;
    FSendEvent: TSendEventMethod;
    function OpenFields(const pTableName: string): IFullDataset;
    function GetTableName: string;
    procedure RedirecionaEventos;
    procedure ClearFullDataset;
  public
    { Public declarations }
    procedure IterateQueries(QueryMethod: TAddQueryMethod;
      FieldMethod: TAddFieldMethod);
    procedure SetEventMethod(Method: TSendEventMethod);
    function QueryIsPrincipal: boolean;
    procedure FindItem(pTipo: TTipoDataset; Values: OleVariant);
    procedure OpenModule;
    procedure Insert(pTipo: TTipoDataset);
    procedure SetDatasetToModule(Checked: boolean);
    procedure Cancel(pTipo: TTipoDataset);
    procedure Save;
    procedure DeleteField;
    procedure InsertField;
    procedure InsertFields(pTestCount: boolean = True);
    procedure InsertParams;
    procedure DeleteAllFields;
    function OpenQuery: TDataset;
  end;

var
  DMGerenciador: TDMGerenciador;

implementation

uses
  SysUtils, TypInfo, Dialogs, uParams, uDmBase, uReconcilieError;

{$R *.dfm}

procedure TDMGerenciador.DataModuleCreate(Sender: TObject);
begin
  RepConn.Params.Values['DATABASE'] :=
    ExtractFilepath(ParamStr(0))+'REPOSITORIO.FDB';
  RepConn.Connected := True;
  fID := -1;
  cdsModules.Open;
  RedirecionaEventos;
end;

procedure TDMGerenciador.RedirecionaEventos;
begin
  cdsQueryCD_QUERY_PAI.OnChange := cdsFieldChange;
  cdsModule.OnNewRecord := cdsNewRecord;
  cdsQuery.OnNewRecord := cdsNewRecord;
  cdsField.OnNewRecord := cdsNewRecord;
  cdsParam.OnNewRecord := cdsNewRecord;
end;

procedure TDMGerenciador.SetEventMethod(Method: TSendEventMethod);
begin
  FSendEvent := Method;
end;

procedure TDMGerenciador.Insert(pTipo: TTipoDataset);
begin
  case pTipo of
    ttModule: cdsModule.Insert;
    ttQuery: cdsQuery.Insert;
    ttField: cdsField.Insert;
  end;
end;

procedure TDMGerenciador.Save;
begin
  if ((cdsModule.State in dsEditModes)
    or (cdsModule.ChangeCount <> 0))
    and (cdsModule.ApplyUpdates(0) <> 0) then
    MessageDlg('Erro ao gravar dados!', mtError, [mbOK], 0);
end;

procedure TDMGerenciador.Cancel(pTipo: TTipoDataset);
begin
  case pTipo of
    ttModule: cdsModule.CancelUpdates;
    ttQuery:
    begin
      cdsQuery.Cancel;
      cdsField.Cancel;
      cdsParam.Cancel;
    end;
  end;
end;

procedure TDMGerenciador.SetDatasetToModule(Checked: boolean);
begin
  if not (cdsModule.State in dsEditModes) then
    cdsModule.Edit;
  if Checked then
  begin
    cdsModuleCD_QUERY.AsInteger := cdsQueryCD_QUERY.AsInteger;
    cdsModuleNM_QUERY.AsString := cdsQueryNM_QUERY.AsString;
  end else
  begin
    cdsModuleCD_QUERY.Clear;
    cdsModuleNM_QUERY.Clear;
  end;
end;

procedure TDMGerenciador.OpenModule;
begin
  cdsModule.Close;
  if (cdsModules.RecordCount = 0) then
    cdsModule.Params[0].AsInteger := -1
  else
    cdsModule.Params[0].AsInteger := cdsModules['CD_MODULE'];
  cdsModule.Open;
  cdsQueryCombo.Data := cdsQuery.Data;
end;

procedure TDMGerenciador.cdsNewRecord(DataSet: TDataSet);
begin
  if DataSet = cdsModule then
    cdsModule['CD_MODULE'] := fID
  else if DataSet = cdsQuery then
    cdsQuery['CD_QUERY'] := fID
  else if DataSet = cdsField then
    cdsField['CD_FIELD'] := fID
  else if DataSet = cdsParam then
    cdsParam['CD_PARAMETER'] := fID;
  Dec(fID);
end;

procedure TDMGerenciador.DeleteAllFields;
begin
  if cdsField.RecordCount = 0 then
    Exit;
  cdsField.First;
  while not cdsField.Eof do
    cdsField.Delete;
  Save;
end;

procedure TDMGerenciador.DeleteField;
begin
  if cdsField.RecordCount = 0 then
    Exit;
  cdsField.Delete;
  Save;
end;

procedure TDMGerenciador.InsertField;
begin
  DeleteField;
  InsertFields(False);
end;

procedure TDMGerenciador.InsertFields(pTestCount: boolean = True);
var
  vConfig: TStringList;
  vFields: IFullDataset;
  vAllField: TFieldDefs;
  vFieldName: string;
  i: integer;
begin
  vFields := OpenFields(GetTableName);
  vAllField := DMGerenciador.OpenQuery.FieldDefs;
  vConfig := TStringList.Create;
  try
    if pTestCount and (cdsField.RecordCount <> 0) then
      ShowMessage('Campos existentes no sero substitudos');
    for i := 0 to vAllField.Count-1 do
    begin
      vFieldName := vAllField[i].Name;
      if cdsField.Locate('NM_FIELD', Trim(vFieldName), []) then
        Continue;
      cdsField.Insert;
      cdsField.Fieldbyname('NM_FIELD').AsString := vFieldName;
      cdsField.Fieldbyname('CD_QUERY').AsInteger :=
        cdsQueryCD_QUERY.AsInteger;
      vConfig.Clear;
      if vFields.Locate('NM_FIELD', vFieldName) then
      begin
        if not vFields.GetField('LG_NOTNULL').IsNull then
          vConfig.Add('Required');
        if not vFields.GetField('NM_FIELD_KEY').IsNull then
        begin
          vConfig.add('pfInKey');
          vConfig.add('pfInWhere');
        end else
          vConfig.add('pfInUpdate');
      end;
      cdsField.FieldByName('DS_CONFIG').Value := vConfig.Text;
      cdsField.Post;
    end;
  finally
    Save;
    ClearFullDataset;
    FreeAndNil(vConfig);
  end;
end;

procedure TDMGerenciador.ClearFullDataset;
begin
  if Assigned(FFullDatasetDados) then
    FFullDatasetDados.Clear
end;

function TDMGerenciador.OpenFields(const pTableName: string): IFullDataset;
var
  vFormParams: IFormParams;
begin
  Result := NewFullDataset;
  Result.Configure(DMBase, DMBase.BaseConn,
    Format(cFieldsOfQuery, [QuotedStr(pTableName)]));
  if Result.HasParams then
  begin
    vFormParams := GetFormParams;
    Result.FillParams(vFormParams.Params);
    if vFormParams.Execute then
      Result.OpenSQL(vFormParams.Params);
  end else
    Result.OpenSQL;
end;

function TDMGerenciador.GetTableName: string;
var
  Tabela, Sql: string;
  Posicao_From : integer;
begin
  Sql := StringReplace(cdsQueryDS_SQL.AsString,
    #$D#$A, ' ', [rfReplaceAll, rfIgnoreCase]);
  Posicao_From := Pos('FROM', AnsiUpperCase(Sql))+4;
  Tabela := Trim(Copy(Sql, Posicao_From, Length(Sql)));
  Posicao_From := Pos(' ', Tabela);
  if Posicao_From = 0 then
    Posicao_From := Length(Tabela);
  Result := Copy(Tabela, 0, Posicao_From-1);
end;

function TDMGerenciador.QueryIsPrincipal: boolean;
begin
  Result := cdsModuleCD_QUERY.AsInteger = cdsQueryCD_QUERY.AsInteger
end;

procedure TDMGerenciador.IterateQueries(QueryMethod: TAddQueryMethod;
  FieldMethod: TAddFieldMethod);
begin
  cdsQuery.First;
  while not cdsQuery.Eof do
  begin
    QueryMethod(cdsQuery.fieldbyname('nm_query').AsString,
      cdsQuery.fieldbyname('nm_query_pai').AsString);
    cdsField.First;
    while not cdsField.Eof do
    begin
      FieldMethod(cdsField.fieldbyname('nm_field').AsString);
      cdsField.next;
    end;
    cdsQuery.next;
  end;
end;

procedure TDMGerenciador.FindItem(pTipo: TTipoDataset; Values: OleVariant);
var
  bFound: boolean;
begin
  bFound := False;
  if pTipo >= ttQuery then
    bFound := cdsQuery.Locate('NM_QUERY', Values[0], []);
  if bFound and (pTipo > ttQuery) then
    cdsField.Locate('NM_FIELD', Values[1], []);
end;

function TDMGerenciador.OpenQuery: TDataset;
var
  FormParams: IFormParams;
begin
  ClearFullDataset;
  FFullDatasetDados := NewFullDataset;
  FFullDatasetDados.Configure(DMBase, DMBase.BaseConn, cdsQueryDS_SQL.AsString);
  if FFullDatasetDados.HasParams then
  begin
    FormParams := GetFormParams;
    FFullDatasetDados.FillParams(FormParams.Params);
    if FormParams.Execute then
      FFullDatasetDados.OpenSQL(FormParams.Params);
  end else
    FFullDatasetDados.OpenSQL;
  Result := FFullDatasetDados.GetDataset;
end;

procedure TDMGerenciador.cdsFieldChange(Sender: TField);
var
  s: string;
begin
  s := EmptyStr;
  if (Sender.AsString <> EmptyStr)
    and cdsQueryCombo.Locate('CD_QUERY', Sender.Value, []) then
    s := cdsQueryCombo.FieldByName('NM_QUERY').AsString;
  FSendEvent(seQueryPaiChangedEvent, [s]);
end;

procedure TDMGerenciador.InsertParams;
var
  i: integer;
  FullDts: IFullDataset;
begin
  FullDts := NewFullDataset;
  with FullDts do
  begin
    Configure(DMBase, DMBase.BaseConn, cdsQueryDS_SQL.AsString);
    if cdsParam.RecordCount <> 0 then
      ShowMessage('Parametros existentes no sero substitudos');
    if HasParams then
      for i := 0 to GetParams.Count-1 do
      begin
        if cdsParam.Locate('NM_PARAMETER', GetParams[i].Name, []) then
          Continue;
        cdsParam.Insert;
        cdsParamNM_PARAMETER.AsString := GetParams[i].Name;
        cdsParamTP_DATATYPE.AsInteger := Ord(GetParams[i].DataType);
        cdsParamCD_QUERY.AsInteger := cdsQueryCD_QUERY.AsInteger;
        cdsParam.Post;
      end;
  end;
end;

procedure TDMGerenciador.cdsParamTP_DATATYPEGetText(Sender: TField;
  var Text: String; DisplayText: Boolean);
begin
  Text := GetEnumName(TypeInfo(TFieldType), Sender.AsInteger) ;
end;

procedure TDMGerenciador.cdsParamTP_DATATYPESetText(Sender: TField;
  const Text: String);
begin
  Sender.AsInteger := GetEnumValue(TypeInfo(TFieldType), Text);
end;

procedure TDMGerenciador.ReconcileError(
  DataSet: TCustomClientDataSet; E: EReconcileError;
  UpdateKind: TUpdateKind; var Action: TReconcileAction);
begin
  Action := HandleReconcileError(Dataset, UpdateKind, E);
end;

end.
