unit uMenu;

interface

uses
  Forms, DB, ComCtrls, ExtCtrls, Controls, DBCtrls, StdCtrls, Buttons,
  Mask, Classes, uUtils, ImgList, Grids, DBGrids, Menus, uDmGerenciador;

type
  TfrmMenu = class(TForm)
    PageControl1: TPageControl;
    tbsProvider: TTabSheet;
    tbsQuery: TTabSheet;
    edtProvider: TDBEdit;
    edtDescricao: TDBMemo;
    Label3: TLabel;
    btnNovoProvider: TBitBtn;
    btnSalvarProvider: TBitBtn;
    btnCancelarProvider: TBitBtn;
    dtsModule: TDataSource;
    edtQuery: TDBEdit;
    edtDescricaoQuery: TDBMemo;
    edtSql: TDBMemo;
    btnSalvarQuery: TBitBtn;
    btnNovoQuery: TBitBtn;
    dtsQuery: TDataSource;
    chkQueryPrincipal: TCheckBox;
    cmbQuery: TDBLookupComboBox;
    dtsField: TDataSource;
    dtsQueries: TDataSource;
    edtConfiguracao: TDBMemo;
    Label12: TLabel;
    Label2: TLabel;
    Splitter1: TSplitter;
    Label1: TLabel;
    Label4: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    edtConfiguracaoQuery: TDBMemo;
    btnCancelarQuery: TBitBtn;
    Panel1: TPanel;
    Label8: TLabel;
    trvQueries: TTreeView;
    dtsModules: TDataSource;
    DBLookupComboBox2: TDBLookupComboBox;
    Label9: TLabel;
    Label10: TLabel;
    DBText1: TDBText;
    ImageList1: TImageList;
    dtsParam: TDataSource;
    PopupMenu1: TPopupMenu;
    GerarCampos1: TMenuItem;
    RemoverTodosCampos1: TMenuItem;
    RemoverQuery2: TMenuItem;
    RemoverCampo1: TMenuItem;
    Removermdulo1: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    PageControl2: TPageControl;
    tbsParams: TTabSheet;
    tbsFields: TTabSheet;
    DBGrid1: TDBGrid;
    DBGrid2: TDBGrid;
    Label5: TLabel;
    edtCampo: TDBEdit;
    Label6: TLabel;
    edtDescricaoCampo: TDBMemo;
    Label7: TLabel;
    edtConfiguracaoField: TDBMemo;
    Label11: TLabel;
    Label15: TLabel;
    tbsDados: TTabSheet;
    DBGrid3: TDBGrid;
    dtsDados: TDataSource;
    Regerarcampo1: TMenuItem;
    Label16: TLabel;
    cmbModuloPai: TDBLookupComboBox;
    Label17: TLabel;
    DBGrid4: TDBGrid;
    Label18: TLabel;
    dtsSubModulos: TDataSource;
    procedure btnNovoClick(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure btnCancelarClick(Sender: TObject);
    procedure DBLookupComboBox1Click(Sender: TObject);
    procedure trvQueriesChange(Sender: TObject; Node: TTreeNode);
    procedure FormCreate(Sender: TObject);
    procedure chkQueryPrincipalClick(Sender: TObject);
    procedure dtsStateChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure trvQueriesGetImageIndex(Sender: TObject; Node: TTreeNode);
    procedure GerarCampos1Click(Sender: TObject);
    procedure trvQueriesGetSelectedIndex(Sender: TObject; Node: TTreeNode);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure RemoverTodosCampos1Click(Sender: TObject);
    procedure RemoverCampo1Click(Sender: TObject);
    procedure Regerarcampo1Click(Sender: TObject);
  private
    procedure ChangeChecked(ACheckBox: TCheckBox; AState: Boolean);
    procedure GerenciaControles;
    procedure AddFieldOnTree(const sFieldName: string);
    procedure AddQueryOnTree(const sQueryName, sQueryPaiName: string);
    procedure FillTree;
    function GetNodeByText(ATree: TTreeView; const AValue: String;
      AVisible: Boolean): TTreeNode;
    procedure ExchangeNode(const Value: string);
    procedure DoEvent(Event: TEvent; Params: array of string);
    procedure GenerateParamsAndFields;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmMenu: TfrmMenu;

implementation

{$R *.dfm}

uses
  SysUtils, Variants, Windows;

procedure TfrmMenu.FormCreate(Sender: TObject);
begin
  PageControl1.ActivePageIndex := 0;
  DMGerenciador.SetEventMethod(DoEvent);
end;

procedure TfrmMenu.DoEvent(Event: TEvent; Params: array of string);
begin
  if Event = seQueryPaiChangedEvent then
    ExchangeNode(Params[0]);
end;

procedure TfrmMenu.btnNovoClick(Sender: TObject);
begin
  with DMGerenciador do
    if sender = btnNovoProvider then
      Insert(ttModule)
    else if sender = btnNovoQuery then
      Insert(ttQuery)
end;

procedure TfrmMenu.btnSalvarClick(Sender: TObject);
begin
  DMGerenciador.Save;
end;

procedure TfrmMenu.btnCancelarClick(Sender: TObject);
begin
  with DMGerenciador do
    if Sender = btnCancelarProvider then
      Cancel(ttModule)
    else if Sender = btnCancelarQuery then
      Cancel(ttQuery)
end;

procedure TfrmMenu.DBLookupComboBox1Click(Sender: TObject);
begin
  DMGerenciador.OpenModule;
  FillTree;
end;

procedure TfrmMenu.FillTree;
begin
  trvQueries.Items.Clear;
  DMGerenciador.IterateQueries(AddQueryOnTree, AddFieldOnTree);
  trvQueries.FullExpand;
end;

procedure TfrmMenu.AddQueryOnTree(const sQueryName, sQueryPaiName: string);
var
  Node: TTreeNode;
begin
  Node := nil;
  if sQueryPaiName <> EmptyStr then
    Node := GetNodeByText(trvQueries, sQueryPaiName, False);
  if Assigned(Node) then
    Node := trvQueries.Items.AddChildObject(Node, sQueryName,
      Pointer(tnNestedQuery))
  else
    Node := trvQueries.Items.AddObject(nil, sQueryName, Pointer(tnQuery));
  Node.Selected := True;  
end;

procedure TfrmMenu.AddFieldOnTree(const sFieldName: string);
begin
  trvQueries.Items.AddChildObject(trvQueries.Selected,
    sFieldName, Pointer(tnField));
end;

function TfrmMenu.GetNodeByText(ATree: TTreeView; const AValue: String;
  AVisible: Boolean): TTreeNode;
var
  Node: TTreeNode;
begin
  Result := nil;
  if ATree.Items.Count = 0 then Exit;
  Node := ATree.Items[0];
  while Node <> nil do
  begin
    if UpperCase(Node.Text) = UpperCase(AValue) then
    begin
      Result := Node;
      if AVisible then
        Result.MakeVisible;
      Break;
    end;
    Node := Node.GetNext;
  end;
end;

procedure TfrmMenu.trvQueriesChange(Sender: TObject; Node: TTreeNode);
begin
  if Assigned(Node) then
  begin
    if PageControl1.ActivePage <> tbsQuery then
      PageControl1.ActivePage := tbsQuery;
    case TTipoNode(Node.Data) of
      tnQuery, tnNestedQuery:
      begin
        DMGerenciador.FindItem(ttQuery, VarArrayOf([Node.Text]));
        ChangeChecked(chkQueryPrincipal, DMGerenciador.QueryIsPrincipal);
        chkQueryPrincipal.Enabled := not chkQueryPrincipal.Checked;
      end;
      tnField:
      begin
        DMGerenciador.FindItem(ttField,
          VarArrayOf([Node.Parent.Text, Node.Text]));
        PageControl2.ActivePage := tbsFields;
      end;
    end;
  end;
end;

procedure TfrmMenu.trvQueriesGetImageIndex(Sender: TObject;
  Node: TTreeNode);
begin
  if Assigned(Node) then
    Node.ImageIndex := Integer(Node.Data)-1;
end;

procedure TfrmMenu.trvQueriesGetSelectedIndex(Sender: TObject;
  Node: TTreeNode);
begin
  if Assigned(Node) then
    Node.SelectedIndex := Integer(Node.Data)-1;
end;

procedure TfrmMenu.chkQueryPrincipalClick(Sender: TObject);
begin
  DMGerenciador.SetDatasetToModule(chkQueryPrincipal.Checked);
  chkQueryPrincipal.Enabled := not chkQueryPrincipal.Checked;
end;

// Esta procedure s serve para mudana visual do checkbox. o OnClick nao
// ser dispearado.
procedure TfrmMenu.ChangeChecked(ACheckBox: TCheckBox; AState: Boolean);
var
  N: TNotifyEvent;
begin
  with ACheckBox do
  begin
    N := OnClick;
    OnClick := nil;
    Checked := AState;
    OnClick := N;
  end;
end;

procedure TfrmMenu.dtsStateChange(Sender: TObject);
begin
  GerenciaControles;
end;

procedure TfrmMenu.GerenciaControles;
begin
//  btnNovoProvider.Enabled := DMGerenciador.CanInsert(ttModule);
//  btnSalvarProvider.Enabled := DMGerenciador.CanSaveCancel(ttModule);
//  btnCancelarProvider.Enabled := btnSalvarProvider.Enabled;
//  chkQueryPrincipal.Enabled := chkQueryPrincipal.Enabled
//    and DMGerenciador.ModuloAberto;
//  btnNovoQuery.Enabled := DMGerenciador.CanInsert(ttQuery);
//  btnSalvarQuery.Enabled := DMGerenciador.CanSaveCancel(ttQuery);
//  btnCancelarQuery.Enabled := btnSalvarQuery.Enabled;
//  btnGerarCampos.Enabled :=
//    (btnNovoQuery.Enabled or btnSalvarQuery.Enabled)
//    and (Trim(edtSql.Lines.Text) <> EmptyStr);
//  btnNovoField.Enabled := DMGerenciador.CanInsert(ttField);
//  btnSalvarField.Enabled := DMGerenciador.CanSaveCancel(ttField);
//  btnCancelarField.Enabled := btnSalvarField.Enabled;
end;

procedure TfrmMenu.FormActivate(Sender: TObject);
begin
  GerenciaControles;
end;

procedure TfrmMenu.GerarCampos1Click(Sender: TObject);
begin
  GenerateParamsAndFields;
end;

procedure TfrmMenu.ExchangeNode(const Value: string);
var
  SelectedNode, ToNode: TTreeNode;
begin
  SelectedNode := trvQueries.Selected;
  if Value = EmptyStr then
    ToNode := nil
  else
    ToNode := GetNodeByText(trvQueries, Value, False);
  SelectedNode.MoveTo(ToNode, naAddChild);
end;

procedure TfrmMenu.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = VK_F9 then
  begin
    DMGerenciador.Save;
    dtsDados.DataSet := DMGerenciador.OpenQuery;
    PageControl2.ActivePage := tbsDados;
    Key := 0;
  end else if key = VK_F5 then
  begin
    GenerateParamsAndFields;
    Key := 0;
  end;
end;

procedure TfrmMenu.GenerateParamsAndFields;
begin
  DMGerenciador.Save;
  DMGerenciador.InsertParams;
  DMGerenciador.InsertFields;
  FillTree;
end;

procedure TfrmMenu.RemoverTodosCampos1Click(Sender: TObject);
begin
  DMGerenciador.DeleteAllFields;
  FillTree;
end;

procedure TfrmMenu.RemoverCampo1Click(Sender: TObject);
begin
  DMGerenciador.DeleteField;
  FillTree;
end;

procedure TfrmMenu.Regerarcampo1Click(Sender: TObject);
begin
  DMGerenciador.InsertField;
  FillTree;
end;

end.
