unit uParams;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, Grids, ValEdit;

type
  TFrmParams = class(TForm)
    ValueListEditor1: TValueListEditor;
    Button1: TButton;
    Button2: TButton;
    procedure FormShow(Sender: TObject);
    procedure ValueListEditor1DrawCell(Sender: TObject; ACol,
      ARow: Integer; Rect: TRect; State: TGridDrawState);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


  IFormParams = interface
    ['{B8ECC377-DA08-46CB-B82B-8D8A2D377700}']
    procedure Clear;
    function GetParams: TStrings;
    function Execute: boolean;
    property Params: TStrings read GetParams;
  end;

  TFormParams = class(TInterfacedObject, IFormParams)
  private
    FForm: TFrmParams;
    function GetParams: TStrings;
    function Execute: boolean;
    procedure Clear;
    { Private declarations }
  public
    property Params: TStrings read GetParams;
    constructor Create;
    destructor Destroy; override;
  end;
  
function GetFormParams: IFormParams;

implementation

{$R *.dfm}

function GetFormParams: IFormParams;
begin
  Result := TFormParams.Create;
end;

{ TfrmParams }

procedure TFrmParams.FormShow(Sender: TObject);
begin
  ValueListEditor1.SetFocus;
end;

{ TFormParams }

constructor TFormParams.Create;
begin
  inherited;
  FForm := TFrmParams.Create(nil);
end;

destructor TFormParams.Destroy;
begin
  FreeAndNil(FForm);
  inherited;
end;

procedure TFormParams.Clear;
begin
  FForm.ValueListEditor1.Strings.Clear;
end;

function TFormParams.Execute: boolean;
begin
  Result := FForm.ShowModal = mrOK;
end;

function TFormParams.GetParams: TStrings;
begin
  Result := FForm.ValueListEditor1.Strings;
end;

//TRecordColors = record
//    property ColorActive1: TColor index 1 read fColorActive1 write SetNewColor;
//    property ColorActive2: TColor index 2 read fColorActive2 write SetNewColor;
//    property ColorInactive1: TColor index 3 read fColorInactive1 write SetNewColor;
//    property ColorInactive2: TColor index 4 read fColorInactive2 write SetNewColor;
//    property ColorSelectedActive: TColor index 5 read fColorSelectedActive write SetNewColor;
//    property ColorSelectedInactive: TColor index 6 read fColorSelectedInactive write SetNewColor;
//    property ColorMultiSelectedActive1: TColor index 7 read fColorMultiSelectedActive1 write SetNewColor;
//    property ColorMultiSelectedActive2: TColor index 8 read fColorMultiSelectedActive2 write SetNewColor;
//    property ColorMultiSelectedInactive1: TColor index 9 read fColorMultiSelectedInactive1 write SetNewColor;
//    property ColorMultiSelectedInactive2: TColor index 10 read fColorMultiSelectedInactive2 write SetNewColor;
//    property ColorInplaceEditor: TColor index 11 read fColorInplaceEditor write SetNewColor;
//    property FontActive1: TFont index 1 read fFontActive1 write SetNewFont;
//    property FontActive2: TFont index 2 read fFontActive2 write SetNewFont;
//    property FontInactive1: TFont index 3 read fFontInactive1 write SetNewFont;
//    property FontInactive2: TFont index 4 read fFontInactive2 write SetNewFont;
//    property FontSelectedActive: TFont index 5 read fFontSelectedActive write SetNewFont;
//    property FontSelectedInactive: TFont index 6 read fFontSelectedInactive write SetNewFont;
//    property FontMultiSelectedActive1: TFont index 7 read fFontMultiSelectedActive1 write SetNewFont;
//    property FontMultiSelectedActive2: TFont index 8 read fFontMultiSelectedActive2 write SetNewFont;
//    property FontMultiSelectedInactive1: TFont index 9 read fFontMultiSelectedInactive1 write SetNewFont;
//    property FontMultiSelectedInactive2: TFont index 10 read fFontMultiSelectedInactive2 write SetNewFont;
//    property FramePenActive: TPen index 1 read fFramePenActive write SetNewPen;
//    property FramePenInactive: TPen index 2 read fFramePenInactive write SetNewPen;
//    property FrameOverride: boolean read fFrameOverride write SetFrameOverride;
//end;

procedure TFrmParams.ValueListEditor1DrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
begin
//  with ValueListEditor1 do
//  begin
//    try
//      if Assigned(ColorPresets_Key) and (ACol = 0) then
//        ColorPresetsLink := ColorPresets_Key;
//      if Assigned(ColorPresets_Value) and (ACol = 1) then
//        ColorPresetsLink := ColorPresets_Value;
//      if ARow < FixedRows then
//        exit;
//      if Focused or (assigned(InplaceEditor) and InplaceEditor.Visible) then
//      begin
//        if assigned(InplaceEditor) then
//          InplaceEditor.Brush.Color := ColorPresetsLink.ColorInplaceEditor;
//
//        if ARow mod 2 = 0 then
//          Canvas.Brush.Color := ColorPresetsLink.ColorActive1
//        else
//          Canvas.Brush.Color := ColorPresetsLink.ColorActive2;
//
//        if AState = [gdSelected, gdFocused] then
//          Canvas.Brush.Color := ColorPresetsLink.ColorSelectedActive;
//      end else
//      begin
//        if ARow mod 2 = 0 then
//          Canvas.Brush.Color := ColorPresetsLink.ColorInactive1 else
//          Canvas.Brush.Color := ColorPresetsLink.ColorInactive2;
//        if AState = [gdSelected] then
//          Canvas.Brush.Color := ColorPresetsLink.ColorSelectedInactive;
//      end;
//      if Focused or (assigned(InplaceEditor) and InplaceEditor.Visible) then
//      begin
//        if ARow mod 2 = 0 then
//          Canvas.Font.Assign(ColorPresetsLink.FontActive1)
//        else
//          Canvas.Font.Assign(ColorPresetsLink.FontActive2);
//        if AState = [gdSelected, gdFocused] then
//          Canvas.Font.Assign(ColorPresetsLink.FontSelectedActive);
//      end else
//      begin
//        if ARow mod 2 = 0 then
//          Canvas.Font.Assign(ColorPresetsLink.FontInactive1) else
//          Canvas.Font.Assign(ColorPresetsLink.FontInactive2);
//        if AState = [gdSelected] then
//          Canvas.Font.Assign(ColorPresetsLink.FontSelectedInactive);
//      end;
//      if ColorPresetsLink.FrameOverride then
//      begin
//        if Focused or (assigned(InplaceEditor) and InplaceEditor.Visible) then
//          Canvas.Pen.Assign(ColorPresetsLink.FramePenActive) else
//          Canvas.Pen.Assign(ColorPresetsLink.FramePenInactive);
//        Canvas.Pen.Style := psSolid;
//      end;
//    finally
//      inherited;
//    end;
//  end;
end;

end.
