unit uQuery;

interface

uses
  Classes, SqlExpr, DB, DBClient, Provider;

type
  IFullDataset = interface
    ['{59F1F163-AF2B-4C95-B2A7-C3AEF65F359A}']
    procedure Configure(AOwner: TComponent;
      AConnection: TSQLConnection; const sSQL: string);
    function OpenSQL(pParams: TStrings = nil): TDataset;
    function HasParams: boolean;
    procedure FillParams(FParams: TStrings);
    procedure Clear;
    function GetDataset: TDataset;
    function GetParams: TParams;
    function GetFields: TFieldDefs;
    function EOF: boolean;
    function Locate(const KeyFields: string;
      const KeyValues: Variant): boolean;
    function GetField(const pFieldName: string): TField;
    procedure Next;
  end;

  TFullDataset = class(TInterfacedObject, IFullDataset)
  private
    FQuery: TSQLQuery;
    FProvider: TDatasetProvider;
    FDataset: TClientDataset;
    procedure Clear;
    procedure Configure(AOwner: TComponent; AConnection: TSQLConnection;
      const sSQL: string);
    function OpenSQL(pParams: TStrings = nil): TDataset;
    function HasParams: boolean;
    procedure FillParams(FParams: TStrings);
    function GetDataset: TDataset;
    function GetParams: TParams;
    function GetFields: TFieldDefs;
    function Locate(const KeyFields: string;
      const KeyValues: Variant): boolean;
    function EOF: boolean;
    function GetField(const pFieldName: string): TField;
    procedure Next;
  end;

//    function Execute(const sSQL: string): integer;
//    procedure OpenSQL(const sSQL: string);
//    function Query: TSQLQuery;
//    constructor Create(Module: TDataModule);
//    destructor Destroy; override;
//    class function NewQuery(Module: TDataModule): IQuery;
//{ TQueryAux }
//
//class function TQueryAux.NewQuery(Module: TDataModule): IQuery;
//begin
//  Result := TQueryAux.Create(Module);
//end;
//
//constructor TQueryAux.Create(Module: TDataModule);
//begin
//  inherited Create;
//  FQuery := TSQLQuery.Create(Module);
//end;
//
//destructor TQueryAux.Destroy;
//begin
//  FQuery.Free;
//  inherited;
//end;
//
//function TQueryAux.Execute(const sSQL: string): integer;
//begin
//  with FQuery do
//  begin
//    Close;
//    SQL.Clear;
//    SQL.Text := sSQL;
//    Result := ExecSQL(True);
//    Close;
//  end;
//end;
//
//procedure TQueryAux.OpenSQL(const sSQL: string);
//var
//  i: integer;
//begin
//  with FQuery do
//  begin
//    FieldDefs.Updated := False;
//    Close;
//    Sql.Clear;
//    Sql.Add(pSQL);
//    if Params.Count <> 0 then
//      for i := 0 to Params.Count-1 do
//      begin
//        Params[i].DataType := ftInteger;
//        Params[i].ParamType := ptInput;
//      end;
//    Open;
//    FieldDefs.Update;
//  end;
//end;
//
//function TQueryAux.Query: TSQLQuery;
//begin
//  Result := FQuery;
//end;

function NewFullDataset: IFullDataset;

implementation

uses
  SysUtils;

function NewFullDataset: IFullDataset;
begin
  Result := TFullDataset.Create;
end;

{ TFullDataset }

procedure TFullDataset.Clear;
begin
  FDataset.Close;
  FQuery.Close;
  FQuery.SQL.Clear;
end;

procedure TFullDataset.Configure(AOwner: TComponent;
  AConnection: TSQLConnection; const sSQL: string);
begin
  if not Assigned(FQuery) then
    FQuery := TSQLQuery.Create(AOwner);
  if not Assigned(FProvider) then
    FProvider := TDataSetProvider.Create(AOwner);
  if not Assigned(FDataset) then
    FDataset := TClientDataSet.Create(AOwner);
  with FQuery do
  begin
    SQL.Text := sSQL;
    SQLConnection := AConnection;
  end;
  with FProvider do
  begin
    Name := 'Provider'+IntToStr(Random(800));
    DataSet := FQuery;
    Options := [poIncFieldProps, poReadOnly, poDisableInserts, poDisableEdits,
      poDisableDeletes, poAutoRefresh];
    UpdateMode := upWhereKeyOnly;
  end;
  with FDataset do
    ProviderName := FProvider.Name;
end;

function TFullDataset.HasParams: boolean;
begin
  Result := FQuery.Params.Count <> 0;
end;

procedure TFullDataset.FillParams(FParams: TStrings);
var
  i: integer;
begin
  with FParams do
  begin
    Clear;
    for i := 0 to FQuery.Params.Count-1 do
      Add(FQuery.Params[i].Name+'=');
  end;
end;

function TFullDataset.OpenSQL(pParams: TStrings = nil): TDataset;
var
  i: integer;
begin
  if Assigned(pParams) then
    for i := 0 to FQuery.Params.Count-1 do
      FQuery.Params[i].AsString := pParams.ValueFromIndex[i];
  FDataset.Open;
  Result := FDataset;
end;

function TFullDataset.GetDataset: TDataset;
begin
  Result := FDataset;
end;

function TFullDataset.GetParams: TParams;
begin
  Result := FQuery.Params;
end;

function TFullDataset.GetFields: TFieldDefs;
begin
  FQuery.FieldDefs.Update;
  Result := FQuery.FieldDefs;
end;

function TFullDataset.EOF: boolean;
begin
  Result := FDataset.EOF;
end;

procedure TFullDataset.Next;
begin
  FDataset.Next;
end;

function TFullDataset.GetField(const pFieldName: string): TField;
begin
  Result := FDataset.FieldByName(pFieldName);
end;

function TFullDataset.Locate(const KeyFields: string;
  const KeyValues: Variant): boolean;
begin
  Result := FDataset.Locate(KeyFields, KeyValues, []);
end;

end.
