unit uUtils;

interface

uses
  Classes;

type
  TTipoDataset = (ttNone, ttModule, ttQuery, ttField);
  TScrollMethod = procedure (DataSet: TTipoDataset) of Object;

  TScrollItem = class
  private
    FDataset: TTipoDataset;
    FScrollMethod: TScrollMethod;
  public
    Constructor Create(pDataset: TTipoDataset;
      pScrollMethod: TScrollMethod);
    property Execute: TScrollMethod read FScrollMethod;
  end;

  TScrollList = class
  private
    FScrolling: boolean;
    FItems: TList;
    function GetItem(Value: TTipoDataset): TScrollItem;
  public
    function AddItem(pDataset: TTipoDataset;
      pScrollMethod: TScrollMethod): TScrollItem;
    procedure CallScroll(Dataset: TTipoDataset);
    property ScrollItem[Dataset: TTipoDataset]: TScrollItem read GetItem;
    property Scrolling: boolean read FScrolling write FScrolling;
  end;

const
  // *** problema, nao est pegando o notnull do domain
  cFieldsOfQuery =
    ' SELECT A.RDB$FIELD_NAME AS NM_FIELD,'+
    '   C.RDB$FIELD_NAME AS NM_FIELD_KEY,'+
    '   COALESCE(A.RDB$NULL_FLAG, D.RDB$NULL_FLAG) AS LG_NOTNULL'+
    ' FROM RDB$RELATION_FIELDS A'+
    ' LEFT OUTER JOIN RDB$RELATION_CONSTRAINTS B ON'+
    '   (B.RDB$RELATION_NAME = A.RDB$RELATION_NAME AND'+
    '   B.RDB$CONSTRAINT_TYPE = ''PRIMARY KEY'')'+
    ' LEFT OUTER JOIN RDB$INDEX_SEGMENTS C ON '+
    '   (C.RDB$INDEX_NAME = B.RDB$INDEX_NAME AND '+
    '   C.RDB$FIELD_NAME = A.RDB$FIELD_NAME)'+
    ' LEFT OUTER JOIN RDB$FIELDS D ON'+
    '   (D.RDB$FIELD_NAME = A.RDB$FIELD_SOURCE)'+
    ' WHERE UPPER(A.RDB$RELATION_NAME) = UPPER(%s)';

implementation

{ TScrollItem }

constructor TScrollItem.Create(pDataset: TTipoDataset;
  pScrollMethod: TScrollMethod);
begin
  FDataset := pDataset;
  FScrollMethod := pScrollMethod;
end;

{ TScrollList }

function TScrollList.AddItem(pDataset: TTipoDataset;
  pScrollMethod: TScrollMethod): TScrollItem;
begin
  Result := TScrollItem.Create(pDataset, pScrollMethod);
  FItems.Add(Result);
end;

procedure TScrollList.CallScroll(Dataset: TTipoDataset);
var
  oSi: TScrollItem;
begin
  FScrolling := True;
  try
    oSi := ScrollItem[Dataset];
    if Assigned(oSi) then
      oSi.Execute(Dataset);
  finally
    FScrolling := False;
  end;
end;

function TScrollList.GetItem(Value: TTipoDataset): TScrollItem;
var
  i: integer;
begin
  Result := nil;
  for i := 0 to FItems.Count-1 do
    if TScrollItem(FItems[i]).FDataset = Value then
    begin
      Result := TScrollItem(FItems[i]);
      Break;
    end;
end;

end.
