unit UFormConsultaPkg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFormBase, StdCtrls, ExtCtrls, Grids, DBGrids, DB, DBTables;

type
  T_frmFormConsultaPkg = class(T_frmFormBase)
    _pnlTopo: TPanel;
    Label1: TLabel;
    _cbxCampo: TComboBox;
    _pnlGrade: TPanel;
    _edtTexto: TEdit;
    _btnOk: TButton;
    _dbgConsulta: TDBGrid;
    _sqlConsulta: TQuery;
    _dtsConsulta: TDataSource;
    procedure _btnOkClick(Sender: TObject);
    procedure _dbgConsultaDblClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    FcSQL: string;
    procedure sqlConsulta();
    procedure getCampos();
  public
    property SQL: string read FcSQL write FcSQL;
  end;

  function ExecutaModulo(const loDB: TDataBase; const lcSQL, lcResultField: string): string; stdcall;

  exports ExecutaModulo;

var
  _frmFormConsultaPkg: T_frmFormConsultaPkg;

implementation

{$R *.dfm}

function ExecutaModulo(const loDB: TDataBase; const lcSQL, lcResultField: string): string; stdcall;
var
  loForm: T_frmFormConsultaPkg;
begin
  loForm := T_frmFormConsultaPkg.Create(Application);
  try
    loForm.DB  := loDB;
    loForm.SQL := lcSQL;
    if loForm.ShowModal() = mrOk then
      result := loForm._sqlConsulta.FieldByname(lcResultField).AsString
    else
      result := '';
  finally
    loForm.Free;
  end;
end;

procedure T_frmFormConsultaPkg.FormShow(Sender: TObject);
begin
  inherited;
  getCampos();
end;

procedure T_frmFormConsultaPkg.getCampos;
var
  lnLoop: Integer;
begin
  try
    _sqlConsulta.Close;
    _sqlConsulta.DatabaseName := Self.DB.DatabaseName;
    _sqlConsulta.SQL.Clear();
    _sqlConsulta.SQL.Add(FcSQL);
    _sqlConsulta.SQL.Add('WHERE 1=2');
    _sqlConsulta.Open;

    _cbxCampo.Items.Clear;
    for lnLoop := 0 to _sqlConsulta.Fields.Count -1 do
      _cbxCampo.Items.Add(_sqlConsulta.Fields[lnLoop].FieldName);
      
  except
    on e: exception do
      ShowMessage('Erro: ' + e.Message);
  end;

end;

procedure T_frmFormConsultaPkg.sqlConsulta;
begin
  try
    _sqlConsulta.Close;
    _sqlConsulta.DatabaseName := Self.DB.DatabaseName;
    _sqlConsulta.SQL.Clear();
    _sqlConsulta.SQL.Add(FcSQL);
    _sqlConsulta.SQL.Add('WHERE');
    _sqlConsulta.SQL.Add(_cbxCampo.Text + ' LIKE :BUSCA');
    _sqlConsulta.ParamByName('BUSCA').AsString := '%' + _edtTexto.text + '%';
    _sqlConsulta.Open;
  except
    on e: exception do
      ShowMessage('Erro: ' + e.Message);
  end;
end;

procedure T_frmFormConsultaPkg._btnOkClick(Sender: TObject);
begin
  if trim(_cbxCampo.Text)= '' then
    begin
    ShowMessage('Informe um campo');
    exit;
    end;

  if trim(_edtTexto.Text) = '' then
    begin
    ShowMessage('Informe um texto');
    exit;
    end;

  sqlConsulta();
end;

procedure T_frmFormConsultaPkg._dbgConsultaDblClick(Sender: TObject);
begin
  if not _sqlConsulta.IsEmpty then
    ModalResult := mrOk;
end;

end.
