unit UFormCadastroBase;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFormBase, ComCtrls, ImgList, ToolWin, ExtCtrls, DB, DBTables;

type
  T_frmFormCadastroBase = class(T_frmFormBase)
    _pnlControles: TPanel;
    ToolBar1: TToolBar;
    ImageList1: TImageList;
    _btnIncluir: TToolButton;
    _btnAlterar: TToolButton;
    _btnExcluir: TToolButton;
    _btnCancelar: TToolButton;
    _btnSalvar: TToolButton;
    _btnLocalizar: TToolButton;
    _btnSair: TToolButton;
    _sqlCadastro: TQuery;
    _btnImprimir: TToolButton;
    procedure _btnSairClick(Sender: TObject);
    procedure _btnIncluirClick(Sender: TObject);
    procedure _btnAlterarClick(Sender: TObject);
    procedure _btnCancelarClick(Sender: TObject);
    procedure _btnSalvarClick(Sender: TObject);
    procedure _btnExcluirClick(Sender: TObject);
    procedure _btnLocalizarClick(Sender: TObject);
    procedure _btnImprimirClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    // saber qual operacao esta sendo realizada no momento
    FcOperacao: Char;
  protected
    function doIncluir: boolean; virtual; abstract;
    function doAlterar: boolean; virtual; abstract;
    function doExcluir: boolean; virtual; abstract;
    procedure doImprimir; virtual; abstract;
    function doSalvar: boolean; virtual;

    function doExisteRegistro: boolean; virtual; abstract;
    function doValida(): boolean; virtual;
    function doConsulta(): boolean; virtual; abstract;
    function doLerRegistro(): boolean; virtual; abstract;

    procedure doLimpaCampos; virtual; abstract;
    function getOperacao: char;
  public
    { Public declarations }
  end;

var
  _frmFormCadastroBase: T_frmFormCadastroBase;

implementation

{$R *.dfm}

function T_frmFormCadastroBase.doSalvar: boolean;
begin
  if FcOperacao = 'I' then
    result := doIncluir()
  else
    result := doAlterar();
end;

function T_frmFormCadastroBase.doValida: boolean;
begin
  result := true;
end;

procedure T_frmFormCadastroBase.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  case key of
    VK_F3: if _btnIncluir.Enabled then _btnIncluir.Click;
    VK_F4: if _btnAlterar.Enabled then _btnAlterar.Click;
    VK_F5: if _btnExcluir.Enabled then _btnExcluir.Click;
  end;

  inherited;

end;

procedure T_frmFormCadastroBase.FormShow(Sender: TObject);
begin
  inherited;
  _btnCancelar.Enabled := false;
  _btnSalvar  .Enabled := false;
end;

function T_frmFormCadastroBase.getOperacao: char;
begin
  result := FcOperacao;
end;

procedure T_frmFormCadastroBase._btnImprimirClick(Sender: TObject);
begin
  if _btnSalvar.Enabled then
    begin
    ShowMessage('Essa operao no pode ser realizada com a tabela em edio');
    exit;
    end; 

  doImprimir();
end;

procedure T_frmFormCadastroBase._btnAlterarClick(Sender: TObject);
begin
  // verifica se existe algum registro selecionado
  if not doExisteRegistro then
    begin
    ShowMessage('No h nenhum registro selecionado');
    exit;
    end;

  FcOperacao := 'A';
  _btnIncluir.Enabled   := false;
  _btnAlterar.Enabled   := false;
  _btnExcluir.Enabled   := false;
  _btnLocalizar.Enabled := false;
  _btnCancelar.Enabled  := true;
  _btnSalvar.Enabled    := true;
  _pnlControles.Enabled := true;
end;

procedure T_frmFormCadastroBase._btnCancelarClick(Sender: TObject);
begin
  if MessageDlg ('Confirma cancelar a operao?',
     mtConfirmation, [mbYes,mbNO], 0) = mrNo then exit;
  // volta os controles para o status 0
  _btnIncluir.Enabled   := true;
  _btnAlterar.Enabled   := true;
  _btnExcluir.Enabled   := true;
  _btnLocalizar.Enabled := true;
  _btnCancelar.Enabled  := false;
  _btnSalvar.Enabled    := false;
  _pnlControles.Enabled := false;
  // ler o registro novamente do banco de dados
  doLerRegistro();
end;

procedure T_frmFormCadastroBase._btnExcluirClick(Sender: TObject);
begin
  // verfica se existe algum registro selecionado
  if not doExisteRegistro then
    begin
    ShowMessage('No h nenhum registro selecionado');
    exit;
    end;
  // confirma a exclusao do registro
  if MessageDlg('Tem certeza que deseja excluir o registro selecionado?',
     mtConfirmation, [mbYes, mbNo], 0) = mrYes then
    begin
    // realiza a exclusao
    if doExcluir() then
      doLimpaCampos();
    end;
end;

procedure T_frmFormCadastroBase._btnIncluirClick(Sender: TObject);
begin
  FcOperacao := 'I';
  // desativa os controles basicos
  _btnIncluir.Enabled   := false;
  _btnAlterar.Enabled   := false;
  _btnExcluir.Enabled   := false;
  _btnLocalizar.Enabled := false;
  _btnCancelar.Enabled  := true;
  _btnSalvar.Enabled    := true;
  _pnlControles.Enabled := true;
  // limpa os campos
  doLimpaCampos();
end;

procedure T_frmFormCadastroBase._btnLocalizarClick(Sender: TObject);
begin
  if doConsulta() then
    doLerRegistro();
end;

procedure T_frmFormCadastroBase._btnSairClick(Sender: TObject);
begin
  Close;
end;

procedure T_frmFormCadastroBase._btnSalvarClick(Sender: TObject);
begin
  if not doValida() then exit;
  if not doSalvar() then exit;
  _btnIncluir.Enabled   := true;
  _btnAlterar.Enabled   := true;
  _btnExcluir.Enabled   := true;
  _btnLocalizar.Enabled := true;
  _btnCancelar.Enabled  := false;
  _btnSalvar.Enabled    := false;
  _pnlControles.Enabled := false;
end;

end.
