unit UFormGrupos;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UFormCadastroBase, ImgList, ComCtrls, ToolWin, ExtCtrls, StdCtrls,
  DB, DBTables;

type
  T_frmFormGrupos = class(T_frmFormCadastroBase)
    Label1: TLabel;
    _edtDescricao: TEdit;
    Label2: TLabel;
    _edtCodigo: TEdit;
    procedure _btnIncluirClick(Sender: TObject);
    procedure _btnAlterarClick(Sender: TObject);
  private
    FcCodigo: string;
    function existeCodigo(): boolean;
  protected
    function doIncluir: boolean; override;
    function doAlterar: boolean; override;
    function doExcluir: boolean; override;
    procedure doImprimir; override;

    function doExisteRegistro: boolean; override;
    function doValida(): boolean; override;
    function doConsulta(): boolean; override;
    function doLerRegistro(): boolean; override;

    procedure doLimpaCampos; override;
  public
    { Public declarations }
  end;

  procedure ExecutaModulo(const loDB: TDataBase); stdcall;

  exports ExecutaModulo;

var
  _frmFormGrupos: T_frmFormGrupos;

implementation

{$R *.dfm}

procedure ExecutaModulo(const loDB: TDataBase); stdcall;
var
  loForm: T_frmFormGrupos;
begin
  loForm := T_frmFormGrupos.Create(Application);
  try
    loForm.DB := loDB;
    loForm.ShowModal();
  finally
    loForm.Free;
  end;
end;

function myStrToInt(lcStr: string): integer;
begin
  try
    result := StrToInt(lcStr);
  except
    result := 0;
  end;
end;

function T_frmFormGrupos.doAlterar: boolean;
begin
  try
    _sqlCadastro.Close();
    _sqlCadastro.DatabaseName := Self.DB.DatabaseName;
    _sqlCadastro.SQL.Clear();
    _sqlCadastro.SQL.Add('UPDATE GRUPOS                 ');
    _sqlCadastro.SQL.Add('   SET DESCRICAO = :DESCRICAO ');
    _sqlCadastro.SQL.Add(' WHERE CODIGO = :CODIGO       ');
    _sqlCadastro.ParamByName('CODIGO'   ).AsString := _edtCodigo.text;
    _sqlCadastro.ParamByName('DESCRICAO').AsString := _edtDescricao.text;
    _sqlCadastro.ExecSQL();

    result := _sqlCadastro.RowsAffected = 1;
  except
    on e: exception do
      begin
      result := false;
      ShowMessage(E.Message);
      end;
  end;
end;

function T_frmFormGrupos.doConsulta: boolean;
type
  TExecutaModulo = function (const loDB: TDataBase; const lcSQL, lcResultField: string): string; stdcall;
var
  ExecutaModulo: TExecutaModulo;
  loHandle: THandle;
begin
  loHandle := LoadPackage('ConsultaPkg.bpl');
  result   := loHandle > 0;

  if result then
    begin
    @ExecutaModulo := getProcAddress(loHandle, 'ExecutaModulo');
    FcCodigo       := ExecutaModulo(Self.DB, 'SELECT * FROM GRUPOS', 'CODIGO');
    Result         := Trim(FcCodigo) <> '';
    end;
end;

function T_frmFormGrupos.doExcluir: boolean;
begin
  try
    _sqlCadastro.Close();
    _sqlCadastro.DatabaseName := Self.DB.DatabaseName;
    _sqlCadastro.SQL.Clear();
    _sqlCadastro.SQL.Add('DELETE FROM GRUPOS      ');
    _sqlCadastro.SQL.Add(' WHERE CODIGO = :CODIGO ');
    _sqlCadastro.ParamByName('CODIGO').AsString := _edtCodigo.text;
    _sqlCadastro.ExecSQL();

    result := _sqlCadastro.RowsAffected = 1;
  except
    on e: exception do
      begin
      result := false;
      ShowMessage(E.Message);
      end;
  end;
end;

function T_frmFormGrupos.doExisteRegistro: boolean;
begin
  try
    result := _sqlCadastro.Active and (not _sqlCadastro.IsEmpty);
  except
    on e: exception do
      begin
      result := false;
      ShowMessage(E.Message);
      end;
  end;
end;

procedure T_frmFormGrupos.doImprimir;
type
  TExecutaModulo = procedure (const loDB: TDataBase); stdcall;
var
  ExecutaModulo: TExecutaModulo;
  loHandle: THandle;
begin
  loHandle := LoadPackage('FormRelatorioGruposPkg.bpl');
  if loHandle > 0 then
    begin
    @ExecutaModulo := getProcAddress(loHandle, 'ExecutaModulo');
    ExecutaModulo(Self.DB);
    FreeLibrary(loHandle);
    end;
end;

function T_frmFormGrupos.doIncluir: boolean;
begin
  try
    _sqlCadastro.Close();
    _sqlCadastro.DatabaseName := Self.DB.DatabaseName;
    _sqlCadastro.SQL.Clear();
    _sqlCadastro.SQL.Add('INSERT INTO GRUPOS ');
    _sqlCadastro.SQL.Add('(                  ');
    _sqlCadastro.SQL.Add('  CODIGO,          ');
    _sqlCadastro.SQL.Add('  DESCRICAO        ');
    _sqlCadastro.SQL.Add(')                  ');
    _sqlCadastro.SQL.Add('  VALUES           ');
    _sqlCadastro.SQL.Add('(                  ');
    _sqlCadastro.SQL.Add('  :CODIGO,         ');
    _sqlCadastro.SQL.Add('  :DESCRICAO       ');
    _sqlCadastro.SQL.Add(')                  ');
    _sqlCadastro.ParamByName('CODIGO'   ).AsString := _edtCodigo.text;
    _sqlCadastro.ParamByName('DESCRICAO').AsString := _edtDescricao.text;
    _sqlCadastro.ExecSQL();

    result := _sqlCadastro.RowsAffected = 1;
  except
    on e: exception do
      begin
      result := false;
      ShowMessage(E.Message);
      end;
  end;
end;

function T_frmFormGrupos.doLerRegistro: boolean;
begin
  try
    _sqlCadastro.Close();
    _sqlCadastro.DatabaseName := Self.DB.DatabaseName;
    _sqlCadastro.SQL.Clear();
    _sqlCadastro.SQL.Add('SELECT * FROM GRUPOS          ');
    _sqlCadastro.SQL.Add(' WHERE CODIGO = :CODIGO       ');
    _sqlCadastro.ParamByName('CODIGO').AsInteger := myStrToInt(FcCodigo);
    _sqlCadastro.Open;

    _edtCodigo   .Text := _sqlCadastro.FieldByName('CODIGO').AsString;
    _edtDescricao.Text := _sqlCadastro.FieldByName('DESCRICAO').AsString;

    result := true;

  except
    on e: exception do
      begin
      result := false;
      ShowMessage(E.Message);
      end;
  end;
end;

procedure T_frmFormGrupos.doLimpaCampos;
begin
  _edtCodigo.Clear();
  _edtDescricao.Clear();
end;

function T_frmFormGrupos.doValida: boolean;
begin
  result := false;

  if trim(_edtCodigo.Text) = '' then
    begin
    ShowMessage('Informe um cdigo');
    exit;
    end;

  if trim(_edtDescricao.Text) = '' then
    begin
    ShowMessage('Informe uma descrio');
    exit;
    end;

  if getOperacao = 'I' then
    begin
    if existeCodigo then
      begin
      ShowMessage('J existe um grupo cadastrado com esse cdigo');
      exit;
      end;
    end;

  result := true;
end;

function T_frmFormGrupos.existeCodigo: boolean;
begin
  try
    _sqlCadastro.Close();
    _sqlCadastro.DatabaseName := Self.DB.DatabaseName;
    _sqlCadastro.SQL.Clear();
    _sqlCadastro.SQL.Add('SELECT COUNT(1)               ');
    _sqlCadastro.SQL.Add('  FROM GRUPOS                 ');
    _sqlCadastro.SQL.Add(' WHERE CODIGO = :CODIGO       ');
    _sqlCadastro.ParamByName('CODIGO').AsString := _edtCodigo.text;
    _sqlCadastro.Open();

    result := _sqlCadastro.Fields[0].asInteger = 1;

    _sqlCadastro.Close();
  except
    on e: exception do
      begin
      result := true;
      ShowMessage(E.Message);
      end;
  end;
end;

procedure T_frmFormGrupos._btnAlterarClick(Sender: TObject);
begin
  inherited;

  if _edtCodigo.CanFocus then
    begin
    _edtCodigo.Enabled := false;
    _edtDescricao.SetFocus;
    end;
end;

procedure T_frmFormGrupos._btnIncluirClick(Sender: TObject);
begin
  inherited;
  _edtCodigo.Enabled := true;
  _edtCodigo.SetFocus;
end;

end.
