unit DBGridHacked;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, DBClient, Grids, DBGrids, ExtCtrls, DBCtrls, Midaslib;
  //MIDASLIB adicionado  clausula uses. Midas.dll no  necessrio.

type
  TfmDBGridHacked = class(TForm)
    cdsAnimals: TClientDataSet;
    dsAnimals: TDataSource;
    dbgAnimals: TDBGrid;
    procedure dbgAnimalsDrawColumnCell(Sender: TObject; const Rect: TRect;
      DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure dbgAnimalsTitleClick(Column: TColumn);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmDBGridHacked: TfmDBGridHacked;

implementation

{$R *.dfm}

type
  THackedDBGrid = class(TDBGrid)
  end;

procedure TfmDBGridHacked.dbgAnimalsDrawColumnCell(Sender: TObject;
  const Rect: TRect; DataCol: Integer; Column: TColumn;
  State: TGridDrawState);
var
  Row: Integer;
  Figura: TPicture;
  RetanguloReduzido: TRect;
begin
  if Column.FieldName = 'BMP' then
  begin
    //Pintar figura
    Figura := TPicture.Create;
    try
      Figura.Assign(Column.Field);

      RetanguloReduzido := Bounds(Rect.Left, Rect.Top, Figura.Width div 2, Figura.Height div 2);
      dbgAnimals.Canvas.StretchDraw(RetanguloReduzido, Figura.Bitmap);

      //Ajusta tamanho da linha
      Row := dbgAnimals.MouseCoord(Rect.Left, Rect.Top).Y;
      THackedDBGrid(dbgAnimals).RowHeights[Row] := Figura.Bitmap.Height div 2;

      //Ajusta tamanho da coluna
      if (Figura.Bitmap.Width div 2) > Column.Width then
        Column.Width := (Figura.Bitmap.Width div 2);
    finally
      FreeAndNil(Figura);
    end;
  end
  else
  begin
    //Fazer grid zebrado
    dbgAnimals.Canvas.Brush.Style := bsSolid;
    dbgAnimals.Font.Color := clBlack;
    if (cdsAnimals.RecNo mod 2) = 0 then
    begin
      dbgAnimals.Canvas.Brush.Color := $DDDDDD;
    end
    else
    begin
      dbgAnimals.Canvas.Brush.Color := $FFFFFF;
    end;

    dbgAnimals.DefaultDrawColumnCell(Rect, DataCol, Column, State);
  end;
end;

procedure TfmDBGridHacked.dbgAnimalsTitleClick(Column: TColumn);
begin
  cdsAnimals.IndexFieldNames := Column.FieldName;
end;

end.
