unit DBXMonitor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, WideStrings, FMTBcd, StdCtrls, ExtCtrls, DBCtrls, Grids, DBGrids, DB,
  DBClient, Provider, SqlExpr, DBXCommon, StrUtils;

type
  TfmDBXMonitor = class(TForm)
    SQLConn: TSQLConnection;
    sqMercado: TSQLQuery;
    dspMercado: TDataSetProvider;
    cdsMercado: TClientDataSet;
    dsMercado: TDataSource;
    DBGrid1: TDBGrid;
    DBNavigator1: TDBNavigator;
    Button1: TButton;
    cdsMercadoNOME_CLIENTE: TStringField;
    cdsMercadoDATA_COMPRA: TDateField;
    cdsMercadoNOME_PRODUTO: TStringField;
    sqMercadoNOME_CLIENTE: TStringField;
    sqMercadoDATA_COMPRA: TDateField;
    sqMercadoNOME_PRODUTO: TStringField;
    sqMercadoQUANTIDADE: TIntegerField;
    sqMercadoID_COMPRA: TIntegerField;
    sqMercadoID_PRODUTO: TIntegerField;
    cdsMercadoQUANTIDADE: TIntegerField;
    cdsMercadoID_COMPRA: TIntegerField;
    cdsMercadoID_PRODUTO: TIntegerField;
    SQLMonitor: TSQLMonitor;
    procedure dspMercadoGetTableName(Sender: TObject; DataSet: TDataSet;
      var TableName: WideString);
    procedure Button1Click(Sender: TObject);
    procedure SQLMonitorTrace(Sender: TObject; TraceInfo: TDBXTraceInfo;
      var LogTrace: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmDBXMonitor: TfmDBXMonitor;

implementation

{$R *.dfm}

procedure TfmDBXMonitor.Button1Click(Sender: TObject);
begin
  cdsMercado.ApplyUpdates(0);
end;

procedure TfmDBXMonitor.dspMercadoGetTableName(Sender: TObject;
  DataSet: TDataSet; var TableName: WideString);
begin
  TableName := 'COMPRA_PRODUTO';
end;

procedure TfmDBXMonitor.SQLMonitorTrace(Sender: TObject;
  TraceInfo: TDBXTraceInfo; var LogTrace: Boolean);
var
  Command: string;
begin
  Command := LowerCase(LeftStr(TraceInfo.Message, 6));
  if (Command = 'select') or (Command = 'insert') or
    (Command = 'update') then
    ShowMessage(TraceInfo.Message);  
end;

end.
