unit Dragging;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, StdCtrls;

type
  TfmDragging = class(TForm)
    edSource: TEdit;
    lbItems: TListBox;
    pnDelete: TPanel;
    procedure lbItemsDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure pnDeleteDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure lbItemsDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure pnDeleteDragDrop(Sender, Source: TObject; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmDragging: TfmDragging;

implementation

{$R *.dfm}

procedure TfmDragging.lbItemsDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  lbItems.Items.Add(edSource.Text);
end;

procedure TfmDragging.lbItemsDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Accept := Source = edSource;
end;

procedure TfmDragging.pnDeleteDragDrop(Sender, Source: TObject; X, Y: Integer);
begin
  lbItems.Items.Delete(lbItems.ItemIndex);
end;

procedure TfmDragging.pnDeleteDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Accept := Source = lbItems;
end;

end.
