unit RTTI1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ExtCtrls, Grids, ValEdit, ComCtrls, StdCtrls, TypInfo;

type
  TfmRTTI1 = class(TForm)
    ObjectInspector: TValueListEditor;
    Splitter1: TSplitter;
    pnDesigner: TPanel;
    Button1: TButton;
    Edit1: TEdit;
    CheckBox1: TCheckBox;
    RadioButton1: TRadioButton;
    ProgressBar1: TProgressBar;
    procedure FormCreate(Sender: TObject);
    procedure ObjectInspectorKeyPress(Sender: TObject; var Key: Char);
    procedure CheckBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    SelectedComponent: TComponent;
  public
    procedure ChangeSelection(Component: TComponent);
    function CloneComponent(Component: TComponent): TComponent;
    procedure DeleteComponent(Component: TComponent);
    procedure RefreshProperties;
  end;

var
  fmRTTI1: TfmRTTI1;

implementation

{$R *.dfm}

procedure TfmRTTI1.ChangeSelection(Component: TComponent);
begin
  SelectedComponent := Component;
  Self.Caption := 'Editando Componente: ' + Component.Name + ' - Ctrl+Alt+Click = ' +
    'Clonar - Ctrl+Shift+Click = Remover';
  RefreshProperties;
end;

procedure TfmRTTI1.FormCreate(Sender: TObject);
begin
  ChangeSelection(CheckBox1);
end;

procedure TfmRTTI1.RefreshProperties;
var
  PropList: PPropList;
  PropCount: Integer;
  i: Integer;
  PropInfo: TPropInfo;
  PropValue: Variant;
begin
  ObjectInspector.Strings.Clear;

  PropCount := GetPropList(SelectedComponent, PropList);
  SortPropList(PropList, PropCount);

  for i := 0 to Pred(PropCount) do
  begin
    PropInfo := TPropInfo(PropList^[i]^);
    PropValue := GetPropValue(SelectedComponent, PropInfo.Name);
    ObjectInspector.InsertRow(PropInfo.Name, VarToStr(PropValue), True);
  end;
end;

procedure TfmRTTI1.ObjectInspectorKeyPress(Sender: TObject; var Key: Char);
var
  PropertyName: string;
  PropertyValue: string;
begin
  if Key = #13 then
  begin
    PropertyName := ObjectInspector.Keys[ObjectInspector.Selection.Top];
    PropertyValue := ObjectInspector.Values[PropertyName];
    SetPropValue(SelectedComponent, PropertyName, PropertyValue);
  end;
end;

procedure TfmRTTI1.CheckBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if ([ssCtrl, ssAlt] * Shift) = [ssCtrl, ssAlt] then
    ChangeSelection(CloneComponent(Sender as TComponent))
  else if ([ssCtrl, ssShift] * Shift) = [ssCtrl, ssShift] then
    DeleteComponent(Sender as TComponent)
  else
    ChangeSelection(Sender as TComponent);
end;

function TfmRTTI1.CloneComponent(Component: TComponent): TComponent;
var
  PropList: PPropList;
  PropCount: Integer;
  i: Integer;
  PropInfo: TPropInfo;
  PropValue: Variant;
  PropTypeKind: TTypeKind;
  TmpObjProp: TObject;
  TmpIntfProp: IInterface;
  TmpMethodProp: TMethod;
  ComponentClass: TComponentClass;
  ResultName: string;
begin
  SelectedComponent := Component;

  ComponentClass := TComponentClass(Component.ClassType);
  Result := ComponentClass.Create(Component.Owner);

  i := 1;
  repeat
    ResultName := 'Clonado' + IntToStr(i);
    Inc(i);
  until FindComponent(ResultName) = nil;

  PropCount := GetPropList(SelectedComponent, PropList);

  for i := 0 to Pred(PropCount) do
  begin
    PropInfo := TPropInfo(PropList^[i]^);
    PropValue := GetPropValue(SelectedComponent, PropInfo.Name);
    PropTypeKind := PropType(SelectedComponent, PropInfo.Name);

    if PropTypeKind = tkClass then
    begin
      TmpObjProp := GetObjectProp(SelectedComponent, PropInfo.Name);
      SetObjectProp(Result, PropInfo.Name, TmpObjProp);
    end
    else if PropTypeKind = tkInterface then
    begin
      TmpIntfProp := GetInterfaceProp(SelectedComponent, PropInfo.Name);
      SetInterfaceProp(Result, PropInfo.Name, TmpIntfProp);
    end
    else if PropTypeKind = tkMethod then
    begin
      TmpMethodProp := GetMethodProp(SelectedComponent, PropInfo.Name);
      SetMethodProp(Result, PropInfo.Name, TmpMethodProp);
    end
    else
    begin
      if PropInfo.Name = 'Name' then
        Result.Name := ResultName
      else if PropInfo.Name = 'Left' then
        (Result as TControl).Left := (Component as TControl).Left + 15
      else if PropInfo.Name = 'Top' then
        (Result as TControl).Top := (Component as TControl).Top + 15
      else
        SetPropValue(Result, PropInfo.Name, PropValue);
    end;
  end;

  (Result as TControl).Parent := (Component as TControl).Parent;
end;

procedure TfmRTTI1.DeleteComponent(Component: TComponent);
var
  SelectFirst: Boolean;
begin
  if pnDesigner.ControlCount > 1 then
  begin
    SelectFirst := SelectedComponent = Component;

    pnDesigner.RemoveControl(Component as TControl);
    FreeAndNil(Component);

    if SelectFirst then
      ChangeSelection(pnDesigner.Controls[0]);
  end;
end;

end.
