unit Streams;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, zLib;

type
  TfmStreams = class(TForm)
    edAbrir: TEdit;
    btPAbrir: TButton;
    mmFile: TMemo;
    btAbrir: TButton;
    btSalvar: TButton;
    edSalvar: TEdit;
    btPSalvar: TButton;
    OpenDialog: TOpenDialog;
    cbCompress: TCheckBox;
    btAbrirSalvar: TButton;
    procedure btPAbrirClick(Sender: TObject);
    procedure btAbrirClick(Sender: TObject);
    procedure btSalvarClick(Sender: TObject);
    procedure btAbrirSalvarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmStreams: TfmStreams;

implementation

{$R *.dfm}

procedure TfmStreams.btAbrirSalvarClick(Sender: TObject);
var
  FileStreamIn: TFileStream;
  FileStreamOut: TFileStream;
begin
  FileStreamIn := TFileStream.Create(edAbrir.Text, fmOpenRead);
  FileStreamOut := TFileStream.Create(edSalvar.Text, fmCreate);

  try
    FileStreamOut.CopyFrom(FileStreamIn, FileStreamIn.Size)
  finally
    FileStreamIn.Free;
    FileStreamOut.Free;
  end;
end;

procedure TfmStreams.btPAbrirClick(Sender: TObject);
begin
  if OpenDialog.Execute then
    (FindComponent('ed' + Copy((Sender as TButton).Name, 4, 10)) as TEdit).Text := OpenDialog.FileName;
end;

procedure TfmStreams.btAbrirClick(Sender: TObject);
var
  StringStream: TStringStream;
  FileStream: TFileStream;
  DecompressionStream: TDecompressionStream;
  ReadBytesCount: Integer;
  Buffer: array [0..1023] of Char;
begin
  StringStream := TStringStream.Create('');
  FileStream := TFileStream.Create(edAbrir.Text, fmOpenRead);
  DecompressionStream := TDecompressionStream.Create(FileStream);

  try
    if cbCompress.Checked then
    begin
      repeat
        ReadBytesCount := DecompressionStream.Read(Buffer, 1024);
        StringStream.Write(Buffer, ReadBytesCount);
      until ReadBytesCount = 0;
    end
    else
      StringStream.CopyFrom(FileStream, FileStream.Size);
    mmFile.Lines.Text := StringStream.DataString;
  finally
    DecompressionStream.Free;
    StringStream.Free;
    FileStream.Free;
  end;
end;

procedure TfmStreams.btSalvarClick(Sender: TObject);
var
  StringStream: TStringStream;
  FileStream: TFileStream;
  CompressionStream: TCompressionStream;
begin
  StringStream := TStringStream.Create(mmFile.Lines.Text);
  FileStream := TFileStream.Create(edSalvar.Text, fmCreate);
  CompressionStream := TCompressionStream.Create(clDefault, FileStream);

  try
    if cbCompress.Checked then
      CompressionStream.CopyFrom(StringStream, StringStream.Size)
    else
      FileStream.CopyFrom(StringStream, StringStream.Size);
  finally
    StringStream.Free;
    //Muito importante:
    CompressionStream.Free;
    FileStream.Free;
  end;
end;

end.
