unit Streams1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TfmStreams1 = class(TForm)
    edAbrir: TEdit;
    btPAbrir: TButton;
    mmFile: TMemo;
    btAbrir: TButton;
    btSalvar: TButton;
    edSalvar: TEdit;
    btPSalvar: TButton;
    OpenDialog: TOpenDialog;
    btAbrirSalvar: TButton;
    procedure btPAbrirClick(Sender: TObject);
    procedure btAbrirClick(Sender: TObject);
    procedure btSalvarClick(Sender: TObject);
    procedure btAbrirSalvarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmStreams1: TfmStreams1;

implementation

{$R *.dfm}

procedure TfmStreams1.btPAbrirClick(Sender: TObject);
begin
  if OpenDialog.Execute then
    (FindComponent('ed' + Copy((Sender as TButton).Name, 4, 10)) as TEdit).Text :=
    OpenDialog.FileName;
end;

procedure TfmStreams1.btAbrirClick(Sender: TObject);
var
  StringStream: TStringStream;
  FileStream: TFileStream;
begin
  StringStream := TStringStream.Create('');
  FileStream := TFileStream.Create(edAbrir.Text, fmOpenRead);

  try
    StringStream.CopyFrom(FileStream, FileStream.Size);
    mmFile.Lines.Text := StringStream.DataString;
  finally
    StringStream.Free;
    FileStream.Free;
  end;
end;

procedure TfmStreams1.btSalvarClick(Sender: TObject);
var
  StringStream: TStringStream;
  FileStream: TFileStream;
begin
  StringStream := TStringStream.Create(mmFile.Lines.Text);
  FileStream := TFileStream.Create(edSalvar.Text, fmCreate);

  try
    FileStream.CopyFrom(StringStream, StringStream.Size);
  finally
    StringStream.Free;
    FileStream.Free;
  end;
end;

procedure TfmStreams1.btAbrirSalvarClick(Sender: TObject);
var
  FileStreamIn: TFileStream;
  FileStreamOut: TFileStream;
begin
  FileStreamIn := TFileStream.Create(edAbrir.Text, fmOpenRead);
  FileStreamOut := TFileStream.Create(edSalvar.Text, fmCreate);

  try
    FileStreamOut.CopyFrom(FileStreamIn, FileStreamIn.Size);
  finally
    FileStreamIn.Free;
    FileStreamOut.Free;
  end;
end;

end.
