unit Strings;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TfmStrings = class(TForm)
    Memo1: TMemo;
    Button1: TButton;
    Button2: TButton;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    Str1: string;
    Str2: string;

    function StringStatus(const Str: string): string;
  public
    { Public declarations }
  end;

var
  fmStrings: TfmStrings;

implementation

{$R *.dfm}

procedure TfmStrings.Button1Click(Sender: TObject);
begin
  Str1 := 'Borland Conference Brasil 2007';
  Str2 := Str1;
  Memo1.Lines.Add('=> Str2 := Str1');
  Memo1.Lines.Add('- Str1' + sLineBreak + StringStatus(Str1));
  Memo1.Lines.Add('- Str2' + sLineBreak + StringStatus(Str2));
end;

procedure TfmStrings.Button2Click(Sender: TObject);
begin
  Str1[2] := 'a';
  Memo1.Lines.Add('=> Str1[2] := ''a''');
  Memo1.Lines.Add('- Str1' + sLineBreak + StringStatus(Str1));
  Memo1.Lines.Add('- Str2' + sLineBreak + StringStatus(Str2));
end;

function TfmStrings.StringStatus(const Str: string): string;
begin
  Result := 'Endereo: ' + IntToStr(Integer(Str)) + sLineBreak +
    //Tamanho equivalente a: IntToStr(Length(Str))
    'Tamanho: ' + IntToStr(PInteger(Integer(Str) - 4)^) + sLineBreak +
    'Referencias: ' + IntToStr(PInteger(Integer(Str) - 8)^) + sLineBreak +
    'Valor: ' + Str;
end;

end.
