SET SQL DIALECT 3;

SET NAMES NONE;

SET CLIENTLIB 'C:\Program Files\Firebird\Firebird_1_5\bin\fbclient.dll';

CREATE DATABASE '127.0.0.1/3050:c:\thread\parte2\parte2.fdb'
USER 'SYSDBA' PASSWORD 'masterkey'
PAGE_SIZE 8192
DEFAULT CHARACTER SET NONE;



/******************************************************************************/
/****                              Generators                              ****/
/******************************************************************************/

CREATE GENERATOR GEN_PROG1;
SET GENERATOR GEN_PROG1 TO 4554;

CREATE GENERATOR GEN_SOMA;
SET GENERATOR GEN_SOMA TO 1460;



SET TERM ^ ; 



/******************************************************************************/
/****                          Stored Procedures                           ****/
/******************************************************************************/

CREATE PROCEDURE ATUALIZA_LENTAMENTE (
    CONTADOR INTEGER)
AS
BEGIN
  EXIT;
END^


CREATE PROCEDURE RELUF (
    CONTADOR INTEGER)
RETURNS (
    UF_CODIGO INTEGER,
    UF_SIGLA VARCHAR(2),
    UF_DESCRICAO VARCHAR(72),
    UF_SOMA NUMERIC(15,2))
AS
BEGIN
  SUSPEND;
END^



SET TERM ; ^


/******************************************************************************/
/****                                Tables                                ****/
/******************************************************************************/



CREATE TABLE UF (
    UF_CODIGO     INTEGER NOT NULL,
    UF_SIGLA      VARCHAR(2) NOT NULL,
    UF_DESCRICAO  VARCHAR(72) NOT NULL,
    UF_SOMA       NUMERIC(15,2) DEFAULT 0
);



/******************************************************************************/
/****                             Primary Keys                             ****/
/******************************************************************************/

ALTER TABLE UF ADD CONSTRAINT PK_UF PRIMARY KEY (UF_CODIGO);


/******************************************************************************/
/****                          Stored Procedures                           ****/
/******************************************************************************/


SET TERM ^ ;

ALTER PROCEDURE ATUALIZA_LENTAMENTE (
    CONTADOR INTEGER)
AS
declare variable Valor Numeric(15,2);
declare variable Codigo integer ;
declare variable I integer;
declare variable Qtdreg Integer;
declare variable Passo Integer;
begin
  -- Contando os registros que sero processados
  select count(*) from uf into :Qtdreg;
  passo = (100 / :Qtdreg) + 1;
  for select uf.Uf_codigo from uf into :Codigo do
     begin
     i = 1;
     -- Incrementando a varivel de progresso
     Select Gen_id(Gen_prog1,:Passo) from rdb$database into :Qtdreg;
     while (:i < :Contador) do I = :i + 1;
     Valor = Gen_id(Gen_soma,1);
     Update uf set uf.Uf_soma = :Valor where uf.Uf_codigo = :Codigo;
  end
  exit;
end
^

ALTER PROCEDURE RELUF (
    CONTADOR INTEGER)
RETURNS (
    UF_CODIGO INTEGER,
    UF_SIGLA VARCHAR(2),
    UF_DESCRICAO VARCHAR(72),
    UF_SOMA NUMERIC(15,2))
AS
declare variable I integer;
begin
   FOR  Select Uf_codigo, Uf_sigla, Uf_descricao, Uf_soma
        From Uf
        Into :Uf_codigo, :Uf_sigla, :Uf_descricao, :Uf_soma
        do begin
           i = 1;
           while (:i < :Contador) do I = :i + 1;
           suspend;
   End
end
^


SET TERM ; ^
