unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, uThExecQuery, Grids, Buttons, DBXpress, DB,
  SqlExpr, FMTBcd, ComCtrls, SdfData, DBGrids;

type
  TForm1 = class(TForm)
    GroupBox1: TGroupBox;
    Panel1: TPanel;
    Label1: TLabel;
    Timer1: TTimer;
    Panel2: TPanel;
    StringGrid1: TStringGrid;
    btnExecutar: TBitBtn;
    btnExibir: TBitBtn;
    Panel3: TPanel;
    Label2: TLabel;
    SQLConnection1: TSQLConnection;
    SQLQuery1: TSQLQuery;
    SQLQuery1UF_CODIGO: TIntegerField;
    SQLQuery1UF_SIGLA: TStringField;
    SQLQuery1UF_DESCRICAO: TStringField;
    SQLQuery1UF_SOMA: TFMTBCDField;
    Label3: TLabel;
    btnFechar: TBitBtn;
    btnDireto: TBitBtn;
    GroupBox2: TGroupBox;
    Edit1: TEdit;
    SQLStoredProc1: TSQLStoredProc;
    ProgressBar1: TProgressBar;
    btnPedir: TBitBtn;
    btnVer: TBitBtn;
    Bevel1: TBevel;
    Timer2: TTimer;
    SQLQuery2: TSQLQuery;
    Label4: TLabel;
    sdfDataSet: TSdfDataSet;
    dtsRelatorio: TDataSource;
    procedure Timer1Timer(Sender: TObject);
    procedure btnExibirClick(Sender: TObject);
    procedure btnExecutarClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnFecharClick(Sender: TObject);
    procedure btnDiretoClick(Sender: TObject);
    procedure Timer2Timer(Sender: TObject);
    procedure btnPedirClick(Sender: TObject);
    procedure btnVerClick(Sender: TObject);
  private
    { Private declarations }
    posini : Integer;
    function pegacontador : integer;
  public
    { Public declarations }
    MeuThread,relThread : ThExecQuery;
  end;

var
  Form1: TForm1;

implementation

uses uRelatorio;

{$R *.dfm}

procedure TForm1.Timer1Timer(Sender: TObject);
begin
   // Apenas para exibir a hora enquanto processa

   Label3.Caption := timetostr(time);

   // Verificando se o thread de processamento foi criado
   if MeuThread = nil then Label1.Caption := 'Thread = nil'
      else
        begin
          // Verificando se o thread ainda est executando
          if MeuThread.Status = thsExecutando then
             begin
                Label1.Caption := 'Executando';
             end;
          // Tentando capturar possvel erro
          if MeuThread.Erro then
             Label2.Caption := MeuThread.MsgErro;
          // Finalizando o thread concludo
          if MeuThread.Status = thsConcluido then
             begin
                Label1.Caption := 'Concludo';
                MeuThread.Free;
                ProgressBar1.Position := 0;
                MeuThread := Nil;
             end;
        End;
    if relThread = nil then Label4.Caption := 'relThread = nil'
      else
        begin
          // Verificando se o thread ainda est executando
          if relThread.Status = thsExecutando then
             begin
                Label4.Caption := 'Esperando liberar os dados do relatrio';
             end;
          // Tentando capturar possvel erro
          if relThread.Erro then
             Label4.Caption := relThread.MsgErro;
          // Finalizando o thread concludo
          if relThread.Status = thsConcluido then
             begin
                Label4.Caption  := 'Relatrio disponvel';
                if sdfDataSet.Active then sdfDataSet.Close;
                sdfDataSet.Data := relThread.Dados;
                btnVer.Enabled  := True;
                relThread.Free;
                relThread := Nil;
             end;
        End;
end;

procedure TForm1.btnExibirClick(Sender: TObject);
Var
   minhaTransacao : TTransactionDesc;
begin
   // Preenche o grid com dados dos estados
   StringGrid1.RowCount := 1;
   StringGrid1.Cells[0,0] := 'Cdigo';
   StringGrid1.Cells[1,0] := 'UF';
   StringGrid1.Cells[2,0] := 'Descrio';
   StringGrid1.Cells[3,0] := 'Soma';
   with SQLQuery1 do
      begin
         minhaTransacao.TransactionID  := 1;
         minhaTransacao.IsolationLevel := xilREPEATABLEREAD;
         SQLConnection.StartTransaction(minhaTransacao);
         SQLConnection.Open;
         Open;
         while not Eof do
            begin
               if StringGrid1.Cells[0,StringGrid1.RowCount -1] <> '' then
                  StringGrid1.RowCount := StringGrid1.RowCount + 1;
               StringGrid1.Cells[0,StringGrid1.RowCount -1] := SQLQuery1UF_CODIGO.AsString;
               StringGrid1.Cells[1,StringGrid1.RowCount -1] := SQLQuery1UF_SIGLA.AsString;
               StringGrid1.Cells[2,StringGrid1.RowCount -1] := SQLQuery1UF_DESCRICAO.AsString;
               StringGrid1.Cells[3,StringGrid1.RowCount -1] := SQLQuery1UF_SOMA.AsString;
               Next;
            end;
         Close;
         SQLConnection.Commit(minhaTransacao);
         SQLConnection.Close;
      End;
      StringGrid1.FixedRows := 1;
end;

procedure TForm1.btnExecutarClick(Sender: TObject);
Var
    comando,parametro : String;
begin
   // Evitando que o thread seja criado enquanto existe
   if MeuThread <> nil then Exit;

   Label2.Caption := '';

   // Lendo a posicao inicial do contador de progresso
   posini                := pegacontador;
   ProgressBar1.Position := 0;
   ProgressBar1.Max      := 100;

   // Definindo a string do comando que ser executado
   comando   := 'Execute Procedure Atualiza_lentamente(:valor)';

   // Definindo os parmetros do Thread
   // Exemplo: I;10;Codigo|F;12.23;Valor
   // Onde cada parametro possui trs campos: Tipo (I=inteiro;F=Float;D=Data;S=String
   //                                         Nome (Nome do parmetro de acordo com sql
   //                                         Valor (Contedo do parmetro
   // Para separar um parmetro de outro use-se '|'
   parametro := 'i;valor;' + Edit1.Text;
   // Executando o Thread
   MeuThread := ThExecQuery.Create('127.0.0.1/3050:C:\thread\parte2\parte2.fdb','SYSDBA',
                'masterkey',comando,parametro,False);
end;

procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   // Tratando a tentativa de fechar o aplicativo antes de concluir o processamento do Thread
   if MeuThread <> nil then
      begin
          Action := caNone;
          Showmessage('Espere o thread terminar para fechar a aplicao.');
      end;
end;

procedure TForm1.btnFecharClick(Sender: TObject);
begin
   Self.Close;
end;

procedure TForm1.btnDiretoClick(Sender: TObject);
Var
   minhaTransacao : TTransactionDesc;
begin
   minhaTransacao.TransactionID  := 2;
   minhaTransacao.IsolationLevel := xilREPEATABLEREAD;
   with SQLStoredProc1 do
      begin
         if SQLConnection.Connected then SQLConnection.Close;
         SQLConnection.StartTransaction(minhaTransacao);
         SQLConnection.Open;
         ParamByName('CONTADOR').AsInteger := strtoint(Edit1.Text);
         try
            ExecProc;
            SQLConnection.Commit(minhaTransacao);
         except
            on e : exception do
               begin
                  SQLConnection.Rollback(minhaTransacao);
                  ShowMessage(e.Message);
               end;
         end;
         ShowMessage('Processamento concludo');
      end;
end;

function TForm1.pegacontador: integer;
Var
   minhaTransacao : TTransactionDesc;
begin
   Result := posini;
   minhaTransacao.TransactionID  := 3;
   minhaTransacao.IsolationLevel := xilREADCOMMITTED;
   with SQLQuery2 do
      begin
         if SQLConnection.Connected then SQLConnection.Close;
         SQLConnection.Open;
         SQLConnection.StartTransaction(minhaTransacao);
         try

            SQL.Text := 'Select Gen_id(Gen_prog1,0) as posicao From rdb$database';
            Open;
            Result := fieldbyname('posicao').AsInteger;
            SQLConnection.Rollback(minhaTransacao);
            SQLConnection.Close
         except
            on e : exception do
               begin
                  SQLConnection.Rollback(minhaTransacao);
                  SQLConnection.Close;
               end;
         end;
      end;
end;

procedure TForm1.Timer2Timer(Sender: TObject);
begin
    if MeuThread <> nil then ProgressBar1.Position := pegacontador - posini;
end;


procedure TForm1.btnPedirClick(Sender: TObject);
Var
    comando,parametro : String;
begin
   // Evitando que o thread seja criado enquanto existe
   if relThread <> nil then Exit;

   Label4.Caption := 'Pedindo relatrio...';

   // Definindo a string do comando que ser executado
   comando   := 'Select Uf_codigo, Uf_sigla, Uf_descricao, Uf_soma '+
                'From Reluf(:valor)';

   // Definindo os parmetros do Thread
   // Exemplo: I;10;Codigo|F;12.23;Valor
   // Onde cada parametro possui trs campos: Tipo (I=inteiro;F=Float;D=Data;S=String
   //                                         Nome (Nome do parmetro de acordo com sql
   //                                         Valor (Contedo do parmetro
   // Para separar um parmetro de outro use-se '|'
   parametro := 'i;valor;' + Edit1.Text;
   // Executando o Thread
   relThread := ThExecQuery.Create('127.0.0.1/3050:C:\thread\parte2\parte2.fdb','SYSDBA',
                'masterkey',comando,parametro,True);
end;

procedure TForm1.btnVerClick(Sender: TObject);
begin
   with TfrmRelatorio.Create(nil) do begin
      try
         // Abre a tabela
         sdfDataSet.Open;
         // Apresenta o relatrio
         frRelatorio.PreviewModal;
      Finally
         // Limpa os objetos
         frRelatorio.Free;
         frmRelatorio.Free;
      End;
   End;
end;

end.
