
unit cadmedico;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls, 
  System.Configuration, FirebirdSql.Data.Firebird, System.Globalization;

type
  TFrmCadMedico = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure btnSalvar_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    txtNome: System.Web.UI.WebControls.TextBox;
    txtCRM: System.Web.UI.WebControls.TextBox;
    dropSexo: System.Web.UI.WebControls.DropDownList;
    dropEspecialidade: System.Web.UI.WebControls.DropDownList;
    btnSalvar: System.Web.UI.WebControls.Button;
    conn: FirebirdSql.Data.Firebird.FbConnection;
    FbDataAdapter1: FirebirdSql.Data.Firebird.FbDataAdapter;
    FbCommand1: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand2: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand3: FirebirdSql.Data.Firebird.FbCommand;
    FbCommand4: FirebirdSql.Data.Firebird.FbCommand;
    cmdEspecialidade: FirebirdSql.Data.Firebird.FbCommand;
    dsMedico: System.Data.DataSet;
    Table: System.Data.DataTable;
    COD_MEDICO: System.Data.DataColumn;
    NOME: System.Data.DataColumn;
    COD_ESPECIALIDADE: System.Data.DataColumn;
    CRM: System.Data.DataColumn;
    SEXO: System.Data.DataColumn;
    RequiredFieldValidator1: System.Web.UI.WebControls.RequiredFieldValidator;
    RequiredFieldValidator2: System.Web.UI.WebControls.RequiredFieldValidator;
    ValidationSummary1: System.Web.UI.WebControls.ValidationSummary;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFrmCadMedico.InitializeComponent;
type
  TArrayOfSystem_Data_DataTable = array of System.Data.DataTable;
  TArrayOfSystem_Data_DataColumn = array of System.Data.DataColumn;
  TArrayOfSystem_Data_Constraint = array of System.Data.Constraint;
  TArrayOfString = array of string;
var
  configurationAppSettings: System.Configuration.AppSettingsReader;
begin
  configurationAppSettings := System.Configuration.AppSettingsReader.Create;
  Self.FbDataAdapter1 := FirebirdSql.Data.Firebird.FbDataAdapter.Create;
  Self.FbCommand4 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.conn := FirebirdSql.Data.Firebird.FbConnection.Create;
  Self.FbCommand2 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand1 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand3 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.cmdEspecialidade := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.dsMedico := System.Data.DataSet.Create;
  Self.Table := System.Data.DataTable.Create;
  Self.COD_MEDICO := System.Data.DataColumn.Create;
  Self.NOME := System.Data.DataColumn.Create;
  Self.COD_ESPECIALIDADE := System.Data.DataColumn.Create;
  Self.CRM := System.Data.DataColumn.Create;
  Self.SEXO := System.Data.DataColumn.Create;
  (System.ComponentModel.ISupportInitialize(Self.dsMedico)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.Table)).BeginInit;
  Include(Self.btnSalvar.Click, Self.btnSalvar_Click);
  // 
  // FbDataAdapter1
  // 
  Self.FbDataAdapter1.DeleteCommand := Self.FbCommand4;
  Self.FbDataAdapter1.InsertCommand := Self.FbCommand2;
  Self.FbDataAdapter1.SelectCommand := Self.FbCommand1;
  Self.FbDataAdapter1.UpdateCommand := Self.FbCommand3;
  // 
  // FbCommand4
  // 
  Self.FbCommand4.CommandText := 'DELETE FROM MEDICO WHERE COD_MEDICO = @p1';
  Self.FbCommand4.Connection := Self.conn;
  Self.FbCommand4.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p1', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'COD_MEDICO', System.Data.DataRowVersion.Original, 
        nil));
  // 
  // conn
  // 
  Self.conn.ConnectionString := (string(configurationAppSettings.GetValue('c' +
    'onn.ConnectionString', TypeOf(string))));
  // 
  // FbCommand2
  // 
  Self.FbCommand2.CommandText := 'INSERT INTO MEDICO (COD_MEDICO,NOME,COD_ES' +
  'PECIALIDADE,CRM,SEXO) VALUES (@p1,@p2,@p3,@p4,@p5)';
  Self.FbCommand2.Connection := Self.conn;
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p1', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, 'COD_MEDICO'));
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p2', FirebirdSql.Data.Firebird.FbDbType.VarChar, 50, 'NOME'));
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p3', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, 'COD_ESPECIALIDAD' +
      'E'));
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p4', FirebirdSql.Data.Firebird.FbDbType.VarChar, 10, 'CRM'));
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p5', FirebirdSql.Data.Firebird.FbDbType.VarChar, 1, 'SEXO'));
  // 
  // FbCommand1
  // 
  Self.FbCommand1.CommandText := 'select * from MEDICO where COD_MEDICO = @C' +
  'OD_MEDICO';
  Self.FbCommand1.Connection := Self.conn;
  Self.FbCommand1.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'COD_MEDICO', FirebirdSql.Data.Firebird.FbDbType.Integer));
  // 
  // FbCommand3
  // 
  Self.FbCommand3.CommandText := 'UPDATE MEDICO SET COD_MEDICO = @p1,NOME = ' +
  '@p2,COD_ESPECIALIDADE = @p3,CRM = @p4,SEXO = @p5 WHERE COD_MEDICO = @p6';
  Self.FbCommand3.Connection := Self.conn;
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p1', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, 'COD_MEDICO'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p2', FirebirdSql.Data.Firebird.FbDbType.VarChar, 50, 'NOME'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p3', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, 'COD_ESPECIALIDAD' +
      'E'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p4', FirebirdSql.Data.Firebird.FbDbType.VarChar, 10, 'CRM'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p5', FirebirdSql.Data.Firebird.FbDbType.VarChar, 1, 'SEXO'));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p6', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'COD_MEDICO', System.Data.DataRowVersion.Original, 
        nil));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p7', FirebirdSql.Data.Firebird.FbDbType.VarChar, 50, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'NOME', System.Data.DataRowVersion.Original, 
        nil));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p8', FirebirdSql.Data.Firebird.FbDbType.Integer, 4, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'COD_ESPECIALIDADE', System.Data.DataRowVersion.Original, 
        nil));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p9', FirebirdSql.Data.Firebird.FbDbType.VarChar, 10, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'CRM', System.Data.DataRowVersion.Original, 
        nil));
  Self.FbCommand3.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'p10', FirebirdSql.Data.Firebird.FbDbType.VarChar, 1, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'SEXO', System.Data.DataRowVersion.Original, 
        nil));
  // 
  // cmdEspecialidade
  // 
  Self.cmdEspecialidade.CommandText := 'SELECT COD_ESPECIALIDADE, DESCRICAO ' +
  'FROM ESPECIALIDADE'#13#10'ORDER BY DESCRICAO';
  Self.cmdEspecialidade.Connection := Self.conn;
  // 
  // dsMedico
  // 
  Self.dsMedico.DataSetName := 'dsMedico';
  Self.dsMedico.Locale := System.Globalization.CultureInfo.Create('pt-BR');
  Self.dsMedico.Namespace := 'http://www.tempuri.org/dsMedico.xsd';
  Self.dsMedico.Tables.AddRange(TArrayOfSystem_Data_DataTable.Create(Self.Table));
  // 
  // Table
  // 
  Self.Table.Columns.AddRange(TArrayOfSystem_Data_DataColumn.Create(Self.COD_MEDICO, 
          Self.NOME, Self.COD_ESPECIALIDADE, Self.CRM, Self.SEXO));
  Self.Table.Constraints.AddRange(TArrayOfSystem_Data_Constraint.Create(System.Data.UniqueConstraint.Create('C' +
          'onstraint1', TArrayOfString.Create('COD_MEDICO'), True)));
  Self.Table.PrimaryKey := TArrayOfSystem_Data_DataColumn.Create(Self.COD_MEDICO);
  Self.Table.TableName := 'Table';
  // 
  // COD_MEDICO
  // 
  Self.COD_MEDICO.AllowDBNull := False;
  Self.COD_MEDICO.ColumnName := 'COD_MEDICO';
  Self.COD_MEDICO.DataType := TypeOf(Integer);
  Self.COD_MEDICO.DefaultValue := System.Object(0);
  // 
  // NOME
  // 
  Self.NOME.AllowDBNull := False;
  Self.NOME.ColumnName := 'NOME';
  Self.NOME.MaxLength := 50;
  // 
  // COD_ESPECIALIDADE
  // 
  Self.COD_ESPECIALIDADE.AllowDBNull := False;
  Self.COD_ESPECIALIDADE.ColumnName := 'COD_ESPECIALIDADE';
  Self.COD_ESPECIALIDADE.DataType := TypeOf(Integer);
  // 
  // CRM
  // 
  Self.CRM.AllowDBNull := False;
  Self.CRM.ColumnName := 'CRM';
  Self.CRM.MaxLength := 10;
  // 
  // SEXO
  // 
  Self.SEXO.AllowDBNull := False;
  Self.SEXO.ColumnName := 'SEXO';
  Self.SEXO.MaxLength := 1;
  Include(Self.Load, Self.Page_Load);
  (System.ComponentModel.ISupportInitialize(Self.dsMedico)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.Table)).EndInit;
end;
{$ENDREGION}

procedure TFrmCadMedico.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  if not IsPostBack then //Explicado nas outras partes do artigo
  begin
     //Abre a conexo.
     conn.open;
     try
       {A funo ExecuteReader do componente FbCommand cmbEspecialidade
       executa o comando SQL existente na propriedade CommandText
       e retorna um objeto FbDataReader, contendo os dados
       retornados pela consulta SQL. Este objeto retornado
        vinculado  propriedade DataSource do dropEspecialidade
       para que sejam exibidas as especialidades neste componente.}
       dropEspecialidade.DataSource :=
            cmdEspecialidade.ExecuteReader;
       {A execuo do mtodo DataBind faz com que os dados
       do objeto FbDataReader, associado ao dropEspecialidade,
       sejam exibidos como itens neste componente.}
       dropEspecialidade.DataBind;
       {Verifica se a foi passado um parmetro  pgina de nome
       cod. Se foi, deve-se carregar o registro do mdico com
       o cdigo informado no parmetro.}
       if Request['cod'] <> nil then
       begin
         {Pega o parmetro recebido na pgina e passa-o
         para o parmetro da instruo SQL que busca
         o registro do mdico.}
         FbDataAdapter1.SelectCommand.Parameters[0].Value := Request['cod'];
         {O mtodo Fill do FbDataAdapter executa a instruo SQL
         da propriedade SelectCommand e armazena os dados
         retornados dentro do DataSet dsMedico, em memria. }
         FbDataAdapter1.Fill(dsMedico);
         {Guarda o DataSet com os dados do mdico na sesso do usurio, pois,
         como o ASP.NET no guarda o estado da pgina, se
         o DataSet no for armazenado na sesso, os dados
         sero perdidos da memria ao final do carregamento da pgina.
         O DataSet com os dados  necessrio para realizar
         a alterao do registro quando o usurio clicar no boto Salvar.
         Note que foi utilizado o nome dsCadMedico para a varivel de sesso que
         armazenar o DataSet. Se fosse utilizado o nome dsMedico estaramos
         substituindo o DataSet na sesso que  utilizado na pgina medicos.aspx,
         esta responsvel por listar os mdicos cadastrados.}
         Session['dsCadMedico']:= dsMedico;
         {Como um DataSet pode conter vrias tabelas em memria,
         e o dsMedico contm apenas a tabela MEDICO, acessamos
         esta tabela pela posio zero da propriedade Tables do DataSet.
         Como a instruo SQL armazenada na propriedade SelectCommando
         do FbDataAdapter retorna apenas uma linha (um registro), pegamos
         a linha da posio zero e depois acessamos o campo NOME desta linha
         e armazenamos seu valor no TextBox txtNome.}
         txtNome.Text:= dsMedico.Tables[0].Rows[0].Item['NOME'].ToString;
         {As linhas abaixo seguem a mesma lgica do cdigo da linha acima.}
         txtCRM.Text:= dsMedico.Tables[0].Rows[0].Item['CRM'].ToString;
         dropSexo.SelectedValue:=
           dsMedico.Tables[0].Rows[0].Item['SEXO'].ToString;
         dropEspecialidade.SelectedValue:=
           dsMedico.Tables[0].Rows[0].Item['COD_ESPECIALIDADE'].ToString;
       end;
     finally
       conn.close;
     end;
  end;
end;

procedure TFrmCadMedico.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TFrmCadMedico.btnSalvar_Click(sender: System.Object; e: System.EventArgs);
var
  {Varivel que representa um registro de uma tabela,
  utilizada para alterar os dados do registro, quando
  o usurio estiver editando um registro existente.}
  row: DataRow;
begin
  {Verifica se no foi passado um parmetro de nome cod  pgina.
  Isto indica que a mesma foi aberta para incluir um novo registro,
  logo, utiliza-se o mtodo NewRow do DataTable (que representa
  a tabela do banco de dadso) contido no DataSet para criar
  uma nova linha na tabela.}
  if Request['cod'] = nil then
     row:= dsMedico.Tables[0].NewRow
  else
  begin
    {Se foi passado o parmetro cod  pgina, isto indica
    que a mesma foi aberta para alterao de um registro.
    Logo, no evento Load da pgina o registro  carregado
    no DataSet dsMedico e depois este  armazenado na seo.}
    dsMedico:= DataSet(Session['dsCadMedico']);

    {Como no DataSet dsMedico sempre haver no mximo
    um registro (o que foi explicado no cdigo do evento Load da pgina),
    para peg-lo acessamos a linha zero da tabela.}
    row:= dsMedico.Tables[0].Rows[0];
  end;

  {Atribui os valores dos campos da pgina  linha da tabela.
  Se a varivel row representar uma linha existente, os dados
  da linha sero alterados. O if...else acima define se row
  ser uma nova linha ou uma linha j existente na tabela. }
  row['NOME']:= txtNome.Text;
  row['CRM']:= txtCRM.Text;
  row['SEXO']:= dropSexo.SelectedValue.ToString;
  row['COD_ESPECIALIDADE']:= dropEspecialidade.SelectedValue.ToString;

  {Se no foi passado o parmetro cod  pgina, a mesma foi aberta
  para incluso de um novo registro, assim, utiliza-se o mtodo
  Add da propriedade Rows da tabela no DataSet para adicionar a nova
  linha na tabela em memria.}
  if Request['cod'] = nil then
     dsMedico.Tables[0].Rows.Add(row);

  try
    try
       {Chama o mtodo Update do FbDataAdapter, passando o DataSet
       dsMedico por parmetro (que teve uma linha
       includa ou alterada) para que seja feita a atualizao no banco de dados.
       Este j se encarrega de abrir a conexo com o banco.}
       FbDataAdapter1.Update(dsMedico);
    except
       on e: Exception do
       begin
         {Se existe a string unique index "medico_crm" dentro da mensagem
         de erro, ento o CRM informado j existe. A funo IndexOf
         retorna a posio da string procurada dentro da string
         original. Se retornar -1  porque no encontrou.}
         if e.Message.ToLower.IndexOf('unique index "medico_crm"') <> -1 then
            {Registra um bloco de cdigo JavaScript
            para mostrar uma mensagem amigvel para o usurio}
            RegisterStartupScript('valida_crm',
              '<script language="javascript">alert("CRM informado j existe.");</script>')
         else raise; //Dispara o erro que no foi tratado, mostrando a mensagem original.
         {Sai para no executar o cdigo aps o finally, que causaria
         o redirecionamento da pgina.}
         exit;
       end;
    end;
  finally
    conn.close;
  end;

  {Redireciona para a pgina de listagem de mdicos.}
  Response.Redirect('medicos.aspx');
end;

end.

