unit medicos;

interface

uses
  System.Text,
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls, 
  FirebirdSql.Data.Firebird, System.Configuration, System.Globalization, 
  System.Data.Common;

type
  TFrmMedico = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure DataGrid1_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
    procedure dropEspecialidade_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure DataGrid1_SortCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridSortCommandEventArgs);
    procedure DataGrid1_ItemCreated(sender: System.Object; e: System.Web.UI.WebControls.DataGridItemEventArgs);
    procedure DataGrid1_PageIndexChanged(source: System.Object; e: System.Web.UI.WebControls.DataGridPageChangedEventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    DataGrid1: System.Web.UI.WebControls.DataGrid;
    Button1: System.Web.UI.WebControls.Button;
    conn: FirebirdSql.Data.Firebird.FbConnection;
    FbDataAdapter1: FirebirdSql.Data.Firebird.FbDataAdapter;
    FbCommand1: FirebirdSql.Data.Firebird.FbCommand;
    cmdEspecialidade: FirebirdSql.Data.Firebird.FbCommand;
    txtNome: System.Web.UI.WebControls.TextBox;
    dropEspecialidade: System.Web.UI.WebControls.DropDownList;
    Button2: System.Web.UI.WebControls.Button;
    dsMedico: System.Data.DataSet;
    Table: System.Data.DataTable;
    COD_MEDICO: System.Data.DataColumn;
    NOME: System.Data.DataColumn;
    ESPECIALIDADE: System.Data.DataColumn;
    COD_ESPECIALIDADE: System.Data.DataColumn;
    FbCommand2: FirebirdSql.Data.Firebird.FbCommand;
    procedure OnInit(e: EventArgs); override;
  private
    procedure FiltrarDataGrid;
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TFrmMedico.InitializeComponent;
type
  TArrayOfSystem_Data_Common_DataTableMapping = array of System.Data.Common.DataTableMapping;
  TArrayOfSystem_Data_Common_DataColumnMapping = array of System.Data.Common.DataColumnMapping;
  TArrayOfSystem_Data_DataTable = array of System.Data.DataTable;
  TArrayOfSystem_Data_DataColumn = array of System.Data.DataColumn;
  TArrayOfSystem_Data_Constraint = array of System.Data.Constraint;
  TArrayOfString = array of string;
var
  configurationAppSettings: System.Configuration.AppSettingsReader;
begin
  configurationAppSettings := System.Configuration.AppSettingsReader.Create;
  Self.conn := FirebirdSql.Data.Firebird.FbConnection.Create;
  Self.FbDataAdapter1 := FirebirdSql.Data.Firebird.FbDataAdapter.Create;
  Self.FbCommand2 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.FbCommand1 := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.cmdEspecialidade := FirebirdSql.Data.Firebird.FbCommand.Create;
  Self.dsMedico := System.Data.DataSet.Create;
  Self.Table := System.Data.DataTable.Create;
  Self.COD_MEDICO := System.Data.DataColumn.Create;
  Self.NOME := System.Data.DataColumn.Create;
  Self.ESPECIALIDADE := System.Data.DataColumn.Create;
  Self.COD_ESPECIALIDADE := System.Data.DataColumn.Create;
  (System.ComponentModel.ISupportInitialize(Self.dsMedico)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.Table)).BeginInit;
  Include(Self.dropEspecialidade.SelectedIndexChanged, Self.dropEspecialidade_SelectedIndexChanged);
  Include(Self.Button2.Click, Self.Button2_Click);
  Include(Self.DataGrid1.ItemCreated, Self.DataGrid1_ItemCreated);
  Include(Self.DataGrid1.PageIndexChanged, Self.DataGrid1_PageIndexChanged);
  Include(Self.DataGrid1.SortCommand, Self.DataGrid1_SortCommand);
  Include(Self.DataGrid1.DeleteCommand, Self.DataGrid1_DeleteCommand);
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // conn
  // 
  Self.conn.ConnectionString := (string(configurationAppSettings.GetValue('c' +
    'onn.ConnectionString', TypeOf(string))));
  // 
  // FbDataAdapter1
  // 
  Self.FbDataAdapter1.DeleteCommand := Self.FbCommand2;
  Self.FbDataAdapter1.SelectCommand := Self.FbCommand1;
  Self.FbDataAdapter1.TableMappings.AddRange(TArrayOfSystem_Data_Common_DataTableMapping.Create(System.Data.Common.DataTableMapping.Create('T' +
          'able', 'Table', TArrayOfSystem_Data_Common_DataColumnMapping.Create(System.Data.Common.DataColumnMapping.Create('C' +
                'OD_MEDICO', 'COD_MEDICO'), System.Data.Common.DataColumnMapping.Create('N' +
                'OME', 'NOME'), System.Data.Common.DataColumnMapping.Create('E' +
                'SPECIALIDADE', 'ESPECIALIDADE'), System.Data.Common.DataColumnMapping.Create('C' +
                'OD_ESPECIALIDADE', 'COD_ESPECIALIDADE')))));
  // 
  // FbCommand2
  // 
  Self.FbCommand2.CommandText := 'delete from MEDICO where COD_MEDICO = @COD' +
  '_MEDICO';
  Self.FbCommand2.Connection := Self.conn;
  Self.FbCommand2.Parameters.Add(FirebirdSql.Data.Firebird.FbParameter.Create('@' +
      'COD_MEDICO', FirebirdSql.Data.Firebird.FbDbType.Integer, 0, System.Data.ParameterDirection.Input, 
        False, (Byte(0)), (Byte(0)), 'COD_MEDICO', System.Data.DataRowVersion.Current, 
        nil));
  // 
  // FbCommand1
  // 
  Self.FbCommand1.CommandText := 'select M.COD_MEDICO, M.NOME,  E.DESCRICAO ' +
  'AS ESPECIALIDADE,'#13#10'M.COD_ESPECIALIDADE'#13#10'from MEDICO M'#13#10'I' +
  'NNER JOIN ESPECIALIDADE E ON E.COD_ESPECIALIDADE = M.COD_ESPECIALIDADE'#13 +
  #10'order by M.NOME';
  Self.FbCommand1.Connection := Self.conn;
  // 
  // cmdEspecialidade
  // 
  Self.cmdEspecialidade.CommandText := 'select COD_ESPECIALIDADE, DESCRICAO ' +
  'FROM ESPECIALIDADE ORDER BY DESCRICAO';
  Self.cmdEspecialidade.Connection := Self.conn;
  // 
  // dsMedico
  // 
  Self.dsMedico.DataSetName := 'dsMedico';
  Self.dsMedico.Locale := System.Globalization.CultureInfo.Create('pt-BR');
  Self.dsMedico.Namespace := 'http://www.tempuri.org/dsMedico.xsd';
  Self.dsMedico.Tables.AddRange(TArrayOfSystem_Data_DataTable.Create(Self.Table));
  // 
  // Table
  // 
  Self.Table.Columns.AddRange(TArrayOfSystem_Data_DataColumn.Create(Self.COD_MEDICO, 
          Self.NOME, Self.ESPECIALIDADE, Self.COD_ESPECIALIDADE));
  Self.Table.Constraints.AddRange(TArrayOfSystem_Data_Constraint.Create(System.Data.UniqueConstraint.Create('C' +
          'onstraint1', TArrayOfString.Create('COD_MEDICO'), True)));
  Self.Table.PrimaryKey := TArrayOfSystem_Data_DataColumn.Create(Self.COD_MEDICO);
  Self.Table.TableName := 'Table';
  // 
  // COD_MEDICO
  // 
  Self.COD_MEDICO.AllowDBNull := False;
  Self.COD_MEDICO.ColumnName := 'COD_MEDICO';
  Self.COD_MEDICO.DataType := TypeOf(Integer);
  // 
  // NOME
  // 
  Self.NOME.AllowDBNull := False;
  Self.NOME.ColumnName := 'NOME';
  Self.NOME.MaxLength := 50;
  // 
  // ESPECIALIDADE
  // 
  Self.ESPECIALIDADE.AllowDBNull := False;
  Self.ESPECIALIDADE.ColumnName := 'ESPECIALIDADE';
  Self.ESPECIALIDADE.MaxLength := 50;
  // 
  // COD_ESPECIALIDADE
  // 
  Self.COD_ESPECIALIDADE.AllowDBNull := False;
  Self.COD_ESPECIALIDADE.ColumnName := 'COD_ESPECIALIDADE';
  Self.COD_ESPECIALIDADE.DataType := TypeOf(Integer);
  Include(Self.Load, Self.Page_Load);
  (System.ComponentModel.ISupportInitialize(Self.dsMedico)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.Table)).EndInit;
end;
{$ENDREGION}

procedure TFrmMedico.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  {Verifica se a pgina est sendo aberta em uma nova requisio
  ou se apenas est sendo recarregada devido ao disparo de algum
  componente na mesma, como o clique em um boto. Se o endereo da pgina
  for redigitado  criada uma nova requisio e no um post back.
  O postback ocorre depois dos disparos de eventos.}
  if not IsPostBack then
  begin
    {abre a conexo com o banco
    se o Pool estiver habilitado, como explicado no artigo,
    pega uma conexo j estabelecida do pool}
    conn.open;
    try
      {o mtodo Fill do FbDataAdapter preenche um DataSet ou DataTable
      com os dados da tabela para o qual o primeiro foi configurado.
      Os componentes DataSet e DataTable trabalham desconectados do banco,
      como o ClientDataSet.}
      FbDataAdapter1.Fill(dsMedico);
      {Guarda o DataSet com os dados na sesso do usurio
      para permitir manipular estes dados posteriormente, como
      no processo de ordenao ou paginao, sem precisar fazer acesso
      novamente ao banco de dados para pegar os dados novamente, pois,
      como o ASP.NET  Stateless, ou seja, no guarda os dados
      da pgina a cada requisio, os dados so perdidos se no guardados
      em sesso (um conceito fundamental associado ao desenvolvimento
      de sistemas web em qualquer linguagem).}
      Session['dsMedico']:= dsMedico;
      //Vincula os dados do DataSet ao DataGrid
      DataGrid1.DataBind;

      {O mtodo ExecuteReader executa o comando SQL associado
      ao FbCommand e retorna um FbDataReader, um cursor unidirecional com os dados
      da consulta. Este FbDataReader  associado  propriedade DataSource do
      DropDownList para que este exiba as especialidades.}
      dropEspecialidade.DataSource := cmdEspecialidade.ExecuteReader;
      {Faz com que os dados retornados pelo FbCommand, por meio
      do mtodo ExecuteReader, sejam mostrados no DropDownList}
      dropEspecialidade.DataBind;
      {Insere um item 'Todas' no componente, com valor zero associado a ele,
      para permitir ao usurio exibir os mdicos de todas as especialidades.}
      dropEspecialidade.Items.Insert(0, ListItem.Create('Todas', '0'));
      //Seleciona o primeiro item do DropDownList
      dropEspecialidade.SelectedIndex:= 0;
    finally
      {fecha a conexo ao banco. Se o pool estiver
      habilitado apenas devolve a conexo ao pool, no fecha
      ela como ocorre em aplicaes desktop.}
      conn.close;
    end;
  end;
end;

procedure TFrmMedico.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TFrmMedico.FiltrarDataGrid;
var
  sb: StringBuilder; //adicione o Namespace System.Text
begin
  {Adiciona uma condio que no vai influenciar
  na filtragem dos dados pois sempre retorna True.
  Isto  um macete utilizado quando vamos inserir
  condies em uma instruo SQL ou em um filtro
  que dependem do resultado de instrues If, podendo
  a SQL ou Filtro final conter uma ou vrias condies, sendo
  que cada vez que formos incluir uma nova condio na SQL ou Filtro,
  precisariamos verificar se j foi includa uma condio anteriormente,
  pois se foi, deve-se incluir um operador AND antes de adicionar
  a nova condio. Usando o macete de criar uma condio que sempre
  retorna True, a SQL ou Filtro j iniciar com uma condio sempre
  e no precisaremos ficar checando se j foi includa uma condio
  para poder colocar um AND antes, o AND sempre dever ser colocado.
  E o filtro 1=1 no intefere no resultado, apenas diminui
  as linhas de programao.}
  sb:= StringBuilder.Create(' 1=1 ');

  //pega o dsMedico que est na sesso, guardando os dados dos mdicos retornados do banco.
  dsMedico := DataSet(Session['dsMedico']);
  {Se o usurio digitou um nome no campo (se ele digitou apenas
  espaos a funo Trim retorna uma cpia da String sem estes espaos),
  filtra pelo nome.}
  if txtNome.Text.Trim <> '' then
    sb.AppendFormat(
      ' and NOME like ''{0}*'' ', [txtNome.Text]);
  {Se o usurio escolheu uma opo no DropDownList
  diferente da primeira (Todas), filtra pela especialidade}
  if dropEspecialidade.SelectedIndex > 0 then
      sb.AppendFormat(
       ' and COD_ESPECIALIDADE = {0} ', [dropEspecialidade.SelectedValue]);
  {Atribui o filtro criado a propriedade RowFilter do objeto DefaultView}
  dsMedico.Tables[0].DefaultView.RowFilter := sb.ToString;
  {Vincula apenas o objeto DefaultView (um objeto da classe DataView), contendo
  os dados filtrados, ao DataGrid}
  DataGrid1.DataSource := dsMedico.Tables[0].DefaultView;
  {Exibe os dados filtrados no DataGrid.}
  DataGrid1.DataBind;
end;

procedure TFrmMedico.DataGrid1_PageIndexChanged(source: System.Object;
  e: System.Web.UI.WebControls.DataGridPageChangedEventArgs);
begin
  {Pega o DataSet na sesso}
  dsMedico:= DataSet(Session['dsMedico']);
  {Muda a pgina atual do DataGrid para a pgina }
  DataGrid1.CurrentPageIndex:= e.NewPageIndex;
  //Vincula o DataSet no DataGrid
  DataGrid1.DataSource := dsMedico;
  {Carrega os dados do DataSet no DataGrid}
  DataGrid1.DataBind;
end;

procedure TFrmMedico.DataGrid1_ItemCreated(sender: System.Object; e: System.Web.UI.WebControls.DataGridItemEventArgs);
var
  LinkBtn: LinkButton;
begin
  {Procura por um componente de nome LinkBtnDelete}
  LinkBtn:=  LinkButton(e.Item.FindControl('LinkBtnDelete'));
  {Se LinkBtn for diferente de nil,  porque o componente
  foi encontrado na linha sendo criada no DataGrid}
  if LinkBtn <> nil then
     {A propriedade Attributes do componente permite adicionar
     cdigo JavaScript aos eventos HTML do componente gerado na pgina.
     Com o cdigo abaixo  adicionado uma confirmao no evento HTML OnClick
     do componente}
     LinkBtn.Attributes.Add(
       'onclick',
       'return confirm("Tem certeza que deseja excluir o registro?");');
end;

procedure TFrmMedico.DataGrid1_SortCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridSortCommandEventArgs);
begin
  {Pega o DataSet que foi armazenado na seo. Se isto no
  for feito, como o ASP.NET no guarda o estado
  dos objetos, e o dsMedico s tem os dados
  carregados na primeira requisio da pgina,
  pegaremos um DataSet vazio, como ele est em tempo
  de design. Assim, ele  guardado na seo
  depois de ter os dados carregados do banco de dados,
  no precisando a cada acesso  pgina, refazer
  o acesso ao banco. Desta forma o desempenho
  da aplicao aumenta bastante.}
  dsMedico:= DataSet(Session['dsMedico']);
  {O parmetro e  um objeto que
  possui uma propriedade SortExpression, indicando
  o comando de ordenao associado  coluna clicada pelo usurio.
  Os dados de um DataSet so armazenados nos seus DataTables (acessados
  por meio da propriedade Tables). Neste caso, o dsMedico possui apenas um DataTable.
  Este componente  que permite realizar ordenao dos dados
  em memria, no necessitando refazer a consulta SQL para trazer os dados
  ordenados. Para realizar ordenao ou filtragem em um DataTable,
  devemos utilizar sua propriedade DefaultView. Esta propriedade  um objeto da classe
  DataView, que possui uma propriedade Sort para receber a expresso de ordenao.
  A expresso possui a mesma sintaxe da clusula ORDER BY da SQL, porm sem incluir
  o ORDER BY, permitindo incluir as palavras reservadas ASC ou DESC para cada
  campo para indicar se a ordenao do campo ser em ordem crescente ou descrescente.
  Para realizar a ordenao apenas pegamos a propriedade SortExpression do
  parmetro e, depois a atribuimos  propriedade Sort de DefaultView no
  DataTable contido no dsMedico.}
  dsMedico.Tables[0].DefaultView.Sort := e.SortExpression;
  {Para que o DataGrid apresente os dados de forma ordenada,
  precisamos vincul-lo agora ao DataView do DataTable contido no dsMedico,
  pois o DataView  que contm os dados ordenados.}
  DataGrid1.DataSource := dsMedico.Tables[0].DefaultView;
  {Fazemos um DataBind para que os dados sejam exibidos no DataGrid}
  DataGrid1.DataBind;
end;

procedure TFrmMedico.dropEspecialidade_SelectedIndexChanged(sender: System.Object;
  e: System.EventArgs);
begin
  FiltrarDataGrid;
end;

procedure TFrmMedico.Button2_Click(sender: System.Object; e: System.EventArgs);
begin
  FiltrarDataGrid;
end;

procedure TFrmMedico.DataGrid1_DeleteCommand(source: System.Object;
  e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  i: Integer;
begin
  try
    {Pega o DataSet que est armazenado na seo, contendo
    os dados carregados no banco de dados.}
    dsMedico:= DataSet(Session['dsMedico']);
    {Pega o ndice do registro, cuja excluso foi solicitada
    pelo usurio, no DataSet, ou seja, a posio do registro
    a ser excludo no DataSet.}
    i:= e.Item.DataSetIndex;
    {Deleta o registro do DataTable contido no DataSet,
    pois  o DataTable que armazena os dados em memria.}
    dsMedico.Tables[0].Rows[i].Delete;
    {Chama o mtodo Update do FbDataAdapter que executar o(s) comando(s)
    sql necessrio(s) para executar a(s) atualio(es) no banco de dados.
    Como fizemos uma excluso apenas, o FbDataAdapter passar o cdigo do
    registro excludo para o DeleteCommand dele e executar a instruo
    contida nele.}
    FbDataAdapter1.Update(dsMedico);
    //Vincula novamente o dsMedico, agora com um registro excludo, ao DataGrid
    DataGrid1.DataSource := dsMedico;
    //Armazena o dsMedico novamente na seo
    Session['dsMedico']:= dsMedico;
    //Atualiza os dados no DataGrid
    DataGrid1.DataBind;
  finally
    conn.Close;
  end;
end;

procedure TFrmMedico.Button1_Click(sender: System.Object; e: System.EventArgs);
begin
  Response.Redirect('cadmedico.aspx');
end;

end.

