unit UDBXConfig;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDefault, FMTBcd, StdCtrls, Buttons, Grids, DBGrids, DB, DBClient,
  Provider, SqlExpr, DBXCommon, SwSystem;

type
  TFrmDBXConfig = class(TFrmDefault)
    SqlProducts: TSQLDataSet;
    DspProducts: TDataSetProvider;
    CdsProducts: TClientDataSet;
    CdsProductsID_PRODUTO: TFloatField;
    CdsProductsDESCRICAO: TStringField;
    CdsProductsPRECOCOMPRA: TFloatField;
    CdsProductsQUANTIDADE: TFloatField;
    DsProducts: TDataSource;
    DBGrid1: TDBGrid;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    Edit1: TEdit;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Memo1: TMemo;
    SQLMonitor1: TSQLMonitor;
    SqlProductsID_PRODUTO: TFloatField;
    SqlProductsDESCRICAO: TStringField;
    SqlProductsPRECOCOMPRA: TFloatField;
    SqlProductsQUANTIDADE: TFloatField;
    BitBtn3: TBitBtn;
    ComboBox1: TComboBox;
    BitBtn4: TBitBtn;
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure SQLMonitor1LogTrace(Sender: TObject; TraceInfo: TDBXTraceInfo);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmDBXConfig: TFrmDBXConfig;

implementation

uses UDM_DBX;

{$R *.dfm}

procedure TFrmDBXConfig.BitBtn1Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Close;
  CdsProducts.Params[0].AsString := Edit1.Text + '%';
  CdsProducts.Open;
end;

procedure TFrmDBXConfig.BitBtn2Click(Sender: TObject);
begin
  inherited;
  CdsProducts.ApplyUpdates(0);
end;

procedure TFrmDBXConfig.BitBtn3Click(Sender: TObject);
begin
  inherited;
  case ComboBox1.ItemIndex of
    0 : DspProducts.UpdateMode := upWhereAll;
    1 : DspProducts.UpdateMode := upWhereChanged;
    2 : DspProducts.UpdateMode := upWhereKeyOnly;
  end;
end;

procedure TFrmDBXConfig.BitBtn4Click(Sender: TObject);
begin
  inherited;
  if BitBtn4.Caption = 'Active Monitor' then
  begin
    SQLMonitor1.Active := True;
    BitBtn4.Caption    := 'Desactive Monitor';
  end
  else
  begin
    SQLMonitor1.Active := False;
    BitBtn4.Caption    := 'Active Monitor';
  end;
end;

procedure TFrmDBXConfig.SpeedButton1Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Prior;
end;

procedure TFrmDBXConfig.SpeedButton2Click(Sender: TObject);
begin
  inherited;
  CdsProducts.First;
end;

procedure TFrmDBXConfig.SpeedButton3Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Last;
end;

procedure TFrmDBXConfig.SpeedButton4Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Next;
end;

procedure TFrmDBXConfig.SpeedButton5Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Insert;
end;

procedure TFrmDBXConfig.SpeedButton6Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Edit;
end;

procedure TFrmDBXConfig.SpeedButton7Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Delete;
end;

procedure TFrmDBXConfig.SpeedButton8Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Cancel;
end;

procedure TFrmDBXConfig.SQLMonitor1LogTrace(Sender: TObject;
  TraceInfo: TDBXTraceInfo);
begin
  inherited;
  Memo1.Text := SQLMonitor1.TraceList.Text;
end;

end.
