unit ULocalPersitingData;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDefault, FMTBcd, DB, DBClient, Provider, SqlExpr, Grids, DBGrids,
  StdCtrls, Buttons, ExtCtrls, DBCtrls, SwSystem;

type
  TFrmLocalPersitingData = class(TFrmDefault)
    SqlProducts: TSQLDataSet;
    DspProducts: TDataSetProvider;
    CdsProducts: TClientDataSet;
    DsProducts: TDataSource;
    DBGrid1: TDBGrid;
    CdsProductsID_PRODUTO: TFloatField;
    CdsProductsDESCRICAO: TStringField;
    CdsProductsPRECOCOMPRA: TFloatField;
    CdsProductsQUANTIDADE: TFloatField;
    BitBtn1: TBitBtn;
    Edit1: TEdit;
    BitBtn2: TBitBtn;
    CheckBox1: TCheckBox;
    Label1: TLabel;
    BitBtn3: TBitBtn;
    ComboBox1: TComboBox;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure CdsProductsReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmLocalPersitingData: TFrmLocalPersitingData;

implementation

uses UDM_DBX, RecError;

{$R *.dfm}

procedure TFrmLocalPersitingData.BitBtn1Click(Sender: TObject);
begin
  inherited;
  if CheckBox1.Checked then
  begin
    CdsProducts.Close;
    CdsProducts.Params[0].AsString := Edit1.Text + '%';
    CdsProducts.Open;
  end;
end;

procedure TFrmLocalPersitingData.BitBtn2Click(Sender: TObject);
begin
  inherited;
  if CheckBox1.Checked then
    CdsProducts.ApplyUpdates(0);
end;

procedure TFrmLocalPersitingData.BitBtn3Click(Sender: TObject);
var
  DTPF : TDataPacketFormat;
begin
  inherited;
  case ComboBox1.ItemIndex of
    0 : DTPF := dfBinary;
    1 : DTPF := dfXML;
    2 : DTPF := dfXMLUTF8;
  end;
  CdsProducts.SaveToFile(gsAppPath + 'CdsProducts.Data', DTPF);
end;

procedure TFrmLocalPersitingData.BitBtn4Click(Sender: TObject);
begin
  inherited;
  CdsProducts.LoadFromFile(gsAppPath + 'CdsProducts.Data');
end;

procedure TFrmLocalPersitingData.BitBtn5Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Close;
end;

procedure TFrmLocalPersitingData.CdsProductsReconcileError(
  DataSet: TCustomClientDataSet; E: EReconcileError; UpdateKind: TUpdateKind;
  var Action: TReconcileAction);
begin
  inherited;
  Action := HandleReconcileError(DataSet, UpdateKind, E);
end;

procedure TFrmLocalPersitingData.SpeedButton1Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Prior;
end;

procedure TFrmLocalPersitingData.SpeedButton2Click(Sender: TObject);
begin
  inherited;
  CdsProducts.First;
end;

procedure TFrmLocalPersitingData.SpeedButton3Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Last;
end;

procedure TFrmLocalPersitingData.SpeedButton4Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Next;
end;

procedure TFrmLocalPersitingData.SpeedButton5Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Insert;
end;

procedure TFrmLocalPersitingData.SpeedButton6Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Edit;
end;

procedure TFrmLocalPersitingData.SpeedButton7Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Delete;
end;

procedure TFrmLocalPersitingData.SpeedButton8Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Cancel;
end;

end.
