unit UMainMenu;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons;

type
  TFrmMainMenu = class(TForm)
    btLocalData: TBitBtn;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    BitBtn3: TBitBtn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btLocalDataMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure btLocalDataMouseLeave(Sender: TObject);
    procedure btLocalDataClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure BitBtn3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmMainMenu: TFrmMainMenu;

implementation

uses UDM_DBX, ULocalPersitingData, UDBXConfig, UMemoryIndexOrdering,
  UAggregatesInternalCalcMDReport;

{$R *.dfm}

procedure TFrmMainMenu.BitBtn1Click(Sender: TObject);
begin
  try
    Application.CreateForm(TFrmDBXConfig, FrmDBXConfig);
    FrmDBXConfig.ShowModal;
  finally
    FrmDBXConfig.Release;
  end;
end;

procedure TFrmMainMenu.BitBtn2Click(Sender: TObject);
begin
  try
    Application.CreateForm(TFrmMemoryIndexOrdering, FrmMemoryIndexOrdering);
    FrmMemoryIndexOrdering.ShowModal;
  finally
    FrmMemoryIndexOrdering.Release;
  end;
end;

procedure TFrmMainMenu.BitBtn3Click(Sender: TObject);
begin
  try
    Application.CreateForm(TFrmAggregatesInternalCalcMDReport, FrmAggregatesInternalCalcMDReport);
    FrmAggregatesInternalCalcMDReport.ShowModal;
  finally
    FrmAggregatesInternalCalcMDReport.Release;
  end;
end;

procedure TFrmMainMenu.btLocalDataClick(Sender: TObject);
begin
  try
    Application.CreateForm(TFrmLocalPersitingData, FrmLocalPersitingData);
    FrmLocalPersitingData.ShowModal;
  finally
    FrmLocalPersitingData.Release;
  end;
end;

procedure TFrmMainMenu.btLocalDataMouseLeave(Sender: TObject);
begin
(Sender as TBitBtn).Font.Color := clBlack;
end;

procedure TFrmMainMenu.btLocalDataMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
begin
  (Sender as TBitBtn).Font.Color := clRed;
end;

procedure TFrmMainMenu.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  DM_DBX.SQLConnection.Close;
  DM_DBX.Free;
end;

end.
