unit UMemoryIndexOrdering;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UDefault, FMTBcd, SqlExpr, DB, DBClient, Provider, Grids, DBGrids,
  StdCtrls, Buttons;

type
  TFrmMemoryIndexOrdering = class(TFrmDefault)
    Edit1: TEdit;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    DBGrid1: TDBGrid;
    SqlProducts: TSQLDataSet;
    SqlProductsID_PRODUTO: TFloatField;
    SqlProductsDESCRICAO: TStringField;
    SqlProductsPRECOCOMPRA: TFloatField;
    SqlProductsQUANTIDADE: TFloatField;
    DspProducts: TDataSetProvider;
    CdsProducts: TClientDataSet;
    CdsProductsID_PRODUTO: TFloatField;
    CdsProductsDESCRICAO: TStringField;
    CdsProductsPRECOCOMPRA: TFloatField;
    CdsProductsQUANTIDADE: TFloatField;
    DsProducts: TDataSource;
    CheckBox1: TCheckBox;
    Label1: TLabel;
    Edit2: TEdit;
    BitBtn3: TBitBtn;
    ComboBox1: TComboBox;
    BitBtn4: TBitBtn;
    BitBtn5: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton4Click(Sender: TObject);
    procedure SpeedButton5Click(Sender: TObject);
    procedure SpeedButton6Click(Sender: TObject);
    procedure SpeedButton7Click(Sender: TObject);
    procedure SpeedButton8Click(Sender: TObject);
    procedure DBGrid1TitleClick(Column: TColumn);
    procedure SqlProductsAfterOpen(DataSet: TDataSet);
    procedure BitBtn3Click(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BitBtn5Click(Sender: TObject);
    procedure CdsProductsBeforeOpen(DataSet: TDataSet);
  private
    sLastFieldOrder : String;
  public
    procedure CdsSetOrderDBGrig(var CDS    : TClientDataSet;
                                var DBG    : TDBGrid;
                                    Column : TColumn);
    procedure SQLSetOrderDBGrid(var DBG    : TDBGrid;
                                    Column : TColumn);
  end;

var
  FrmMemoryIndexOrdering: TFrmMemoryIndexOrdering;

implementation

uses UDM_DBX;

{$R *.dfm}

procedure TFrmMemoryIndexOrdering.BitBtn1Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Close;
  CdsProducts.CommandText := '';
  CdsProducts.Params[0].AsString := Edit1.Text + '%';
  CdsProducts.Open;
end;

procedure TFrmMemoryIndexOrdering.BitBtn2Click(Sender: TObject);
begin
  inherited;
  CdsProducts.ApplyUpdates(0);
end;

procedure TFrmMemoryIndexOrdering.BitBtn3Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Locate(ComboBox1.Text, Edit2.Text, []);
end;

procedure TFrmMemoryIndexOrdering.BitBtn4Click(Sender: TObject);
begin
  inherited;
  if BitBtn4.Caption = 'Apply Local Filter' then
  begin
    BitBtn4.Caption      := 'Cancel Local Filter';
    CdsProducts.Filter   := ComboBox1.Text + ' = ' + '''' + Edit2.Text + '''';
    CdsProducts.Filtered := True;
  end
  else
  begin
    BitBtn4.Caption      := 'Apply Local Filter';
    CdsProducts.Filtered := False;
  end;
end;

procedure TFrmMemoryIndexOrdering.BitBtn5Click(Sender: TObject);
var
  i : Integer;
begin
  inherited;
  CdsProducts.IndexDefs.Update;
  for i := 0 to CdsProducts.IndexDefs.Count - 1 do
  begin
    if CdsProducts.IndexDefs.Items[i].Name = ComboBox1.Text then
    begin
      CdsProducts.DeleteIndex(ComboBox1.Text);
    end;
  end;

  for i := 0 to DBGrid1.Columns.Count - 1 do
  begin
    if DBGrid1.Columns[i].Field.FieldName = ComboBox1.Text then
      DBGrid1.Columns[i].Title.Font.Color := clRed
    else
      DBGrid1.Columns[i].Title.Font.Color := clBlack;;
  end;

  CdsProducts.AddIndex(ComboBox1.Text,
                       ComboBox1.Text,
                       [],
                       '',
                       '',
                       0);
  CdsProducts.IndexName := ComboBox1.Text;

  CdsProducts.SetKey;
  CdsProducts.FieldByName(ComboBox1.Text).AsString := Edit2.Text;
  
  if not CdsProducts.GotoKey then
    ShowMessage('Record not found');
end;

procedure TFrmMemoryIndexOrdering.CdsProductsBeforeOpen(DataSet: TDataSet);
begin
  inherited;
  CdsProducts.IndexName := 'DEFAULT_ORDER';
end;

procedure TFrmMemoryIndexOrdering.CdsSetOrderDBgrig(var CDS: TClientDataSet;
  var DBG: TDBGrid; Column: TColumn);
const
  idxDefault = 'DEFAULT_ORDER';
var
  strColumn : string;
  i         : integer;
  bolUsed   : boolean;
  idOptions : TIndexOptions;
begin
  strColumn := idxDefault;

  if Column.Field.FieldKind in [fkCalculated, fkLookup, fkAggregate] then
    Exit;

  if Column.Field.DataType in [ftBlob, ftMemo] then
    Exit;

  for i := 0 to DBG.Columns.Count - 1 do
  begin
    DBG.Columns[i].Title.Font.Color := clBlack;
  end;

  DBG.Columns[Column.Index].Title.Font.Color := clRed;

  bolUsed := (Column.Field.FieldName = CDS.IndexName);

  CDS.IndexDefs.Update;
  for i := 0 to CDS.IndexDefs.Count - 1 do
  begin
    if CDS.IndexDefs.Items[i].Name = Column.Field.FieldName then
    begin
      strColumn := Column.Field.FieldName;
      case (CDS.IndexDefs.Items[i].Options = [ixDescending]) of
        True  : idOptions := [];
        False : idOptions := [ixDescending];
      end;
    end;
  end;

  if (strColumn = idxDefault) or (bolUsed) then
  begin
    if bolUsed then
      CDS.DeleteIndex(Column.Field.FieldName);
    try
      CDS.AddIndex(Column.Field.FieldName,
                   Column.Field.FieldName,
                   idOptions,
                   '',
                   '',
                   0);
      strColumn := Column.Field.FieldName;
    except
      if bolUsed then
        strColumn := idxDefault;
    end;
  end;

  try
    CDS.IndexName := strColumn;
  except
    CDS.IndexName := idxDefault;
  end;
end;

procedure TFrmMemoryIndexOrdering.DBGrid1TitleClick(Column: TColumn);
begin
  inherited;
  if CheckBox1.Checked then
  begin
    CdsSetOrderDBgrig(CdsProducts, DBGrid1, Column);
  end
  else
  begin
    SQLSetOrderDBGrid(DBGrid1, Column);
  end;
end;

procedure TFrmMemoryIndexOrdering.SpeedButton1Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Prior;
end;

procedure TFrmMemoryIndexOrdering.SpeedButton2Click(Sender: TObject);
begin
  inherited;
  CdsProducts.First;
end;

procedure TFrmMemoryIndexOrdering.SpeedButton3Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Last;  
end;

procedure TFrmMemoryIndexOrdering.SpeedButton4Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Next;
end;

procedure TFrmMemoryIndexOrdering.SpeedButton5Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Insert;
end;

procedure TFrmMemoryIndexOrdering.SpeedButton6Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Edit;
end;

procedure TFrmMemoryIndexOrdering.SpeedButton7Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Delete;
end;

procedure TFrmMemoryIndexOrdering.SpeedButton8Click(Sender: TObject);
begin
  inherited;
  CdsProducts.Cancel;
end;

procedure TFrmMemoryIndexOrdering.SqlProductsAfterOpen(DataSet: TDataSet);
begin
  inherited;
  SqlProducts.GetFieldNames(ComboBox1.Items);
end;

procedure TFrmMemoryIndexOrdering.SQLSetOrderDBGrid(var DBG: TDBGrid;
  Column: TColumn);
var
  i    : Integer;
  sSQL : String;
begin
  if Column.Field.FieldKind in [fkCalculated, fkLookup, fkAggregate] then
    Exit;

  if Column.Field.DataType in [ftBlob, ftMemo] then
    Exit;

  Screen.Cursor := crHourGlass;

  for i := 0 to DBG.Columns.Count - 1 do
  begin
    DBG.Columns[i].Title.Font.Color := clBlack;
  end;

  DBG.Columns[Column.Index].Title.Font.Color := clRed;

  if Pos(Column.Field.FieldName, sLastFieldOrder) > 0 then
  begin
    if Pos(' DESC', sLastFieldOrder) > 0 then
    begin
      sLastFieldOrder := Column.Field.FieldName;
    end
    else
    begin
      sLastFieldOrder := Column.Field.FieldName + ' DESC';
    end;
  end
  else
  begin
    sLastFieldOrder := Column.Field.FieldName;
  end;

  sSQL := ' SELECT  ID_PRODUTO, ' +
          '         DESCRICAO, ' +
          '         PRECOCOMPRA, ' +
          '         QUANTIDADE ' +
          ' FROM    PRODUTOS ' +
          ' WHERE   DESCRICAO LIKE ' + '''' + Edit1.Text + '%' + '''' + ' ' +
          ' ORDER BY ' + sLastFieldOrder;

  CdsProducts.Close;
  CdsProducts.CommandText := sSQL;
  CdsProducts.Open;

  Screen.Cursor := crDefault;
end;

end.
