unit UCadastro;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UMenu, Menus, IWCompMenu, IWVCLBaseControl, IWBaseControl,
  IWBaseHTMLControl, IWControl, IWCompRectangle, DB, DBClient, IWCompEdit,
  IWDBStdCtrls, IWCompLabel, IWCompButton, IWVCLBaseContainer, IWContainer,
  IWHTMLContainer, IWHTML40Container, IWRegion, IWAppForm;

type
  TPageCadastro = class(TPageMenu)
    IWRegion1: TIWRegion;
    btConfirmar: TIWButton;
    IWLabel1: TIWLabel;
    btCancelar: TIWButton;
    IWDBEdit1: TIWDBEdit;
    CDS: TClientDataSet;
    DS: TDataSource;
    IWLabel2: TIWLabel;
    IWDBEdit2: TIWDBEdit;
    procedure IWAppFormCreate(Sender: TObject);
    procedure btConfirmarClick(Sender: TObject);
    procedure btCancelarClick(Sender: TObject);
    procedure CDSBeforePost(DataSet: TDataSet);
    procedure CDSReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PageCadastro: TPageCadastro;

implementation

uses ServerController, UserSessionUnit;

{$R *.dfm}

procedure TPageCadastro.btCancelarClick(Sender: TObject);
begin
  inherited;
  CDS.Cancel;
  CDS.Close;
  TIWAppForm(WebApplication.ActiveForm).Release;
end;

procedure TPageCadastro.btConfirmarClick(Sender: TObject);
begin
  inherited;
  CDS.Post;
  CDS.ApplyUpdates(0);
  UserSession.nID := CDS.Fields[0].AsFloat;
  CDS.Close;
  TIWAppForm(WebApplication.ActiveForm).Release;
end;

procedure TPageCadastro.CDSBeforePost(DataSet: TDataSet);
begin
  inherited;
  if CDS.State = dsInsert then
  begin
    CDS.Fields[0].AsFloat := UserSession.RetornaID(CDS.Fields[0].FieldName);
  end;
end;

procedure TPageCadastro.CDSReconcileError(DataSet: TCustomClientDataSet;
  E: EReconcileError; UpdateKind: TUpdateKind; var Action: TReconcileAction);
begin
  inherited;
  raise EDatabaseError.Create(E.Message);
end;

procedure TPageCadastro.IWAppFormCreate(Sender: TObject);
begin
  inherited;
  if UserSession.sOPC = 'I' then
  begin
    CDS.Close;
    CDS.Params[0].AsFloat := -1;
    CDS.Params[1].AsFloat := -1;
    CDS.Open;
    CDS.Insert;
  end
  else if UserSession.sOPC = 'A' then
  begin
    CDS.Close;
    CDS.Params[0].AsFloat := -1;
    CDS.Params[1].AsFloat := UserSession.nID;
    CDS.Open;
    CDS.Edit;
  end;
end;

end.
