unit UConsClientes;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UConsulta, DB, DBClient, Menus, IWCompButton, IWExtCtrls, IWCompEdit,
  IWCompLabel, IWVCLBaseContainer, IWContainer, IWHTMLContainer,
  IWHTML40Container, IWRegion, IWGrids, IWDBGrids, IWCompMenu, IWVCLBaseControl,
  IWBaseControl, IWBaseHTMLControl, IWControl, IWCompRectangle, IWDBExtCtrls;

type
  TPageConsClientes = class(TPageConsulta)
    CDSID_CLIENTE: TFloatField;
    CDSNOME: TStringField;
    CDSSTATUS: TStringField;
    CDSCPF: TStringField;
    CDSDATACAD: TSQLTimeStampField;
    CDSFOTO: TBlobField;
    CDSVirtStatus: TStringField;
    IWDBImage1: TIWDBImage;
    btStatus: TIWButton;
    procedure CDSCalcFields(DataSet: TDataSet);
    procedure DBGColumns0TitleClick(Sender: TObject);
    procedure DBGColumns1TitleClick(Sender: TObject);
    procedure DBGColumns2TitleClick(Sender: TObject);
    procedure DBGColumns3TitleClick(Sender: TObject);
    procedure DBGColumns4TitleClick(Sender: TObject);
    procedure DBGColumns5TitleClick(Sender: TObject);
    procedure btExcluirClick(Sender: TObject);
    procedure DBGRenderCell(ACell: TIWGridCell; const ARow, AColumn: Integer);
    procedure DBGColumns6TitleClick(Sender: TObject);
    procedure btStatusClick(Sender: TObject);
    procedure btIncluirClick(Sender: TObject);
    procedure btAlterarClick(Sender: TObject);
    procedure IWAppFormRender(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PageConsClientes: TPageConsClientes;

implementation

uses ServerController, UserSessionUnit, UCadCliente;

{$R *.dfm}

procedure TPageConsClientes.btAlterarClick(Sender: TObject);
begin
  inherited;
  if UserSession.nID <> 0 then
  begin
    inherited;
    TPageCadCliente.Create(WebApplication).Show;
  end;
end;

procedure TPageConsClientes.btExcluirClick(Sender: TObject);
begin
  inherited;
  if UserSession.nID <> 0 then
  begin
    UserSession.DelCliente(UserSession.nID);
    CDS.Delete;
  end;
end;

procedure TPageConsClientes.btIncluirClick(Sender: TObject);
begin
  inherited;
  TPageCadCliente.Create(WebApplication).Show;
end;

procedure TPageConsClientes.btStatusClick(Sender: TObject);
var
  sStatus, sSQL : String;
begin
  inherited;
  if UserSession.nID <> 0 then
  begin
    if CDSSTATUS.AsString = '0' then
      sStatus := '1'
    else if CDSSTATUS.AsString = '1' then
      sStatus := '0';
  end;
  sSQL := ' UPDATE CLIENTES SET ' +
          '        CLIENTES.STATUS = ' + '''' + sStatus + '''' +
          ' WHERE  CLIENTES.ID_CLIENTE = ' + FloatToStr(UserSession.nID);
  UserSession.RunSQL(sSQL);
  CDS.RefreshRecord;
end;

procedure TPageConsClientes.CDSCalcFields(DataSet: TDataSet);
begin
  inherited;
  if CDS.State = dsInternalCalc then
  begin
    if CDSSTATUS.AsString = '0' then
      CDSVirtStatus.AsString := 'Inativo'
    else if CDSSTATUS.AsString = '1' then
      CDSVirtStatus.AsString := 'Ativo';    
  end;
end;

procedure TPageConsClientes.DBGColumns0TitleClick(Sender: TObject);
begin
  inherited;
  UserSession.OrdenaDataSet(CDS, CDS.Fields[0]);
  SetBoldTitleColumn(0);
end;

procedure TPageConsClientes.DBGColumns1TitleClick(Sender: TObject);
begin
  inherited;
  UserSession.OrdenaDataSet(CDS, CDS.Fields[1]);
  SetBoldTitleColumn(1);
end;

procedure TPageConsClientes.DBGColumns2TitleClick(Sender: TObject);
begin
  inherited;
  UserSession.OrdenaDataSet(CDS, CDS.Fields[3]);
  SetBoldTitleColumn(2);
end;

procedure TPageConsClientes.DBGColumns3TitleClick(Sender: TObject);
begin
  inherited;
  UserSession.OrdenaDataSet(CDS, CDS.Fields[4]);
  SetBoldTitleColumn(3);
end;

procedure TPageConsClientes.DBGColumns4TitleClick(Sender: TObject);
begin
  inherited;
  UserSession.OrdenaDataSet(CDS, CDS.Fields[6]);
  SetBoldTitleColumn(4);
end;

procedure TPageConsClientes.DBGColumns5TitleClick(Sender: TObject);
begin
  inherited;
  SetBoldTitleColumn(5);
end;

procedure TPageConsClientes.DBGColumns6TitleClick(Sender: TObject);
begin
  inherited;
  SetBoldTitleColumn(5);
end;

procedure TPageConsClientes.DBGRenderCell(ACell: TIWGridCell; const ARow,
  AColumn: Integer);
begin
  inherited;
  if (ARow > 0) and (AColumn = 6) then
  begin
    if CDSSTATUS.AsString = '0' then
      (ACell.Control as TIWButton).Caption := 'Ativar'
    else if CDSSTATUS.AsString = '1' then
      (ACell.Control as TIWButton).Caption := 'Inativar';   
  end;
end;

procedure TPageConsClientes.IWAppFormRender(Sender: TObject);
begin
  if (UserSession.sOPC = 'A') or (UserSession.sOPC = 'I') then
  begin
    CDS.Close;
    CDS.Params[0].AsString := '-1';
    CDS.Params[1].AsString := UserSession.sNOME;
    CDS.Open;
  end;
  UserSession.sOPC  := '';
  UserSession.sNOME := '';
end;

end.
