unit UConsProdutos;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UConsulta, DB, DBClient, Menus, IWCompButton, IWExtCtrls, IWCompEdit,
  IWCompLabel, IWVCLBaseContainer, IWContainer, IWHTMLContainer,
  IWHTML40Container, IWRegion, IWGrids, IWDBGrids, IWCompMenu, IWVCLBaseControl,
  IWBaseControl, IWBaseHTMLControl, IWControl, IWCompRectangle;

type
  TPageConsProdutos = class(TPageConsulta)
    CDSID_PRODUTO: TFloatField;
    CDSDESCRICAO: TStringField;
    CDSPRECOCOMPRA: TFloatField;
    CDSQUANTIDADE: TFloatField;
    procedure btIncluirClick(Sender: TObject);
    procedure btAlterarClick(Sender: TObject);
    procedure IWDBGrid1Columns0TitleClick(Sender: TObject);
    procedure IWDBGrid1Columns1TitleClick(Sender: TObject);
    procedure IWDBGrid1Columns2TitleClick(Sender: TObject);
    procedure IWDBGrid1Columns3TitleClick(Sender: TObject);
    procedure btExcluirClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PageConsProdutos: TPageConsProdutos;

implementation

uses ServerController, UserSessionUnit, UCadProdutos;

{$R *.dfm}

procedure TPageConsProdutos.btAlterarClick(Sender: TObject);
begin
  if UserSession.nID <> 0 then
  begin
    inherited;
    TPageCadProdutos.Create(WebApplication).Show;
  end;
end;

procedure TPageConsProdutos.btExcluirClick(Sender: TObject);
begin
  inherited;
  if UserSession.nID <> 0 then
  begin
    UserSession.DelProduto(UserSession.nID);
    CDS.Delete;
  end;
end;

procedure TPageConsProdutos.btIncluirClick(Sender: TObject);
begin
  inherited;
  TPageCadProdutos.Create(WebApplication).Show;
end;

procedure TPageConsProdutos.IWDBGrid1Columns0TitleClick(Sender: TObject);
begin
  inherited;
  UserSession.OrdenaDataSet(CDS, CDS.Fields[0]);
  SetBoldTitleColumn(0);
end;

procedure TPageConsProdutos.IWDBGrid1Columns1TitleClick(Sender: TObject);
begin
  inherited;
  UserSession.OrdenaDataSet(CDS, CDS.Fields[1]);
  SetBoldTitleColumn(1);
end;

procedure TPageConsProdutos.IWDBGrid1Columns2TitleClick(Sender: TObject);
begin
  inherited;
  UserSession.OrdenaDataSet(CDS, CDS.Fields[2]);
  SetBoldTitleColumn(2);
end;

procedure TPageConsProdutos.IWDBGrid1Columns3TitleClick(Sender: TObject);
begin
  inherited;
  UserSession.OrdenaDataSet(CDS, CDS.Fields[3]);
  SetBoldTitleColumn(3);
end;

end.
