unit UConsulta;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UMenu, Menus, IWCompMenu, IWVCLBaseControl, IWBaseControl,
  IWBaseHTMLControl, IWControl, IWCompRectangle, IWGrids, IWDBGrids,
  IWCompButton, IWCompCheckbox, IWExtCtrls, IWCompEdit, IWCompLabel,
  IWVCLBaseContainer, IWContainer, IWHTMLContainer, IWHTML40Container, IWRegion,
  DB, DBClient, IWAppForm;

type
  TPageConsulta = class(TPageMenu)
    IWRegion1: TIWRegion;
    IWLabel1: TIWLabel;
    edtConsulta: TIWEdit;
    rgTipo: TIWRadioGroup;
    btBuscar: TIWButton;
    btIncluir: TIWButton;
    btAlterar: TIWButton;
    btExcluir: TIWButton;
    DBG: TIWDBGrid;
    CDS: TClientDataSet;
    DS: TDataSource;
    procedure btBuscarClick(Sender: TObject);
    procedure btIncluirClick(Sender: TObject);
    procedure btAlterarClick(Sender: TObject);
    procedure CDSReconcileError(DataSet: TCustomClientDataSet;
      E: EReconcileError; UpdateKind: TUpdateKind;
      var Action: TReconcileAction);
    procedure IWAppFormCreate(Sender: TObject);
    procedure IWAppFormRender(Sender: TObject);
    procedure IWDBGrid1Columns0Click(ASender: TObject; const AValue: string);
    procedure SetBoldTitleColumn(index : Integer); stdcall;
    procedure CDSBeforeOpen(DataSet: TDataSet);
    procedure CDSAfterOpen(DataSet: TDataSet);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  PageConsulta: TPageConsulta;

implementation

uses ServerController, UserSessionUnit;

{$R *.dfm}

procedure TPageConsulta.btAlterarClick(Sender: TObject);
begin
  inherited;
  UserSession.sOPC := 'A';
  CDS.Close;
  TIWAppForm(WebApplication.ActiveForm).Release;
end;

procedure TPageConsulta.btBuscarClick(Sender: TObject);
begin
  inherited;
  CDS.Close;
  if rgTipo.ItemIndex = 0 then
  begin
    CDS.Params[0].AsString := edtConsulta.Text + '%';
    CDS.Params[1].AsString := '-1';
  end
  else if rgTipo.ItemIndex = 1 then
  begin
    CDS.Params[0].AsString := '-1';
    CDS.Params[1].AsString := edtConsulta.Text;
  end;
  CDS.Open; 
end;

procedure TPageConsulta.btIncluirClick(Sender: TObject);
begin
  inherited;
  UserSession.sOPC := 'I';
  UserSession.sNOME := edtConsulta.Text;
  CDS.Close;
  TIWAppForm(WebApplication.ActiveForm).Release;
end;

procedure TPageConsulta.CDSAfterOpen(DataSet: TDataSet);
begin
  inherited;
  UserSession.OrdenaDataSet(CDS, CDS.Fields[1]);
  SetBoldTitleColumn(1);
  CDS.First;
end;

procedure TPageConsulta.CDSBeforeOpen(DataSet: TDataSet);
begin
  inherited;
  CDS.IndexName := 'DEFAULT_ORDER';
end;

procedure TPageConsulta.CDSReconcileError(DataSet: TCustomClientDataSet;
  E: EReconcileError; UpdateKind: TUpdateKind; var Action: TReconcileAction);
begin
  inherited;
  raise EDatabaseError.Create(E.Message);
end;

procedure TPageConsulta.IWAppFormCreate(Sender: TObject);
begin
  inherited;
  if (UserSession.sOPC <> 'I') and (UserSession.sOPC <> 'A') then
    UserSession.nID := 0; 
end;

procedure TPageConsulta.IWAppFormRender(Sender: TObject);
begin
  inherited;
  if (UserSession.sOPC = 'A') or (UserSession.sOPC = 'I') then
  begin
    CDS.Close;
    CDS.Params[0].AsString := '-1';
    CDS.Params[1].AsFloat  := UserSession.nID;
    CDS.Open;
  end;
  UserSession.sOPC  := '';
  UserSession.sNOME := '';
end;

procedure TPageConsulta.IWDBGrid1Columns0Click(ASender: TObject;
  const AValue: string);
begin
  inherited;
  UserSession.nID := StrToFloat(AValue);
  CDS.Locate(CDS.Fields[0].FieldName, StrToFloat(AValue), []);
end;

procedure TPageConsulta.SetBoldTitleColumn(index: Integer);
var
  i : Integer;
begin
  for i := 0 to DBG.Columns.Count - 1 do
  begin
    (DBG.Columns.Items[i] as TIWDBGridColumn).Font.Style := [];
    (DBG.Columns.Items[i] as TIWDBGridColumn).Title.Font.Style := [];
  end;
  (DBG.Columns.Items[index] as TIWDBGridColumn).Font.Style := [fsBold];
  (DBG.Columns.Items[index] as TIWDBGridColumn).Title.Font.Style := [fsBold];
end;

end.
